/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.swzo.brassworksmissions.client.gui.MissionUIHelper;
import net.swzo.brassworksmissions.config.Config;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;

@EventBusSubscriber(modid="brassworksmissions", value={Dist.CLIENT})
public class MissionHud {
    private static final ResourceLocation NINE_SLICE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"textures/gui/mission_background.png");
    private static final ResourceLocation MISSION_BARS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"textures/gui/mission_bars.png");
    private static final float BACKGROUND_OPACITY = 0.8f;
    private static final int PADDING_TOP = 5;
    private static final int PADDING_RIGHT = 4;
    private static final int PADDING_BOTTOM = 4;
    private static final int PADDING_LEFT = 4;
    private static final int SLICE_SIZE = 3;

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        if (playerVariables.trackedMissions.isEmpty()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = event.getGuiGraphics().guiWidth();
        int yOffset = (Integer)Config.CLIENT.HUD_Y_OFFSET.get();
        for (int missionSlot : playerVariables.trackedMissions) {
            ActiveMission mission;
            if (missionSlot < 0 || missionSlot >= playerVariables.missionData.getMissions().length || (mission = playerVariables.missionData.getMission(missionSlot)) == null) continue;
            int missionHeight = MissionHud.drawMission(guiGraphics, mission, screenWidth, yOffset);
            yOffset += missionHeight + 5;
        }
    }

    private static int drawMission(GuiGraphics guiGraphics, ActiveMission mission, int screenWidth, int y) {
        int contentY;
        Minecraft mc = Minecraft.getInstance();
        int contentWidth = 160;
        int lineSpacing = 3;
        int barHeight = 5;
        boolean isComplete = mission.isComplete();
        int titleColor = isComplete ? MissionUIHelper.COMPLETED_TITLE_COLOR : MissionUIHelper.INCOMPLETE_TITLE_COLOR;
        MutableComponent titleComponent = Component.literal((String)mission.getTitle()).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)titleColor)));
        Component description = MissionUIHelper.getMissionDescription(mission);
        List descriptionLines = mc.font.split((FormattedText)description, 160);
        int n = descriptionLines.size();
        Objects.requireNonNull(mc.font);
        int descriptionHeight = n * 9;
        MutableComponent progressPrefix = Component.translatable((String)"gui.brassworksmissions.ui.progress").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.PROGRESS_TEXT_COLOR)));
        Component progressComponent = MissionUIHelper.getFormattedProgress(mission, (Component)progressPrefix);
        Component rewardComponent = MissionUIHelper.getFormattedReward(mission);
        boolean hasReward = !rewardComponent.getString().isEmpty();
        int contentHeight = 0;
        Objects.requireNonNull(mc.font);
        contentHeight += 9;
        contentHeight += 3;
        contentHeight += descriptionHeight;
        contentHeight += 3;
        Objects.requireNonNull(mc.font);
        contentHeight += 9;
        contentHeight += 3;
        if (hasReward) {
            Objects.requireNonNull(mc.font);
            contentHeight += 9;
            contentHeight += 3;
        }
        int bgWidth = 168;
        int bgHeight = (contentHeight += 5) + 5 + 4;
        int x = (Boolean)Config.CLIENT.LEFT_ALIGN_HUD.get() != false ? (Integer)Config.CLIENT.HUD_X_OFFSET.get() : screenWidth - bgWidth - (Integer)Config.CLIENT.HUD_X_OFFSET.get();
        MissionHud.drawNineSliceManually(guiGraphics, NINE_SLICE_BACKGROUND, x, y, bgWidth, bgHeight);
        int contentX = x + 4 + 1;
        int currentY = contentY = y + 5;
        guiGraphics.drawString(mc.font, (Component)titleComponent, contentX, currentY, 0, true);
        Objects.requireNonNull(mc.font);
        currentY += 9 + 3;
        for (FormattedCharSequence line : descriptionLines) {
            guiGraphics.drawString(mc.font, line, contentX, currentY, 0, true);
            Objects.requireNonNull(mc.font);
            currentY += 9;
        }
        guiGraphics.drawString(mc.font, progressComponent, contentX, currentY += 3, 0, true);
        Objects.requireNonNull(mc.font);
        currentY += 9 + 3;
        if (hasReward) {
            guiGraphics.drawString(mc.font, rewardComponent, contentX, currentY, 0, true);
            Objects.requireNonNull(mc.font);
            currentY += 9 + 3;
        }
        float progress = Math.min(1.0f, (float)mission.getProgress() / (float)mission.getRequiredAmount());
        boolean vEmpty = false;
        int vYellow = 5;
        int vGreen = 10;
        int vFilled = isComplete ? 10 : 5;
        MissionHud.drawProgressiveBar(guiGraphics, contentX - 1, currentY, 160, 5, progress, 0, vFilled);
        return bgHeight;
    }

    private static void drawNineSliceManually(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        int corner = 3;
        int textureSize = 9;
        int centerSliceTextureSize = 3;
        int centerWidth = width - 6;
        int centerHeight = height - 6;
        boolean uTopLeft = false;
        boolean vTopLeft = false;
        int uTopCenter = 3;
        boolean vTopCenter = false;
        int uTopRight = 6;
        boolean vTopRight = false;
        boolean uMiddleLeft = false;
        int vMiddleLeft = 3;
        int uMiddleCenter = 3;
        int vMiddleCenter = 3;
        int uMiddleRight = 6;
        int vMiddleRight = 3;
        boolean uBottomLeft = false;
        int vBottomLeft = 6;
        int uBottomCenter = 3;
        int vBottomCenter = 6;
        int uBottomRight = 6;
        int vBottomRight = 6;
        guiGraphics.blit(texture, x, y, (float)uTopLeft, (float)vTopLeft, 3, 3, 9, 9);
        guiGraphics.blit(texture, x + width - 3, y, (float)uTopRight, (float)vTopRight, 3, 3, 9, 9);
        guiGraphics.blit(texture, x, y + height - 3, (float)uBottomLeft, (float)vBottomLeft, 3, 3, 9, 9);
        guiGraphics.blit(texture, x + width - 3, y + height - 3, (float)uBottomRight, (float)vBottomRight, 3, 3, 9, 9);
        if (centerWidth > 0) {
            guiGraphics.blit(texture, x + 3, y, centerWidth, 3, (float)uTopCenter, (float)vTopCenter, 3, 3, 9, 9);
            guiGraphics.blit(texture, x + 3, y + height - 3, centerWidth, 3, (float)uBottomCenter, (float)vBottomCenter, 3, 3, 9, 9);
        }
        if (centerHeight > 0) {
            guiGraphics.blit(texture, x, y + 3, 3, centerHeight, (float)uMiddleLeft, (float)vMiddleLeft, 3, 3, 9, 9);
            guiGraphics.blit(texture, x + width - 3, y + 3, 3, centerHeight, (float)uMiddleRight, (float)vMiddleRight, 3, 3, 9, 9);
        }
        if (centerWidth > 0 && centerHeight > 0) {
            guiGraphics.blit(texture, x + 3, y + 3, centerWidth, centerHeight, (float)uMiddleCenter, (float)vMiddleCenter, 3, 3, 9, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawProgressiveBar(GuiGraphics guiGraphics, int x, int y, int width, int height, float progress, int vEmpty, int vFilled) {
        int filledRightWidth;
        int filledMiddleWidth;
        int textureSheetWidth = 11;
        int textureSheetHeight = 15;
        int leftCapWidth = 5;
        int rightCapWidth = 5;
        int middleTextureX = 5;
        int rightCapTextureX = 6;
        int middleBarWidth = width - 5 - 5;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(MISSION_BARS_TEXTURE, x, y, 0.0f, (float)vEmpty, 5, height, 11, 15);
        if (middleBarWidth > 0) {
            guiGraphics.blit(MISSION_BARS_TEXTURE, x + 5, y, middleBarWidth, height, 5.0f, (float)vEmpty, 1, height, 11, 15);
        }
        guiGraphics.blit(MISSION_BARS_TEXTURE, x + width - 5, y, 6.0f, (float)vEmpty, 5, height, 11, 15);
        int progressPixels = (int)((float)width * progress);
        if (progressPixels <= 0) {
            RenderSystem.disableBlend();
            return;
        }
        int filledLeftWidth = Math.min(progressPixels, 5);
        if (filledLeftWidth > 0) {
            guiGraphics.blit(MISSION_BARS_TEXTURE, x, y, 0.0f, (float)vFilled, filledLeftWidth, height, 11, 15);
        }
        if (progressPixels > 5 && middleBarWidth > 0 && (filledMiddleWidth = Math.min(progressPixels - 5, middleBarWidth)) > 0) {
            guiGraphics.blit(MISSION_BARS_TEXTURE, x + 5, y, filledMiddleWidth, height, 5.0f, (float)vFilled, 1, height, 11, 15);
        }
        if (progressPixels > 5 + middleBarWidth && (filledRightWidth = progressPixels - (5 + middleBarWidth)) > 0) {
            guiGraphics.blit(MISSION_BARS_TEXTURE, x + 5 + middleBarWidth, y, 6.0f, (float)vFilled, filledRightWidth, height, 11, 15);
        }
        RenderSystem.disableBlend();
    }

    public ActiveMission getMissionDataForSlot(Player player, int missionSlot) {
        if (player == null || missionSlot < 1) {
            return null;
        }
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        int missionIndex = missionSlot - 1;
        if (missionIndex < 0 || missionIndex >= playerVariables.missionData.getMissions().length) {
            return null;
        }
        return playerVariables.missionData.getMission(missionIndex);
    }
}

