/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.swzo.brassworksmissions.client.gui.MissionUIHelper;
import net.swzo.brassworksmissions.event.MissionResetHandler;

public class UiScreenRenderHelper {
    public static void renderPlayerModel(GuiGraphics guiGraphics, int mouseX, int mouseY, Player player, int screenX, int screenY, float partialTicks) {
        if (player == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        int renderX = screenX + 230;
        int renderY = screenY + 180;
        int scale = 45;
        float yLookFactor = (float)Math.atan((float)(renderX - mouseX) / 40.0f);
        float xLookFactor = (float)Math.atan((float)(renderY - 75 - mouseY) / 40.0f);
        guiGraphics.pose().translate((double)renderX, (double)renderY, 100.0);
        guiGraphics.pose().scale((float)scale, (float)scale, (float)(-scale));
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
        float originalYBodyRot = player.yBodyRot;
        float originalYHeadRot = player.yHeadRot;
        float originalXRot = player.getXRot();
        float originalYRot = player.getYRot();
        float originalYHeadRotO = player.yHeadRotO;
        float originalYRotO = player.yRotO;
        float originalXRotO = player.xRotO;
        float originalYBodyRotO = player.yBodyRotO;
        float targetBodyRot = 180.0f + yLookFactor * 20.0f;
        float targetYRot = 180.0f + yLookFactor * 40.0f;
        float targetXRot = -xLookFactor * 20.0f;
        player.yBodyRot = targetBodyRot;
        player.setYRot(targetYRot);
        player.setXRot(targetXRot);
        player.yHeadRot = targetYRot;
        player.yHeadRotO = targetYRot;
        player.yRotO = targetYRot;
        player.xRotO = targetXRot;
        player.yBodyRotO = targetBodyRot;
        dispatcher.setRenderShadow(false);
        dispatcher.render((Entity)player, 0.0, 0.0, 0.0, 0.0f, partialTicks, guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
        bufferSource.endBatch();
        dispatcher.setRenderShadow(true);
        player.yBodyRot = originalYBodyRot;
        player.setYRot(originalYRot);
        player.setXRot(originalXRot);
        player.yHeadRot = originalYHeadRot;
        player.yHeadRotO = originalYHeadRotO;
        player.yRotO = originalYRotO;
        player.xRotO = originalXRotO;
        player.yBodyRotO = originalYBodyRotO;
        Lighting.setupForFlatItems();
        guiGraphics.pose().popPose();
    }

    public static long getRemainingMillisUntilReset() {
        long nextResetTimestampInSeconds = MissionResetHandler.getNextWeeklyResetTimestamp();
        long nextResetTimestampInMillis = nextResetTimestampInSeconds * 1000L;
        return nextResetTimestampInMillis - System.currentTimeMillis();
    }

    public static Component getFormattedCountdown(long remainingMillis) {
        if (remainingMillis < 0L) {
            remainingMillis = 0L;
        }
        long hours = TimeUnit.MILLISECONDS.toHours(remainingMillis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(remainingMillis) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(remainingMillis) % 60L;
        MutableComponent component = Component.empty();
        Style valueStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.DESCRIPTION_AMOUNT_COLOR));
        Style suffixStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.DESCRIPTION_AMOUNT_SUB_COLOR));
        if (hours > 0L) {
            component.append((Component)Component.literal((String)String.valueOf(hours)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.hour.singular").getString()).withStyle(suffixStyle));
            component.append(" ");
            component.append((Component)Component.literal((String)String.valueOf(minutes)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.minute.singular").getString()).withStyle(suffixStyle));
            component.append(" ");
            component.append((Component)Component.literal((String)String.valueOf(seconds)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.second.singular").getString()).withStyle(suffixStyle));
        } else if (minutes > 0L) {
            component.append((Component)Component.literal((String)String.valueOf(minutes)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.minute.singular").getString()).withStyle(suffixStyle));
            component.append(" ");
            component.append((Component)Component.literal((String)String.valueOf(seconds)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.second.singular").getString()).withStyle(suffixStyle));
        } else {
            component.append((Component)Component.literal((String)String.valueOf(seconds)).withStyle(valueStyle));
            component.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.second.singular").getString()).withStyle(suffixStyle));
        }
        return component;
    }

    public static List<Component> getFormattedTooltipCountdown(long remainingMillis) {
        if (remainingMillis < 0L) {
            remainingMillis = 0L;
        }
        long hours = TimeUnit.MILLISECONDS.toHours(remainingMillis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(remainingMillis) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(remainingMillis) % 60L;
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        tooltipLines.add((Component)Component.translatable((String)"gui.brassworksmissions.ui.reset_tooltip_title").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
        MutableComponent timeComponent = Component.empty();
        boolean needsSeparator = false;
        Style valueStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.PROGRESS_TEXT_COLOR));
        Style suffixStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_SUBTEXT_COLOR));
        if (hours > 0L) {
            timeComponent.append((Component)Component.literal((String)String.valueOf(hours)).withStyle(valueStyle));
            timeComponent.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.hour").getString()).withStyle(suffixStyle));
            needsSeparator = true;
        }
        if (minutes > 0L) {
            if (needsSeparator) {
                timeComponent.append((Component)Component.literal((String)", ").withStyle(suffixStyle));
            }
            timeComponent.append((Component)Component.literal((String)String.valueOf(minutes)).withStyle(valueStyle));
            timeComponent.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.minute").getString()).withStyle(suffixStyle));
            needsSeparator = true;
        }
        if (seconds >= 0L) {
            if (needsSeparator) {
                timeComponent.append((Component)Component.literal((String)", ").withStyle(suffixStyle));
            }
            timeComponent.append((Component)Component.literal((String)String.valueOf(seconds)).withStyle(valueStyle));
            timeComponent.append((Component)Component.literal((String)Component.translatable((String)"gui.brassworksmissions.ui.timer.second").getString()).withStyle(suffixStyle));
        }
        if (!timeComponent.getContents().equals((Object)Component.empty())) {
            tooltipLines.add((Component)timeComponent);
        }
        return tooltipLines;
    }
}

