/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.event;

import com.simibubi.create.AllBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.IMissionType;
import net.swzo.brassworksmissions.missions.MissionRegistry;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;
import net.swzo.brassworksmissions.util.DistanceManager;

@EventBusSubscriber(modid="brassworksmissions")
public class MissionEventSubscriber {
    private static final Map<UUID, String> lastMovementType = new HashMap<UUID, String>();
    private static int lastCheckedMinute = -1;

    private static <E> void handleEvent(E event, ServerPlayer player, BiFunction<IMissionType, ActiveMission, Boolean> check) {
        boolean needsSync = false;
        ActiveMission[] missions = ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).missionData.getMissions();
        if (missions == null) {
            return;
        }
        for (ActiveMission mission : missions) {
            IMissionType type;
            if (mission == null || mission.isComplete() || (type = MissionRegistry.getMissionType(mission.getMissionType())) == null || !check.apply(type, mission).booleanValue()) continue;
            needsSync = true;
        }
        if (needsSync) {
            ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            int TIMEOUT_TICKS = 40;
            UUID uuid = player2.getUUID();
            String currentMovementType = null;
            if (player2.isFallFlying()) {
                currentMovementType = "brassworksmissions:fly_elytra";
            } else if (player2.getVehicle() instanceof Boat) {
                currentMovementType = "brassworksmissions:drive_boat";
            } else if (player2.isPassenger() && player2.getVehicle() instanceof LivingEntity) {
                currentMovementType = "brassworksmissions:ride_mob";
            } else if (AllBlocks.BELT.has(player2.level().getBlockState(player2.getOnPos()))) {
                currentMovementType = "brassworksmissions:move_on_belt";
            } else if (player2.onGround()) {
                currentMovementType = "brassworksmissions:walk";
            }
            String lastType = lastMovementType.get(uuid);
            if (currentMovementType != null) {
                if (currentMovementType.equals(lastType)) {
                    DistanceManager.track(player2, currentMovementType, 40);
                }
                lastMovementType.put(uuid, currentMovementType);
            } else {
                lastMovementType.remove(uuid);
            }
            MissionEventSubscriber.handleEvent(event, player2, (type, mission) -> type.onPlayerTick(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MissionEventSubscriber.handleEvent(event, player2, (type, mission) -> type.onBlockBroken(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MissionEventSubscriber.handleEvent(event, player2, (type, mission) -> type.onItemCrafted(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MissionEventSubscriber.handleEvent(event, player, (type, mission) -> type.onLivingDeath(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MissionEventSubscriber.handleEvent(event, player2, (type, mission) -> type.onItemFished(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onUseTotem(LivingUseTotemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MissionEventSubscriber.handleEvent(event, player, (type, mission) -> type.onLivingUseTotem(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onBreedAnimal(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MissionEventSubscriber.handleEvent(event, player2, (type, mission) -> type.onBabyEntitySpawn(event, (ActiveMission)mission));
        }
    }

    @SubscribeEvent
    public static void onItemConsumed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MissionEventSubscriber.handleEvent(event, player, (type, mission) -> type.onItemConsumed(event, (ActiveMission)mission));
        }
    }
}

