/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.missions.Mission;

public class MissionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type MISSION_LIST_TYPE = new TypeToken<List<Mission>>(){}.getType();
    private static final String DIRECTORY = "missions";
    private static final ResourceLocation REWARD_FILE_ID = ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"mission_reward");
    private List<Mission> availableMissions = new ArrayList<Mission>();
    private double totalWeight = 0.0;

    public MissionManager() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<Mission> loadedMissions = new ArrayList<Mission>();
        this.totalWeight = 0.0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            if (entry.getKey().equals((Object)REWARD_FILE_ID) || !entry.getKey().getNamespace().equals("brassworksmissions")) continue;
            try {
                List missionsFromFile = (List)GSON.fromJson(entry.getValue(), MISSION_LIST_TYPE);
                if (missionsFromFile == null) continue;
                loadedMissions.addAll(missionsFromFile);
            }
            catch (Exception e) {
                BrassworksmissionsMod.LOGGER.error("Could not parse mission file: " + String.valueOf(entry.getKey()), (Throwable)e);
            }
        }
        this.availableMissions = loadedMissions;
        for (Mission mission : this.availableMissions) {
            this.totalWeight += mission.getWeight();
        }
        BrassworksmissionsMod.LOGGER.info("Loaded {} missions with a total weight of {}", (Object)this.availableMissions.size(), (Object)this.totalWeight);
    }

    @Nullable
    public Mission getWeightedRandomMission(RandomSource random) {
        if (this.totalWeight == 0.0 || this.availableMissions.isEmpty()) {
            return null;
        }
        double randomValue = random.nextDouble() * this.totalWeight;
        for (Mission mission : this.availableMissions) {
            if (!((randomValue -= mission.getWeight()) <= 0.0)) continue;
            return mission;
        }
        return this.availableMissions.get(this.availableMissions.size() - 1);
    }
}

