/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.swzo.brassworksmissions.missions.ActiveMission;

public class PlayerMissionData {
    public static final int MISSION_SLOTS = 6;
    private final ActiveMission[] missions = new ActiveMission[6];

    @Nullable
    public ActiveMission getMission(int slot) {
        if (slot < 0 || slot >= 6) {
            return null;
        }
        return this.missions[slot];
    }

    public void setMission(int slot, @Nullable ActiveMission mission) {
        if (slot >= 0 && slot < 6) {
            this.missions[slot] = mission;
        }
    }

    public List<ActiveMission> getActiveMissions() {
        ArrayList<ActiveMission> activeMissions = new ArrayList<ActiveMission>();
        for (ActiveMission mission : this.missions) {
            if (mission == null) continue;
            activeMissions.add(mission);
        }
        return activeMissions;
    }

    public ActiveMission[] getMissions() {
        return Arrays.copyOf(this.missions, this.missions.length);
    }

    public void clear() {
        Arrays.fill(this.missions, null);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag missionList = new ListTag();
        for (ActiveMission mission : this.missions) {
            CompoundTag missionTag = new CompoundTag();
            if (mission != null) {
                missionTag.put("MissionData", (Tag)mission.serializeNBT(provider));
            }
            missionList.add((Object)missionTag);
        }
        nbt.put("Missions", (Tag)missionList);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag missionList = nbt.getList("Missions", 10);
        for (int i = 0; i < Math.min(missionList.size(), 6); ++i) {
            CompoundTag missionTag = missionList.getCompound(i);
            this.missions[i] = missionTag.contains("MissionData", 10) ? ActiveMission.deserializeNBT(provider, missionTag.getCompound("MissionData")) : null;
        }
    }
}

