/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.mixin.create;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.IMissionType;
import net.swzo.brassworksmissions.missions.MissionRegistry;
import net.swzo.brassworksmissions.missions.types.create.CreateMissionType;
import net.swzo.brassworksmissions.missions.types.create.DrillMissionType;
import net.swzo.brassworksmissions.missions.types.create.SawMissionType;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;
import net.swzo.brassworksmissions.util.MixinUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBreakingMovementBehaviour.class}, remap=false)
public class BlockBreakingMovementBehaviourMixin {
    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")})
    protected void destroyBlock(MovementContext context, BlockPos breakingPos, CallbackInfo ci) {
        ActiveMission[] missions;
        Class missionClass;
        Level level = context.world;
        if (level.isClientSide()) {
            return;
        }
        Block machineBlock = context.state.getBlock();
        if (machineBlock instanceof DrillBlock) {
            missionClass = DrillMissionType.class;
        } else if (machineBlock instanceof SawBlock) {
            missionClass = SawMissionType.class;
        } else {
            return;
        }
        BlockState brokenState = level.getBlockState(breakingPos);
        ItemStack result = brokenState.getBlock().asItem().getDefaultInstance();
        if (result.isEmpty()) {
            return;
        }
        Player player = MixinUtils.getClosestPlayer(level, breakingPos);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean needsSync = false;
        for (ActiveMission mission : missions = ((BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).missionData.getMissions()) {
            CreateMissionType missionType;
            IMissionType type = MissionRegistry.getMissionType(mission.getMissionType());
            if (mission.isComplete() || !missionClass.isInstance(type) || !(missionType = (CreateMissionType)missionClass.cast(type)).check(result, mission)) continue;
            needsSync = true;
        }
        if (needsSync) {
            ((BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)serverPlayer);
        }
    }
}

