/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.swzo.brassworksmissions.config.Config;
import net.swzo.brassworksmissions.init.BrassworksmissionsModMenus;
import net.swzo.brassworksmissions.init.CustomStats;
import net.swzo.brassworksmissions.missions.MissionManager;
import net.swzo.brassworksmissions.missions.MissionRegistry;
import net.swzo.brassworksmissions.missions.reward.RewardManager;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;
import org.slf4j.Logger;

@Mod(value="brassworksmissions")
public class BrassworksmissionsMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "brassworksmissions";
    private static final MissionManager missionManager = new MissionManager();
    private static RewardManager rewardManager = new RewardManager();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public BrassworksmissionsMod(IEventBus modEventBus, ModContainer container) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        modEventBus.addListener(this::commonSetup);
        CustomStats.CUSTOM_STATS.register(modEventBus);
        BrassworksmissionsModVariables.ATTACHMENT_TYPES.register(modEventBus);
        BrassworksmissionsModMenus.REGISTRY.register(modEventBus);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(MissionRegistry::registerMissionTypes);
    }

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)missionManager);
        event.addListener((PreparableReloadListener)rewardManager);
    }

    public static MissionManager getMissionManager() {
        return missionManager;
    }

    public static RewardManager getRewardManager() {
        return rewardManager;
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

