/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.swzo.brassworksmissions.missions.MissionController;
import net.swzo.brassworksmissions.util.UiUtils;

@EventBusSubscriber
public class MissionCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"missions").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UiUtils.openUi((LevelAccessor)player.level(), player.getX(), player.getY(), player.getZ(), (Entity)player);
            return 1;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reassign").requires(source -> source.hasPermission(2))).executes(context -> MissionCommand.reassignMissions((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.reassignMissions((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reroll").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).executes(context -> MissionCommand.rerollMission((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.rerollMission((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"claim").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).executes(context -> MissionCommand.claimMission((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.claimMission((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"claim_all").requires(source -> source.hasPermission(2))).executes(context -> MissionCommand.claimAllMissions((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.claimAllMissions((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"complete").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.completeMission((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset_reroll_cost").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MissionCommand.resetRerollCost((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))));
    }

    private static int reassignMissions(CommandSourceStack source, ServerPlayer target) {
        boolean isSelf;
        MissionController.reassignMissions(target);
        boolean bl = isSelf = source.getPlayer() == target;
        if (isSelf) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7aYour missions have been reassigned."), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)("\u00a7aReassigned all missions for " + target.getName().getString())), true);
            target.sendSystemMessage((Component)Component.literal((String)"\u00a7eAn administrator has reassigned your missions."));
        }
        return 1;
    }

    private static int rerollMission(CommandSourceStack source, ServerPlayer target, int slot) {
        boolean isSelf;
        MissionController.forceRerollMission(target, slot - 1);
        boolean bl = isSelf = source.getPlayer() == target;
        if (!isSelf) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eAttempted to reroll mission in slot " + slot + " for " + target.getName().getString())), true);
        }
        return 1;
    }

    private static int claimMission(CommandSourceStack source, ServerPlayer target, int slot) {
        boolean isSelf;
        boolean success = MissionController.claimReward(target, slot - 1);
        boolean bl = isSelf = source.getPlayer() == target;
        if (success) {
            if (isSelf) {
                source.sendSuccess(() -> Component.literal((String)("\u00a7aSuccessfully claimed reward in slot " + slot + ".")), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)("\u00a7aSuccessfully claimed reward in slot " + slot + " for " + target.getName().getString())), true);
            }
        } else {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to claim reward in slot " + slot + ". (Is it complete and unclaimed?)")));
        }
        return success ? 1 : 0;
    }

    private static int claimAllMissions(CommandSourceStack source, ServerPlayer target) {
        boolean isSelf;
        boolean success = MissionController.claimAllRewards(target);
        boolean bl = isSelf = source.getPlayer() == target;
        if (success) {
            if (isSelf) {
                source.sendSuccess(() -> Component.literal((String)"\u00a7aSuccessfully claimed all available rewards."), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)("\u00a7aSuccessfully claimed all available rewards for " + target.getName().getString())), true);
            }
        } else {
            source.sendFailure((Component)Component.literal((String)("\u00a7cNo available mission rewards to claim for " + target.getName().getString())));
        }
        return success ? 1 : 0;
    }

    private static int completeMission(CommandSourceStack source, ServerPlayer target, int slot) {
        boolean success = MissionController.forceCompleteMission(target, slot - 1);
        if (success) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7aForce-completed mission in slot " + slot + " for " + target.getName().getString())), true);
            target.sendSystemMessage((Component)Component.literal((String)("\u00a7eAn administrator has completed your mission in slot " + slot + ".")));
        } else {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to complete mission in slot " + slot + ". (Is it non-existent or already complete?)")));
        }
        return success ? 1 : 0;
    }

    private static int resetRerollCost(CommandSourceStack source, ServerPlayer target) {
        MissionController.resetRerollCost(target);
        source.sendSuccess(() -> Component.literal((String)("\u00a7aReset reroll cost for " + target.getName().getString())), true);
        target.sendSystemMessage((Component)Component.literal((String)"\u00a7eAn administrator has reset your mission reroll cost."));
        return 1;
    }
}

