/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ActiveMission {
    private String missionType;
    private String title;
    private ItemStack requirementItemStack;
    private int requiredAmount;
    private String requirementType;
    private ItemStack rewardItemStack;
    private int progress;
    private boolean claimed;

    public ActiveMission(String missionType, String title, ItemStack requirementItemStack, int requiredAmount, String requirementType, ItemStack rewardItemStack) {
        this.missionType = missionType;
        this.title = title;
        this.requirementItemStack = requirementItemStack;
        this.requiredAmount = requiredAmount;
        this.requirementType = requirementType;
        this.rewardItemStack = rewardItemStack;
        this.progress = 0;
        this.claimed = false;
    }

    private ActiveMission() {
    }

    public String getTitle() {
        return this.title;
    }

    public int getProgress() {
        return this.progress;
    }

    public ItemStack getRequirementItemStack() {
        return this.requirementItemStack.copy();
    }

    public ItemStack getRewardItemStack() {
        return this.rewardItemStack.copy();
    }

    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    public String getMissionType() {
        return this.missionType;
    }

    public boolean isComplete() {
        return this.progress >= this.requiredAmount;
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public String getRequirementType() {
        return this.requirementType;
    }

    public boolean isRequirementType(String type) {
        return this.requirementType != null && this.requirementType.equalsIgnoreCase(type);
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public void incrementProgress(int amount) {
        if (!this.isComplete()) {
            this.progress = Math.min(this.progress + amount, this.requiredAmount);
        }
    }

    public void setProgress(int progress) {
        this.progress = Math.min(progress, this.requiredAmount);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("missionType", this.missionType);
        nbt.putString("title", this.title);
        if (this.requirementItemStack != null && !this.requirementItemStack.isEmpty()) {
            nbt.put("requirementItem", this.requirementItemStack.save(provider));
        }
        nbt.putInt("requiredAmount", this.requiredAmount);
        if (this.requirementType != null) {
            nbt.putString("requirementType", this.requirementType);
        }
        nbt.put("rewardItem", this.rewardItemStack.save(provider));
        nbt.putInt("progress", this.progress);
        nbt.putBoolean("claimed", this.claimed);
        return nbt;
    }

    public static ActiveMission deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ActiveMission mission = new ActiveMission();
        mission.missionType = nbt.getString("missionType");
        mission.title = nbt.getString("title");
        mission.requirementItemStack = nbt.contains("requirementItem") ? ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("requirementItem")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        mission.requiredAmount = nbt.getInt("requiredAmount");
        if (nbt.contains("requirementType", 8)) {
            mission.requirementType = nbt.getString("requirementType");
        } else if (nbt.contains("isItemRequirement")) {
            mission.requirementType = nbt.getBoolean("isItemRequirement") ? "item" : "block";
        }
        mission.rewardItemStack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("rewardItem")).orElse(ItemStack.EMPTY);
        mission.progress = nbt.getInt("progress");
        mission.claimed = nbt.getBoolean("claimed");
        return mission;
    }
}

