/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.swzo.brassworksmissions.missions.ActiveMission;

public class PlayerMissionData {
    public static final int MISSION_SLOTS = 6;
    private final ActiveMission[] missions = new ActiveMission[6];

    @Nullable
    public ActiveMission getMission(int slot) {
        if (slot < 0 || slot >= 6) {
            return null;
        }
        return this.missions[slot];
    }

    public void setMission(int slot, ActiveMission mission) {
        if (slot >= 0 && slot < 6) {
            this.missions[slot] = mission;
        }
    }

    public ActiveMission[] getMissions() {
        return this.missions;
    }

    public void clear() {
        for (int i = 0; i < 6; ++i) {
            this.missions[i] = null;
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag missionList = new ListTag();
        for (int i = 0; i < 6; ++i) {
            CompoundTag missionTag = new CompoundTag();
            if (this.missions[i] != null) {
                missionTag.put("MissionData", (Tag)this.missions[i].serializeNBT(provider));
            }
            missionList.add((Object)missionTag);
        }
        nbt.put("Missions", (Tag)missionList);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag missionList = nbt.getList("Missions", 10);
        for (int i = 0; i < Math.min(missionList.size(), 6); ++i) {
            CompoundTag missionTag = missionList.getCompound(i);
            this.missions[i] = missionTag.contains("MissionData", 10) ? ActiveMission.deserializeNBT(provider, missionTag.getCompound("MissionData")) : null;
        }
    }
}

