/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.swzo.brassworksmissions.missions.types.vanilla.AbstractDistanceMissionType;

public class DistanceManager {
    private static final Map<UUID, Map<String, Vec3>> lastPositions = new HashMap<UUID, Map<String, Vec3>>();
    private static final Map<UUID, Map<String, Double>> accumulatedDistances = new HashMap<UUID, Map<String, Double>>();
    private static final Map<UUID, Map<String, Long>> lastTickTracked = new HashMap<UUID, Map<String, Long>>();

    public static void track(ServerPlayer player, String missionId, int timeoutTicks) {
        double distance;
        long tickDiff;
        UUID uuid = player.getUUID();
        long currentTime = player.level().getGameTime();
        lastPositions.computeIfAbsent(uuid, k -> new HashMap());
        accumulatedDistances.computeIfAbsent(uuid, k -> new HashMap());
        lastTickTracked.computeIfAbsent(uuid, k -> new HashMap());
        long lastTime = lastTickTracked.get(uuid).getOrDefault(missionId, currentTime);
        if (currentTime - lastTime > (long)timeoutTicks) {
            accumulatedDistances.get(uuid).put(missionId, 0.0);
        }
        Vec3 currentPos = player.position();
        Vec3 lastPos = lastPositions.get(uuid).get(missionId);
        if (lastPos != null && (tickDiff = currentTime - lastTime) <= 40L && (distance = currentPos.distanceTo(lastPos)) > 0.01) {
            double total = accumulatedDistances.get(uuid).getOrDefault(missionId, 0.0) + distance;
            if (total >= 1.0) {
                int fullBlocks = (int)total;
                AbstractDistanceMissionType.handleDistanceChange(player, missionId, fullBlocks);
                total -= (double)fullBlocks;
            }
            accumulatedDistances.get(uuid).put(missionId, total);
        }
        lastPositions.get(uuid).put(missionId, currentPos);
        lastTickTracked.get(uuid).put(missionId, currentTime);
    }
}

