/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.IMissionType;
import net.swzo.brassworksmissions.missions.MissionRegistry;
import net.swzo.brassworksmissions.missions.types.create.CreateMissionType;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;

public class MixinUtils {
    public static <T extends CreateMissionType<?>> void handleMixinMissionItem(BlockEntity be, Class<T> missionClass, ItemStack output) {
        Level level = be.getLevel();
        if (level == null || level.isClientSide() || output.isEmpty()) {
            return;
        }
        BlockPos worldPosition = be.getBlockPos();
        Player player = MixinUtils.getClosestPlayer(level, worldPosition);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BrassworksmissionsModVariables.PlayerVariables missionsCapability = (BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        ActiveMission[] missions = missionsCapability.missionData.getMissions();
        boolean needsSync = false;
        for (ActiveMission mission : missions) {
            CreateMissionType missionType;
            IMissionType type = MissionRegistry.getMissionType(mission.getMissionType());
            if (mission.isComplete() || !missionClass.isInstance(type) || !(missionType = (CreateMissionType)missionClass.cast(type)).check(output, mission)) continue;
            needsSync = true;
        }
        if (needsSync) {
            missionsCapability.syncPlayerVariables((Entity)serverPlayer);
        }
    }

    public static <T extends CreateMissionType<?>> void handlePlayerMissionIncrement(Player player, Class<T> missionClass, ItemStack itemStack) {
        if (player == null || player.level().isClientSide() || itemStack.isEmpty()) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BrassworksmissionsModVariables.PlayerVariables missionsCapability = (BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        ActiveMission[] missions = missionsCapability.missionData.getMissions();
        boolean needsSync = false;
        for (ActiveMission mission : missions) {
            CreateMissionType missionType;
            IMissionType type = MissionRegistry.getMissionType(mission.getMissionType());
            if (mission.isComplete() || !missionClass.isInstance(type) || !(missionType = (CreateMissionType)missionClass.cast(type)).check(itemStack, mission)) continue;
            needsSync = true;
        }
        if (needsSync) {
            missionsCapability.syncPlayerVariables((Entity)serverPlayer);
        }
    }

    public static Player getClosestPlayer(Level level, BlockPos worldPosition) {
        if (level == null) {
            return null;
        }
        return level.getNearestPlayer((double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.5, (double)worldPosition.getZ() + 0.5, 128.0, false);
    }
}

