/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.config;

import java.time.DayOfWeek;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        ModConfigSpec.Builder clientBuilder = new ModConfigSpec.Builder();
        CLIENT = new Client(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
        ModConfigSpec.Builder serverBuilder = new ModConfigSpec.Builder();
        SERVER = new Server(serverBuilder);
        SERVER_SPEC = serverBuilder.build();
    }

    public static class Client {
        public final ModConfigSpec.IntValue HUD_X_OFFSET;
        public final ModConfigSpec.IntValue HUD_Y_OFFSET;
        public final ModConfigSpec.BooleanValue LEFT_ALIGN_HUD;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("Mission HUD");
            this.HUD_X_OFFSET = builder.comment("X offset for the mission HUD from the corner of the screen.").defineInRange("hudXOffset", 4, 0, Integer.MAX_VALUE);
            this.HUD_Y_OFFSET = builder.comment("Y offset for the mission HUD from the corner of the screen.").defineInRange("hudYOffset", 4, 0, Integer.MAX_VALUE);
            this.LEFT_ALIGN_HUD = builder.comment("Align the mission HUD to the left side of the screen instead of the right.").define("leftAlignHud", false);
            builder.pop();
        }
    }

    public static class Server {
        public final ModConfigSpec.ConfigValue<List<? extends String>> MISSION_RESET_DAYS;
        public final ModConfigSpec.IntValue MISSION_RESET_HOUR;

        public Server(ModConfigSpec.Builder builder) {
            builder.push("Mission Reset");
            this.MISSION_RESET_DAYS = builder.comment(new String[]{"A list of days of the week (in English, uppercase) on which to reset missions.", "Example: [\"SUNDAY\", \"WEDNESDAY\"]"}).defineList("missionResetDays", List.of("SUNDAY"), obj -> {
                if (obj instanceof String) {
                    String day = (String)obj;
                    try {
                        DayOfWeek.valueOf(day.toUpperCase());
                        return true;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                return false;
            });
            this.MISSION_RESET_HOUR = builder.comment("The hour (0-23) in UTC to reset missions on the specified days.").defineInRange("missionResetHour", 0, 0, 23);
            builder.pop();
        }
    }
}

