/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.init.CustomStats;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.Mission;
import net.swzo.brassworksmissions.missions.PlayerMissionData;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;

public class MissionController {
    private static final Map<Integer, ResourceLocation> ADVANCEMENT_THRESHOLDS = Map.of(10, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_10"), 50, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_50"), 100, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_100"), 250, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_250"), 500, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_500"), 1000, ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"missions_1000"));

    public static PlayerMissionData getMissionData(Player player) {
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        if (playerVariables.missionData == null) {
            playerVariables.missionData = new PlayerMissionData();
        }
        return playerVariables.missionData;
    }

    @Nullable
    public static ActiveMission getMissionInSlot(Player player, int slot) {
        PlayerMissionData data = MissionController.getMissionData(player);
        if (data == null || slot < 0 || slot >= 6) {
            return null;
        }
        return data.getMission(slot);
    }

    public static void reassignMissions(ServerPlayer player) {
        PlayerMissionData data = MissionController.getMissionData((Player)player);
        if (data == null) {
            return;
        }
        data.clear();
        RandomSource random = player.getRandom();
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        playerVariables.reRollAmount = 1;
        HashSet<String> assignedMissionIds = new HashSet<String>();
        ArrayList<Mission> missionsToAssign = new ArrayList<Mission>();
        int maxAttempts = 120;
        for (int attempts = 0; missionsToAssign.size() < 6 && attempts < maxAttempts; ++attempts) {
            Mission potentialMission = BrassworksmissionsMod.getMissionManager().getWeightedRandomMission(random);
            if (potentialMission == null || assignedMissionIds.contains(potentialMission.getId())) continue;
            missionsToAssign.add(potentialMission);
            assignedMissionIds.add(potentialMission.getId());
        }
        for (int i = 0; i < missionsToAssign.size(); ++i) {
            Mission missionTemplate = (Mission)missionsToAssign.get(i);
            data.setMission(i, missionTemplate.createInstance(random));
        }
        if (missionsToAssign.size() < 6) {
            BrassworksmissionsMod.LOGGER.warn("Could not find enough unique missions for player {}. Filled {} of {} slots.", new Object[]{player.getName().getString(), missionsToAssign.size(), 6});
        }
        playerVariables.trackedMissions.clear();
        playerVariables.syncPlayerVariables((Entity)player);
    }

    @Nullable
    private static Mission findUniqueMissionForSlot(Player player, int excludedSlot, RandomSource random) {
        PlayerMissionData data = MissionController.getMissionData(player);
        if (data == null) {
            return null;
        }
        HashSet<String> existingMissionIds = new HashSet<String>();
        for (int i = 0; i < 6; ++i) {
            ActiveMission mission;
            if (i == excludedSlot || (mission = data.getMission(i)) == null) continue;
            existingMissionIds.add(mission.getMissionType());
        }
        int maxAttempts = 20;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            Mission potentialMission = BrassworksmissionsMod.getMissionManager().getWeightedRandomMission(random);
            if (potentialMission == null || existingMissionIds.contains(potentialMission.getId())) continue;
            return potentialMission;
        }
        BrassworksmissionsMod.LOGGER.warn("Could not find a unique mission to reroll for player {} after {} attempts. A non-unique mission may be assigned.", (Object)player.getName().getString(), (Object)maxAttempts);
        return BrassworksmissionsMod.getMissionManager().getWeightedRandomMission(random);
    }

    public static void rerollMission(ServerPlayer player, int slot) {
        if (MissionController.isMissionCompleted((Player)player, slot)) {
            player.sendSystemMessage((Component)Component.translatable((String)"gui.brassworksmissions.error.completed_mission").withStyle(ChatFormatting.RED));
            return;
        }
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        int rerollCost = playerVariables.reRollAmount * 2;
        int cappedCost = Math.min(rerollCost, 32);
        Item rerollitem = BrassworksmissionsMod.getRewardManager().getRewardItem().getItem();
        ItemStack rerollstack = new ItemStack((ItemLike)rerollitem);
        if (playerVariables.reRollAmount * 2 > 32) {
            player.sendSystemMessage((Component)Component.translatable((String)"gui.brassworksmissions.error.cost_cap_reached", (Object[])new Object[]{rerollstack.getHoverName().copy().append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"))}).withStyle(ChatFormatting.RED));
            return;
        }
        int playerOwned = player.getInventory().countItem(rerollitem);
        if (playerOwned < cappedCost) {
            player.sendSystemMessage((Component)Component.translatable((String)"gui.brassworksmissions.error.not_enough", (Object[])new Object[]{cappedCost, rerollstack.getHoverName().copy().append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"))}).withStyle(ChatFormatting.RED));
            return;
        }
        player.getInventory().clearOrCountMatchingItems(stack -> stack.is(rerollitem), cappedCost, (Container)player.inventoryMenu.getCraftSlots());
        player.inventoryMenu.broadcastChanges();
        player.sendSystemMessage((Component)Component.translatable((String)"gui.brassworksmissions.success.rerolled", (Object[])new Object[]{cappedCost, rerollstack.getHoverName().copy().append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"))}).withStyle(ChatFormatting.GREEN));
        ++playerVariables.reRollAmount;
        playerVariables.syncPlayerVariables((Entity)player);
        PlayerMissionData data = MissionController.getMissionData((Player)player);
        if (data == null || slot < 0 || slot >= 6) {
            return;
        }
        RandomSource random = player.getRandom();
        Mission missionTemplate = MissionController.findUniqueMissionForSlot((Player)player, slot, random);
        if (missionTemplate != null) {
            data.setMission(slot, missionTemplate.createInstance(random));
            playerVariables.syncPlayerVariables((Entity)player);
        }
    }

    public static void forceRerollMission(ServerPlayer player, int slot) {
        PlayerMissionData data = MissionController.getMissionData((Player)player);
        if (data == null || slot < 0 || slot >= 6) {
            return;
        }
        RandomSource random = player.getRandom();
        Mission missionTemplate = MissionController.findUniqueMissionForSlot((Player)player, slot, random);
        if (missionTemplate != null) {
            data.setMission(slot, missionTemplate.createInstance(random));
            ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)player);
        }
    }

    public static boolean isMissionCompleted(Player player, int slot) {
        ActiveMission mission = MissionController.getMissionInSlot(player, slot);
        return mission != null && mission.isComplete();
    }

    public static void resetRerollCost(ServerPlayer player) {
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        if (playerVariables.reRollAmount > 1) {
            playerVariables.reRollAmount = 1;
            playerVariables.syncPlayerVariables((Entity)player);
        }
    }

    public static boolean forceCompleteMission(ServerPlayer player, int slot) {
        ActiveMission mission = MissionController.getMissionInSlot((Player)player, slot);
        if (mission == null || mission.isComplete()) {
            return false;
        }
        int targetAmount = mission.getRequiredAmount();
        mission.setProgress(targetAmount);
        ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)player);
        return true;
    }

    private static boolean claimRewardInternal(ServerPlayer player, int slot) {
        ActiveMission mission = MissionController.getMissionInSlot((Player)player, slot);
        if (mission == null || !mission.isComplete() || mission.isClaimed()) {
            return false;
        }
        mission.setClaimed(true);
        ItemStack rewardStack = mission.getRewardItemStack().copy();
        boolean inserted = player.getInventory().add(rewardStack);
        if (!rewardStack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), rewardStack);
            itemEntity.setNoPickUpDelay();
            player.level().addFreshEntity((Entity)itemEntity);
        }
        player.awardStat((ResourceLocation)CustomStats.MISSIONS_COMPLETED.get());
        MissionController.checkAndGrantAdvancements(player);
        return true;
    }

    public static boolean claimReward(ServerPlayer player, int slot) {
        boolean success = MissionController.claimRewardInternal(player, slot);
        if (success) {
            ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)player);
        }
        return success;
    }

    public static boolean claimAllRewards(ServerPlayer player) {
        boolean anyClaimed = false;
        for (int i = 0; i < 6; ++i) {
            if (!MissionController.claimRewardInternal(player, i)) continue;
            anyClaimed = true;
        }
        if (anyClaimed) {
            ((BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)player);
        }
        return anyClaimed;
    }

    public static int getTotalClaimableItemCount(Player player) {
        PlayerMissionData data = MissionController.getMissionData(player);
        if (data == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            ActiveMission mission = data.getMission(i);
            if (mission == null || !mission.isComplete() || mission.isClaimed()) continue;
            count += mission.getRewardItemStack().getCount();
        }
        return count;
    }

    private static void checkAndGrantAdvancements(ServerPlayer player) {
        int completedMissions = player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)CustomStats.MISSIONS_COMPLETED.get())));
        for (Map.Entry<Integer, ResourceLocation> entry : ADVANCEMENT_THRESHOLDS.entrySet()) {
            AdvancementHolder advancement;
            int requiredCount = entry.getKey();
            ResourceLocation advancementId = entry.getValue();
            if (completedMissions < requiredCount || (advancement = player.server.getAdvancements().get(advancementId)) == null) continue;
            for (String criterion : advancement.value().criteria().keySet()) {
                player.getAdvancements().award(advancement, criterion);
            }
        }
    }
}

