/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.util;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.swzo.brassworksmissions.world.inventory.UiMenu;

public class UiUtils {
    public static void openUi(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            final BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Ui");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new UiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(blockPos));
                }
            }, blockPos);
        }
    }

    public static void closeUi(Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.closeContainer();
        }
    }
}

