/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.swzo.brassworksmissions.missions.ActiveMission;

public class MissionUIHelper {
    public static int INCOMPLETE_TITLE_COLOR = 15912360;
    public static int COMPLETED_TITLE_COLOR = 10802350;
    public static int PROGRESS_TEXT_COLOR = 11051157;
    public static int PROGRESS_CURRENT_COLOR = 16643811;
    public static int PROGRESS_SLASH_COLOR = 11051157;
    public static int PROGRESS_REQUIRED_COLOR = 16643811;
    public static int DESCRIPTION_VERB_COLOR = 11051157;
    public static int DESCRIPTION_PUNCTUATION_COLOR = 11051157;
    public static int DESCRIPTION_AMOUNT_COLOR = 16643811;
    public static int DESCRIPTION_AMOUNT_SUB_COLOR = 14078403;
    public static int DESCRIPTION_ITEM_COLOR = 15912360;
    public static int REWARD_TEXT_COLOR = 11051157;
    public static int REWARD_PUNCTUATION_COLOR = 11051157;
    public static int REWARD_AMOUNT_COLOR = 16643811;
    public static int REWARD_ITEM_COLOR = 15046811;
    public static int TOOLTIP_HEADER_COLOR = 15912360;
    public static int TOOLTIP_TEXT_COLOR = 11051157;
    public static int TOOLTIP_SUBTEXT_COLOR = 9076853;
    public static int TOOLTIP_ERROR_COLOR = 15046811;
    public static int SELECTOR_PREFIX_COLOR = 16643811;
    public static int SELECTOR_VALUE_COLOR = 15912360;
    public static int SCROLLER_SELECTED_COMPLETED_COLOR = 10802350;
    public static int SCROLLER_SELECTED_INCOMPLETE_COLOR = 15912360;
    public static int SCROLLER_UNSELECTED_COMPLETED_COLOR = 8496520;
    public static int SCROLLER_UNSELECTED_INCOMPLETE_COLOR = 9735041;
    private static final Map<String, String> MISSION_VERBS = Map.ofEntries(Map.entry("brassworksmissions:break_block", "mission.brassworksmissions.verb.break"), Map.entry("brassworksmissions:reach_experience_level", "mission.brassworksmissions.verb.reach"), Map.entry("brassworksmissions:use_totem", "mission.brassworksmissions.verb.use"), Map.entry("brassworksmissions:fish_item", "mission.brassworksmissions.verb.fish"), Map.entry("brassworksmissions:craft_item", "mission.brassworksmissions.verb.craft"), Map.entry("brassworksmissions:kill_entity", "mission.brassworksmissions.verb.kill"), Map.entry("brassworksmissions:breed_animals", "mission.brassworksmissions.verb.breed"), Map.entry("brassworksmissions:consume_item", "mission.brassworksmissions.verb.consume"), Map.entry("brassworksmissions:walk", "mission.brassworksmissions.verb.walk"), Map.entry("brassworksmissions:drive_boat", "mission.brassworksmissions.verb.travel"), Map.entry("brassworksmissions:travel_by_chain_conveyor", "mission.brassworksmissions.verb.travel"), Map.entry("brassworksmissions:fly_elytra", "mission.brassworksmissions.verb.fly"), Map.entry("brassworksmissions:ride_mob", "mission.brassworksmissions.verb.ride"), Map.entry("brassworksmissions:eat_cake_slice", "mission.brassworksmissions.verb.eat"), Map.entry("brassworksmissions:move_on_belt", "mission.brassworksmissions.verb.travel"), Map.entry("brassworksmissions:saw", "mission.brassworksmissions.verb.saw"), Map.entry("brassworksmissions:drill_block", "mission.brassworksmissions.verb.drill"), Map.entry("brassworksmissions:harvest", "mission.brassworksmissions.verb.farm"), Map.entry("brassworksmissions:mechanical_craft", "mission.brassworksmissions.verb.craft"), Map.entry("brassworksmissions:mix_item", "mission.brassworksmissions.verb.process"), Map.entry("brassworksmissions:compact_item", "mission.brassworksmissions.verb.process"), Map.entry("brassworksmissions:press_item", "mission.brassworksmissions.verb.process"), Map.entry("brassworksmissions:crush_item", "mission.brassworksmissions.verb.process"), Map.entry("brassworksmissions:mill_item", "mission.brassworksmissions.verb.process"), Map.entry("brassworksmissions:cut_item", "mission.brassworksmissions.verb.process"));
    private static final Map<String, String> CUSTOM_NOUNS = Map.ofEntries(Map.entry("brassworksmissions:reach_experience_level", "mission.brassworksmissions.noun.level"), Map.entry("brassworksmissions:walk", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:drive_boat", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:fly_elytra", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:ride_mob", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:move_on_belt", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:travel_by_chain_conveyor", "mission.brassworksmissions.noun.blocks"), Map.entry("brassworksmissions:eat_cake_slice", "mission.brassworksmissions.noun.cake_slice"));
    private static final Map<String, String> SUFFIX_VERBS = Map.ofEntries(Map.entry("brassworksmissions:drive_boat", "mission.brassworksmissions.suffix.by_boat"), Map.entry("brassworksmissions:fly_elytra", "mission.brassworksmissions.suffix.with_elytra"), Map.entry("brassworksmissions:move_on_belt", "mission.brassworksmissions.suffix.by_belt"), Map.entry("brassworksmissions:travel_by_chain_conveyor", "mission.brassworksmissions.suffix.by_chain_conveyor"), Map.entry("brassworksmissions:mechanical_craft", "mission.brassworksmissions.suffix.mechanically"), Map.entry("brassworksmissions:harvest", "mission.brassworksmissions.suffix.by_harvester"), Map.entry("brassworksmissions:mix_item", "mission.brassworksmissions.suffix.by_mixing"), Map.entry("brassworksmissions:compact_item", "mission.brassworksmissions.suffix.by_compacting"), Map.entry("brassworksmissions:press_item", "mission.brassworksmissions.suffix.by_pressing"), Map.entry("brassworksmissions:crush_item", "mission.brassworksmissions.suffix.by_crushing"), Map.entry("brassworksmissions:mill_item", "mission.brassworksmissions.suffix.by_milling"), Map.entry("brassworksmissions:cut_item", "mission.brassworksmissions.suffix.by_cutting"));

    private static Component getPluralizedComponent(Component singular, int amount) {
        if (amount == 1) {
            return singular;
        }
        if (singular.getString().endsWith("s") || singular.getString().endsWith("S")) {
            return singular;
        }
        String translatedPluralKeyword = Component.translatable((String)"gui.brassworksmissions.ui.plural_format").getString();
        return Component.literal((String)(singular.getString() + translatedPluralKeyword)).setStyle(singular.getStyle());
    }

    public static Component getMissionDescription(ActiveMission mission) {
        MutableComponent nounComponent;
        int nounColor;
        if (mission == null) {
            return Component.empty();
        }
        String missionType = mission.getMissionType() != null ? mission.getMissionType() : "";
        String verbKey = MISSION_VERBS.getOrDefault(missionType, "mission.brassworksmissions.verb.objective");
        MutableComponent verbComponent = Component.translatable((String)verbKey).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_VERB_COLOR)));
        MutableComponent punctuationComponent = Component.translatable((String)"mission.brassworksmissions.prefix.punctuation").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_PUNCTUATION_COLOR)));
        MutableComponent amountComponent = Component.literal((String)String.valueOf(mission.getRequiredAmount())).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_AMOUNT_COLOR)));
        MutableComponent description = verbComponent.copy().append((Component)punctuationComponent);
        MutableComponent prefixComponent = Component.translatable((String)"gui.brassworksmissions.ui.amount_prefix");
        if (!prefixComponent.getString().trim().isEmpty()) {
            description.append("").append((Component)prefixComponent.copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_VERB_COLOR))));
        }
        description.append("").append((Component)amountComponent);
        boolean isComplete = mission.getProgress() >= mission.getRequiredAmount();
        int n = nounColor = isComplete ? COMPLETED_TITLE_COLOR : DESCRIPTION_ITEM_COLOR;
        if (CUSTOM_NOUNS.containsKey(missionType)) {
            String nounKey = CUSTOM_NOUNS.get(missionType);
            MutableComponent singularNoun = Component.translatable((String)nounKey);
            nounComponent = MissionUIHelper.getPluralizedComponent((Component)singularNoun, mission.getRequiredAmount()).copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)nounColor)));
        } else {
            Component nameComponent;
            ItemStack requirementStack = mission.getRequirementItemStack();
            Item requirementItem = requirementStack.getItem();
            if (requirementItem instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)requirementItem;
                EntityType entityType = spawnEggItem.getType(requirementStack);
                nameComponent = entityType.getDescription();
            } else {
                nameComponent = requirementStack.getHoverName();
            }
            Component pluralNameComponent = MissionUIHelper.getPluralizedComponent(nameComponent, mission.getRequiredAmount());
            nounComponent = pluralNameComponent.copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)nounColor)));
        }
        MutableComponent ofComponent = Component.translatable((String)"gui.brassworksmissions.ui.of");
        if (!ofComponent.getString().trim().isEmpty()) {
            description.append(" ").append((Component)ofComponent.copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_VERB_COLOR))));
        }
        description.append(" ").append((Component)nounComponent);
        if (SUFFIX_VERBS.containsKey(missionType)) {
            String suffixKey = SUFFIX_VERBS.get(missionType);
            MutableComponent suffixComponent = Component.translatable((String)suffixKey).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)DESCRIPTION_VERB_COLOR)));
            description.append(" ").append((Component)suffixComponent);
        }
        return description;
    }

    public static Component getFormattedProgress(ActiveMission mission, Component prefix) {
        if (mission == null) {
            return Component.empty();
        }
        boolean isComplete = mission.getProgress() >= mission.getRequiredAmount();
        int numberColor = isComplete ? COMPLETED_TITLE_COLOR : PROGRESS_CURRENT_COLOR;
        MutableComponent prefixComponent = Component.empty();
        if (prefix != null) {
            prefixComponent = prefix.copy().append(" ");
        }
        MutableComponent currentProgress = Component.literal((String)String.valueOf(mission.getProgress())).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)numberColor)));
        MutableComponent slash = Component.translatable((String)"gui.brassworksmissions.ui.progress_slash").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)PROGRESS_SLASH_COLOR)));
        MutableComponent requiredAmount = Component.literal((String)String.valueOf(mission.getRequiredAmount())).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)numberColor)));
        return prefixComponent.copy().append((Component)currentProgress).append((Component)slash).append((Component)requiredAmount);
    }

    public static Component getFormattedReward(ActiveMission mission) {
        if (mission == null || mission.getRewardItemStack().isEmpty()) {
            return Component.empty();
        }
        MutableComponent rewardText = Component.translatable((String)"gui.brassworksmissions.ui.reward").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)REWARD_TEXT_COLOR)));
        MutableComponent punctuation = Component.literal((String)": ").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)REWARD_PUNCTUATION_COLOR)));
        MutableComponent amount = Component.translatable((String)"gui.brassworksmissions.ui.reward_amount", (Object[])new Object[]{mission.getRewardItemStack().getCount()}).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)REWARD_AMOUNT_COLOR)));
        MutableComponent item = Component.literal((String)mission.getRewardItemStack().getHoverName().getString()).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)REWARD_ITEM_COLOR)));
        MutableComponent pluralSuffix = Component.translatable((String)"gui.brassworksmissions.ui.plural_format").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)REWARD_ITEM_COLOR)));
        return rewardText.copy().append((Component)punctuation).append((Component)amount).append((Component)item).append((Component)pluralSuffix);
    }
}

