/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import net.swzo.brassworksmissions.client.gui.MissionIcons;
import net.swzo.brassworksmissions.client.gui.MissionUIHelper;
import net.swzo.brassworksmissions.client.gui.UiScreenRenderHelper;
import net.swzo.brassworksmissions.client.gui.widget.CustomIconButton;
import net.swzo.brassworksmissions.init.KeybindingInit;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.MissionController;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;
import net.swzo.brassworksmissions.network.UiButtonMessage;
import net.swzo.brassworksmissions.network.UpdateSelectedMissionMessage;
import net.swzo.brassworksmissions.world.inventory.UiMenu;
import org.jetbrains.annotations.NotNull;

public class UiScreen
extends AbstractContainerScreen<UiMenu> {
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private IconButton claimRewardsButton;
    private IconButton closeButton;
    private CustomIconButton trackButton;
    private CustomIconButton rerollButton;
    private Indicator trackingIndicator;
    private SelectionScrollInput missionSelector;
    private List<Component> missionsList = new ArrayList<Component>();
    private Label titleLabel;
    private Component descriptionComponent = Component.empty();
    private Label progressLabel;
    private Label progressTextLabel;
    private Label missionResetTimerLabel;
    private ItemStack rewardStack = ItemStack.EMPTY;

    public UiScreen(UiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 241;
        this.imageHeight = 175;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        MutableComponent selectedPrefix = Component.translatable((String)"gui.brassworksmissions.ui.selected_prefix").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.SELECTOR_PREFIX_COLOR)));
        MutableComponent selectedValue = Component.translatable((String)"gui.brassworksmissions.ui.mission_prefix", (Object[])new Object[]{this.missionSelector.getState() + 1}).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.SELECTOR_VALUE_COLOR)));
        MutableComponent fullSelectorText = selectedPrefix.copy().append((Component)selectedValue);
        guiGraphics.drawString(this.font, (Component)fullSelectorText, this.leftPos + 55, this.topPos + 47, 0xFFFFFF, true);
        this.renderTooltips(guiGraphics, mouseX, mouseY);
        UiScreenRenderHelper.renderPlayerModel(guiGraphics, mouseX, mouseY, this.entity, this.leftPos, this.topPos, partialTicks);
        this.renderLabels(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> tip;
        if (this.missionSelector != null && this.missionSelector.isMouseOver((double)mouseX, (double)mouseY)) {
            ArrayList<MutableComponent> tip2 = new ArrayList<MutableComponent>();
            tip2.add(Component.translatable((String)"gui.brassworksmissions.tooltip.available_missions").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
            BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
            for (int i = 0; i < this.missionsList.size(); ++i) {
                int colorHex;
                MutableComponent arrow;
                ActiveMission mission = playerVariables.missionData.getMission(i);
                if (mission == null) continue;
                boolean isComplete = mission.isComplete();
                MutableComponent missionLabel = Component.translatable((String)"gui.brassworksmissions.ui.mission_prefix", (Object[])new Object[]{i + 1});
                if (i == this.missionSelector.getState()) {
                    arrow = Component.translatable((String)"gui.brassworksmissions.tooltip.arrow_selected").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.SELECTOR_VALUE_COLOR)));
                    colorHex = isComplete ? MissionUIHelper.SCROLLER_SELECTED_COMPLETED_COLOR : MissionUIHelper.SCROLLER_SELECTED_INCOMPLETE_COLOR;
                } else {
                    arrow = Component.translatable((String)"gui.brassworksmissions.tooltip.arrow_unselected").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_TEXT_COLOR)));
                    colorHex = isComplete ? MissionUIHelper.SCROLLER_UNSELECTED_COMPLETED_COLOR : MissionUIHelper.SCROLLER_UNSELECTED_INCOMPLETE_COLOR;
                }
                MutableComponent missionComponent = missionLabel.copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)colorHex)));
                MutableComponent line = arrow.copy().append((Component)missionComponent);
                tip2.add(line);
            }
            tip2.add(Component.translatable((String)"gui.brassworksmissions.tooltip.scroll_select").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_SUBTEXT_COLOR)).withItalic(Boolean.valueOf(true))));
            guiGraphics.renderComponentTooltip(this.font, tip2, mouseX, mouseY);
        }
        if (!this.rewardStack.isEmpty() && this.rewardStack.getCount() >= 1) {
            int rewardX = this.leftPos + 26 + 99 - 21;
            int rewardY = this.topPos + 105 - 2 + 12;
            if (mouseX >= rewardX && mouseX < rewardX + 16 && mouseY >= rewardY && mouseY < rewardY + 16) {
                guiGraphics.renderTooltip(this.font, this.rewardStack, mouseX, mouseY);
            }
        }
        ItemStack allRewardsIcon = new ItemStack((ItemLike)this.rewardStack.getItem(), MissionController.getTotalClaimableItemCount(this.entity));
        int allRewardsX = this.leftPos + 10;
        int allRewardsY = this.topPos + 140 + 12;
        if (mouseX >= allRewardsX && mouseX < allRewardsX + 16 && mouseY >= allRewardsY && mouseY < allRewardsY + 16) {
            if (allRewardsIcon.getCount() >= 1) {
                guiGraphics.renderTooltip(this.font, allRewardsIcon, mouseX, mouseY);
            } else {
                tip = new ArrayList();
                tip.add(Component.translatable((String)"gui.brassworksmissions.tooltip.no_rewards").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_ERROR_COLOR))));
                guiGraphics.renderComponentTooltip(this.font, tip, mouseX, mouseY);
            }
        }
        if (this.claimRewardsButton != null && this.claimRewardsButton.isMouseOver((double)mouseX, (double)mouseY)) {
            tip = new ArrayList<MutableComponent>();
            tip.add(Component.translatable((String)"gui.brassworksmissions.tooltip.claim_reward").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
            guiGraphics.renderComponentTooltip(this.font, tip, mouseX, mouseY);
        }
        if (this.closeButton != null && this.closeButton.isMouseOver((double)mouseX, (double)mouseY)) {
            tip = new ArrayList();
            tip.add(Component.translatable((String)"gui.brassworksmissions.tooltip.confirm_close").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
            guiGraphics.renderComponentTooltip(this.font, tip, mouseX, mouseY);
        }
        if (this.trackButton != null && this.trackButton.isMouseOver(mouseX, mouseY)) {
            tip = new ArrayList();
            tip.add(Component.translatable((String)"gui.brassworksmissions.tooltip.track_mission").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
            guiGraphics.renderComponentTooltip(this.font, tip, mouseX, mouseY);
        }
        if (this.rerollButton != null && this.rerollButton.isMouseOver(mouseX, mouseY)) {
            BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
            int rerollCost = playerVariables.reRollAmount * 2;
            int cappedCost = Math.min(rerollCost, 32);
            ArrayList<MutableComponent> tip3 = new ArrayList<MutableComponent>();
            tip3.add(Component.translatable((String)"gui.brassworksmissions.tooltip.reroll_mission").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_HEADER_COLOR))));
            Item rerollitem = this.rewardStack.getItem();
            ItemStack rerollstack = new ItemStack((ItemLike)rerollitem);
            MutableComponent costPrefix = Component.translatable((String)"gui.brassworksmissions.tooltip.cost_prefix", (Object[])new Object[]{cappedCost}).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_TEXT_COLOR)));
            MutableComponent costItem = rerollstack.getHoverName().copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.REWARD_ITEM_COLOR))).append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"));
            tip3.add(costPrefix.copy().append((Component)costItem));
            tip3.add(Component.translatable((String)"gui.brassworksmissions.tooltip.cost_cap", (Object[])new Object[]{rerollstack.getHoverName().copy().append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"))}).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_SUBTEXT_COLOR)).withItalic(Boolean.valueOf(true))));
            long owned = this.entity.getInventory().countItem(rerollitem);
            if (owned < (long)cappedCost) {
                tip3.add(Component.translatable((String)"gui.brassworksmissions.tooltip.not_enough", (Object[])new Object[]{rerollstack.getHoverName().copy().append((Component)Component.translatable((String)"gui.brassworksmissions.ui.plural_format"))}).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_ERROR_COLOR))));
            }
            guiGraphics.renderComponentTooltip(this.font, tip3, mouseX, mouseY);
        }
        if (this.missionResetTimerLabel != null && this.missionResetTimerLabel.text != null) {
            int timerX = this.leftPos + 124 - 36 - 8 - 4;
            int timerY = this.topPos + 138 + 18 - 4;
            int textWidth = 77;
            int textHeight = 15;
            if (mouseX >= timerX && mouseX <= timerX + textWidth && mouseY >= timerY && mouseY <= timerY + textHeight) {
                long remainingMillis = UiScreenRenderHelper.getRemainingMillisUntilReset();
                List<Component> tip4 = UiScreenRenderHelper.getFormattedTooltipCountdown(remainingMillis);
                guiGraphics.renderComponentTooltip(this.font, tip4, mouseX, mouseY);
            }
        }
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        int descriptionWrapWidth = 140;
        int centerX = this.leftPos + 39 - 3 + 59;
        int currentY = this.topPos + 72;
        int textX = this.leftPos + 28;
        if (this.titleLabel != null && this.titleLabel.text != null && !this.titleLabel.text.getString().isEmpty()) {
            int titleX = centerX - this.font.width((FormattedText)this.titleLabel.text) / 2;
            guiGraphics.drawString(this.font, this.titleLabel.text, titleX, currentY, 0xFFFFFF, true);
        }
        currentY += 15;
        int descriptionLinesCount = 0;
        if (this.descriptionComponent != null && !this.descriptionComponent.getString().isEmpty()) {
            List descriptionLines = this.font.split((FormattedText)this.descriptionComponent, 140);
            descriptionLinesCount = descriptionLines.size();
            for (FormattedCharSequence line : descriptionLines) {
                guiGraphics.drawString(this.font, line, textX, currentY, 0xFFFFFF, true);
                Objects.requireNonNull(this.font);
                currentY += 9;
            }
        }
        if (descriptionLinesCount == 0) {
            Objects.requireNonNull(this.font);
            currentY += 9;
        }
        if (this.progressTextLabel != null && this.progressTextLabel.text != null && !this.progressTextLabel.text.getString().isEmpty()) {
            guiGraphics.drawString(this.font, this.progressTextLabel.text, textX, this.topPos + 112, 0xFFFFFF, true);
        }
        if (this.progressLabel != null && this.progressLabel.text != null && !this.progressLabel.text.getString().isEmpty()) {
            guiGraphics.drawString(this.font, this.progressLabel.text, textX, this.topPos + 123, 0xFFFFFF, true);
        }
        if (this.missionResetTimerLabel != null && this.missionResetTimerLabel.text != null && !this.missionResetTimerLabel.text.getString().isEmpty()) {
            int timerX = this.leftPos + 124 - 36 - 8 + 34 + 1 - this.font.width((FormattedText)this.missionResetTimerLabel.text) / 2;
            int timerY = this.topPos + 138 + 18;
            guiGraphics.drawString(this.font, this.missionResetTimerLabel.text, timerX, timerY, 0xFFFFFF, true);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ResourceLocation.parse((String)"brassworksmissions:textures/screens/missionsui.png"), this.leftPos, this.topPos, 0.0f, 0.0f, 256, 175, 256, 175);
        RenderSystem.disableBlend();
        int idx = this.missionSelector.getState();
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        ActiveMission mission = playerVariables.missionData.getMission(idx);
        ItemStack missionIcon = null;
        if (mission != null) {
            missionIcon = new ItemStack((ItemLike)mission.getRequirementItemStack().getItem(), 1);
        }
        if (missionIcon != null) {
            guiGraphics.renderItem(missionIcon, this.leftPos + 25, this.topPos + 43);
        }
        ItemStack allRewardsIcon = new ItemStack((ItemLike)this.rewardStack.getItem(), MissionController.getTotalClaimableItemCount(this.entity));
        int allRewardsX = this.leftPos + 10;
        int allRewardsY = this.topPos + 140 + 12;
        guiGraphics.renderItem(allRewardsIcon, allRewardsX, allRewardsY);
        guiGraphics.renderItemDecorations(this.font, allRewardsIcon, allRewardsX, allRewardsY);
        if (!this.rewardStack.isEmpty()) {
            int rewardX = this.leftPos + 26;
            int rewardY = this.topPos + 105 + 12;
            ItemStack rewardIcon = new ItemStack((ItemLike)this.rewardStack.getItem(), this.rewardStack.getCount());
            guiGraphics.renderItemDecorations(this.font, rewardIcon, rewardX + 78, rewardY - 2);
            guiGraphics.renderItem(rewardIcon, rewardX + 78, rewardY - 2);
        }
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256 || key == KeybindingInit.OPEN_MISSIONS_UI_KEY.getKey().getValue()) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.closeContainer();
            }
            int selectedSlot = this.missionSelector.getState();
            ((BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).SelectedMission = selectedSlot;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (key == KeybindingInit.TRACK_MISSIONS_UI_KEY.getKey().getValue()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(this.missionSelector.getState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new UiButtonMessage(3, this.x, this.y, this.z, this.missionSelector.getState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.missionsList.clear();
        this.initMissionSelector();
        this.initLabels();
        this.initButtons();
    }

    private void initMissionSelector() {
        int SEL_X = this.leftPos + 50;
        int SEL_Y = this.topPos + 44;
        int SEL_W = 118;
        for (int i = 0; i < 6; ++i) {
            this.missionsList.add((Component)Component.translatable((String)"gui.brassworksmissions.ui.mission_prefix", (Object[])new Object[]{i + 1}));
        }
        this.missionSelector = new SelectionScrollInput(SEL_X - 3, SEL_Y - 2, 118, 18);
        this.missionSelector.forOptions(this.missionsList);
        this.missionSelector.titled(Component.translatable((String)"gui.brassworksmissions.ui.select_mission"));
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        this.missionSelector.setState((int)playerVariables.SelectedMission);
        this.addRenderableWidget((GuiEventListener)this.missionSelector);
    }

    private void initLabels() {
        int textY = this.topPos + 70;
        this.titleLabel = new Label(0, textY, (Component)Component.empty()).withShadow();
        this.progressLabel = new Label(0, textY + 24, (Component)Component.empty()).withShadow();
        this.progressTextLabel = new Label(0, textY + 24, (Component)Component.empty()).withShadow();
        this.missionResetTimerLabel = new Label(0, 0, (Component)Component.empty()).withShadow();
    }

    private void initButtons() {
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        this.claimRewardsButton = (IconButton)new IconButton(this.leftPos + 30, this.topPos + 139 + 12, (ScreenElement)MissionIcons.I_CLAIM).withCallback(() -> {
            int selectedSlot = this.missionSelector.getState();
            playerVariables.SelectedMission = selectedSlot;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new UiButtonMessage(0, this.x, this.y, this.z, selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.claimRewardsButton);
        this.closeButton = (IconButton)new IconButton(this.leftPos + 167, this.topPos + 139 + 12, (ScreenElement)AllIcons.I_CONFIRM).withCallback(() -> {
            int selectedSlot = this.missionSelector.getState();
            playerVariables.SelectedMission = selectedSlot;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.closeContainer();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.closeButton);
        this.rerollButton = (CustomIconButton)new CustomIconButton(this.leftPos + 124, this.topPos + 102 + 12, (ScreenElement)AllIcons.I_REFRESH).withCallback(() -> {
            int selectedSlot = this.missionSelector.getState();
            playerVariables.SelectedMission = selectedSlot;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new UiButtonMessage(2, this.x, this.y, this.z, selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.rerollButton);
        this.trackButton = (CustomIconButton)new CustomIconButton(this.leftPos + 145, this.topPos + 102 + 12, (ScreenElement)AllIcons.I_WHITELIST).withCallback(() -> {
            int selectedSlot = this.missionSelector.getState();
            playerVariables.SelectedMission = selectedSlot;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSelectedMissionMessage(selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new UiButtonMessage(3, this.x, this.y, this.z, selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.trackButton);
        this.trackingIndicator = new Indicator(this.leftPos + 145, this.topPos + 96 + 12, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.trackingIndicator);
    }

    public void containerTick() {
        super.containerTick();
        if (this.missionSelector != null) {
            int idx = this.missionSelector.getState();
            BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)this.entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
            ActiveMission mission = playerVariables.missionData.getMission(idx);
            boolean bl = this.claimRewardsButton.active = MissionController.getTotalClaimableItemCount(this.entity) >= 1;
            if (mission != null) {
                boolean bl2 = this.rerollButton.active = playerVariables.reRollAmount * 2 <= 32 && !mission.isComplete();
            }
            if (this.trackingIndicator != null && this.trackButton != null) {
                boolean isTracked = playerVariables.trackedMissions.contains(idx);
                boolean isComplete = false;
                if (mission != null) {
                    isComplete = mission.isComplete();
                }
                if (isComplete && !isTracked) {
                    this.trackButton.active = false;
                    this.trackingIndicator.state = Indicator.State.OFF;
                } else {
                    this.trackButton.active = true;
                    Indicator.State state = this.trackingIndicator.state = isTracked ? Indicator.State.ON : Indicator.State.OFF;
                }
            }
            if (mission != null) {
                boolean isComplete = mission.isComplete();
                int titleColorHex = isComplete ? MissionUIHelper.COMPLETED_TITLE_COLOR : MissionUIHelper.INCOMPLETE_TITLE_COLOR;
                this.titleLabel.text = Component.literal((String)mission.getTitle()).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)titleColorHex)));
                this.descriptionComponent = MissionUIHelper.getMissionDescription(mission);
                this.progressTextLabel.text = Component.translatable((String)"gui.brassworksmissions.ui.progress").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.PROGRESS_TEXT_COLOR)));
                this.progressLabel.text = MissionUIHelper.getFormattedProgress(mission, null);
                this.rewardStack = mission.getRewardItemStack();
            } else {
                this.titleLabel.text = Component.translatable((String)"gui.brassworksmissions.ui.no_mission_data").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)MissionUIHelper.TOOLTIP_ERROR_COLOR)));
                this.descriptionComponent = Component.empty();
                this.progressLabel.text = Component.empty();
                this.progressTextLabel.text = Component.empty();
                this.rewardStack = ItemStack.EMPTY;
            }
        }
        long remainingMillis = UiScreenRenderHelper.getRemainingMillisUntilReset();
        if (this.missionResetTimerLabel != null) {
            this.missionResetTimerLabel.text = UiScreenRenderHelper.getFormattedCountdown(remainingMillis);
        }
    }
}

