/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.swzo.brassworksmissions.client.gui.MissionGuiTextures;

public class CustomIconButton
extends AbstractSimiWidget {
    protected ScreenElement icon;
    protected boolean isPressed;

    public CustomIconButton(int x, int y, ScreenElement icon) {
        this(x, y, 18, 18, icon);
    }

    public CustomIconButton(int x, int y, int w, int h, ScreenElement icon) {
        super(x, y, w, h);
        this.icon = icon;
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        MissionGuiTextures button = !this.active ? MissionGuiTextures.BUTTON_DISABLED : (this.isPressed && this.isHovered ? MissionGuiTextures.BUTTON_DOWN : (this.isHovered ? MissionGuiTextures.BUTTON_HOVER : MissionGuiTextures.BUTTON));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBg(graphics, button);
        if (this.icon != null) {
            this.icon.render(graphics, this.getX() + 1, this.getY() + 1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.isHovered && button == 0) {
            this.isPressed = true;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPressed) {
            this.isPressed = false;
            if (this.active && this.isHovered) {
                this.onClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected void drawBg(GuiGraphics graphics, MissionGuiTextures button) {
        graphics.blit(button.location, this.getX(), this.getY(), button.getStartX(), button.getStartY(), button.getWidth(), button.getHeight());
    }

    public void setToolTip(Component text) {
        this.toolTip.clear();
        this.toolTip.add(text);
    }

    public void setIcon(ScreenElement icon) {
        this.icon = icon;
    }
}

