/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.event;

import java.time.DayOfWeek;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.config.Config;
import net.swzo.brassworksmissions.missions.MissionController;
import net.swzo.brassworksmissions.missions.PlayerMissionData;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;

@EventBusSubscriber(modid="brassworksmissions")
public class MissionResetHandler {
    private static List<DayOfWeek> getResetDays() {
        return ((List)Config.SERVER.MISSION_RESET_DAYS.get()).stream().map(String::toUpperCase).map(DayOfWeek::valueOf).collect(Collectors.toList());
    }

    public static long getMostRecentWeeklyResetTimestamp() {
        List<DayOfWeek> resetDays = MissionResetHandler.getResetDays();
        if (resetDays.isEmpty()) {
            return -1L;
        }
        int resetHour = (Integer)Config.SERVER.MISSION_RESET_HOUR.get();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        ChronoZonedDateTime mostRecentReset = null;
        for (DayOfWeek day : resetDays) {
            ZonedDateTime lastOccurrence = now.with(TemporalAdjusters.previousOrSame(day)).withHour(resetHour).withMinute(0).withSecond(0).withNano(0);
            if (lastOccurrence.isAfter(now)) {
                lastOccurrence = lastOccurrence.minusWeeks(1L);
            }
            if (mostRecentReset != null && !lastOccurrence.isAfter(mostRecentReset)) continue;
            mostRecentReset = lastOccurrence;
        }
        return mostRecentReset != null ? mostRecentReset.toEpochSecond() : -1L;
    }

    public static long getNextWeeklyResetTimestamp() {
        List<DayOfWeek> resetDays = MissionResetHandler.getResetDays();
        if (resetDays.isEmpty()) {
            return Long.MAX_VALUE;
        }
        int resetHour = (Integer)Config.SERVER.MISSION_RESET_HOUR.get();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        ChronoZonedDateTime nextReset = null;
        for (DayOfWeek day : resetDays) {
            ZonedDateTime nextOccurrence = now.with(TemporalAdjusters.nextOrSame(day)).withHour(resetHour).withMinute(0).withSecond(0).withNano(0);
            if (nextOccurrence.isBefore(now) || nextOccurrence.isEqual(now)) {
                nextOccurrence = nextOccurrence.plusWeeks(1L);
            }
            if (nextReset != null && !nextOccurrence.isBefore(nextReset)) continue;
            nextReset = nextOccurrence;
        }
        return nextReset != null ? nextReset.toEpochSecond() : Long.MAX_VALUE;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MissionResetHandler.checkAndResetMissions(player2);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (event.getServer().getTickCount() % 20 == 0) {
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                MissionResetHandler.checkAndResetMissions(player);
            }
        }
    }

    public static void checkAndResetMissions(ServerPlayer player) {
        BrassworksmissionsModVariables.PlayerVariables playerVariables = (BrassworksmissionsModVariables.PlayerVariables)player.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
        long currentResetTime = MissionResetHandler.getMostRecentWeeklyResetTimestamp();
        if (currentResetTime == -1L) {
            return;
        }
        long playerLastResetTime = playerVariables.lastWeeklyResetTime;
        if (playerVariables.missionData == null) {
            playerVariables.missionData = new PlayerMissionData();
            MissionController.reassignMissions(player);
            playerVariables.lastWeeklyResetTime = currentResetTime;
            playerVariables.syncPlayerVariables((Entity)player);
            return;
        }
        if (playerLastResetTime < currentResetTime) {
            BrassworksmissionsMod.LOGGER.info("Weekly missions reset for player {}.", (Object)player.getName().getString());
            MissionController.reassignMissions(player);
            playerVariables.lastWeeklyResetTime = currentResetTime;
            playerVariables.syncPlayerVariables((Entity)player);
        }
    }
}

