/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.swzo.brassworksmissions.missions.IMissionType;
import net.swzo.brassworksmissions.missions.types.create.CompactMissionType;
import net.swzo.brassworksmissions.missions.types.create.CrushMissionType;
import net.swzo.brassworksmissions.missions.types.create.CutMissionType;
import net.swzo.brassworksmissions.missions.types.create.DrillMissionType;
import net.swzo.brassworksmissions.missions.types.create.HarvesterMissionType;
import net.swzo.brassworksmissions.missions.types.create.MechanicalCraftMissionType;
import net.swzo.brassworksmissions.missions.types.create.MillMissionType;
import net.swzo.brassworksmissions.missions.types.create.MixMissionType;
import net.swzo.brassworksmissions.missions.types.create.MoveOnBeltMissionType;
import net.swzo.brassworksmissions.missions.types.create.PressMissionType;
import net.swzo.brassworksmissions.missions.types.create.SawMissionType;
import net.swzo.brassworksmissions.missions.types.create.TravelByChainConveyorMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.BreakBlockMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.BreedAnimalsMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.ConsumeItemMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.CraftItemMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.DriveBoatMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.EatCakeSliceMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.FishItemMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.FlyElytraMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.KillEntityMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.ReachExperienceLevelMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.RideMobMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.UseTotemMissionType;
import net.swzo.brassworksmissions.missions.types.vanilla.WalkMissionType;

public class MissionRegistry {
    private static final Map<String, IMissionType> missionTypes = new HashMap<String, IMissionType>();

    public static void registerMissionTypes() {
        MissionRegistry.register(new BreakBlockMissionType());
        MissionRegistry.register(new ReachExperienceLevelMissionType());
        MissionRegistry.register(new UseTotemMissionType());
        MissionRegistry.register(new FishItemMissionType());
        MissionRegistry.register(new CraftItemMissionType());
        MissionRegistry.register(new KillEntityMissionType());
        MissionRegistry.register(new BreedAnimalsMissionType());
        MissionRegistry.register(new ConsumeItemMissionType());
        MissionRegistry.register(new WalkMissionType());
        MissionRegistry.register(new DriveBoatMissionType());
        MissionRegistry.register(new FlyElytraMissionType());
        MissionRegistry.register(new RideMobMissionType());
        MissionRegistry.register(new EatCakeSliceMissionType());
        MissionRegistry.register(new MixMissionType());
        MissionRegistry.register(new CompactMissionType());
        MissionRegistry.register(new PressMissionType());
        MissionRegistry.register(new SawMissionType());
        MissionRegistry.register(new CrushMissionType());
        MissionRegistry.register(new MillMissionType());
        MissionRegistry.register(new CutMissionType());
        MissionRegistry.register(new MechanicalCraftMissionType());
        MissionRegistry.register(new DrillMissionType());
        MissionRegistry.register(new MoveOnBeltMissionType());
        MissionRegistry.register(new TravelByChainConveyorMissionType());
        MissionRegistry.register(new HarvesterMissionType());
    }

    private static void register(IMissionType type) {
        if (missionTypes.containsKey(type.getId())) {
            throw new IllegalArgumentException("Duplicate mission type registered: " + type.getId());
        }
        missionTypes.put(type.getId(), type);
    }

    @Nullable
    public static IMissionType getMissionType(String id) {
        return missionTypes.get(id);
    }
}

