/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions.reward;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.missions.reward.RewardConfig;

public class RewardManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String DIRECTORY = "missions";
    private static final ResourceLocation REWARD_FILE_ID = ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"mission_reward");
    private ItemStack rewardItemStack = new ItemStack((ItemLike)Items.EMERALD);

    public RewardManager() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        block5: {
            this.rewardItemStack = new ItemStack((ItemLike)Items.EMERALD);
            JsonElement rewardJson = objects.get(REWARD_FILE_ID);
            if (rewardJson != null) {
                try {
                    RewardConfig config = (RewardConfig)GSON.fromJson(rewardJson, RewardConfig.class);
                    if (config != null && config.getItem() != null) {
                        Item rewardItem = Optional.of((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)config.getItem()))).orElse(Items.EMERALD);
                        this.rewardItemStack = new ItemStack((ItemLike)rewardItem);
                        BrassworksmissionsMod.LOGGER.info("Loaded mission reward item: {}", (Object)config.getItem());
                        break block5;
                    }
                    BrassworksmissionsMod.LOGGER.warn("Mission reward file is invalid: {}. Using default reward.", (Object)REWARD_FILE_ID);
                }
                catch (Exception e) {
                    BrassworksmissionsMod.LOGGER.error("Could not parse mission reward file: {}", (Object)REWARD_FILE_ID, (Object)e);
                }
            } else {
                BrassworksmissionsMod.LOGGER.warn("Mission reward file not found: {}. Using default reward.", (Object)REWARD_FILE_ID);
            }
        }
    }

    public ItemStack getRewardItem() {
        return this.rewardItemStack.copy();
    }
}

