/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.mixin.create;

import com.simibubi.create.content.kinetics.saw.TreeCutter;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.swzo.brassworksmissions.missions.types.create.SawMissionType;
import net.swzo.brassworksmissions.util.MixinUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TreeCutter.Tree.class}, remap=false)
public class TreeMixin {
    @Shadow
    @Final
    private List<BlockPos> leaves;
    @Shadow
    @Final
    private List<BlockPos> logs;

    @Inject(method={"destroyBlocks"}, at={@At(value="HEAD")})
    public void onDestroyBlocks(Level world, ItemStack toDamage, Player playerEntity, BiConsumer<BlockPos, ItemStack> drop, CallbackInfo ci) {
        if (world.isClientSide() || this.logs.isEmpty()) {
            return;
        }
        Player closestPlayer = MixinUtils.getClosestPlayer(world, this.logs.get(0));
        if (!(closestPlayer instanceof ServerPlayer)) {
            return;
        }
        HashSet<BlockPos> allBlocks = new HashSet<BlockPos>(this.logs);
        allBlocks.addAll(this.leaves);
        allBlocks.forEach(pos -> {
            ItemStack blockStack = new ItemStack((ItemLike)world.getBlockState(pos).getBlock().asItem());
            if (!blockStack.isEmpty()) {
                MixinUtils.handlePlayerMissionIncrement(closestPlayer, SawMissionType.class, blockStack);
            }
        });
    }
}

