/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.PlayerMissionData;
import net.swzo.brassworksmissions.network.UpdateSelectedMissionMessage;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class BrassworksmissionsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"brassworksmissions");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(PlayerVariables::new).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BrassworksmissionsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
        BrassworksmissionsMod.addNetworkMessage(UpdateSelectedMissionMessage.TYPE, UpdateSelectedMissionMessage.STREAM_CODEC, UpdateSelectedMissionMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), Objects.requireNonNull(buffer.readNbt()));
            return message;
        });

        @NotNull
        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public long lastWeeklyResetTime = 1L;
        public double SelectedMission = 1.0;
        public int reRollAmount = 1;
        public boolean hasmissiondata = false;
        public PlayerMissionData missionData;
        public List<Integer> trackedMissions = new ArrayList<Integer>();

        public PlayerVariables() {
            this.missionData = new PlayerMissionData();
            String missionType = "brassworksmissions:disabled";
            String title = "No Mission";
            boolean requiredAmount = true;
            String requirementType = "block";
            boolean rewardAmount = true;
            ItemStack requirementStack = new ItemStack((ItemLike)Items.BARRIER, 1);
            ItemStack rewardStack = new ItemStack((ItemLike)Items.DIAMOND, 1);
            int fillSlots = Math.min(6, 6);
            for (int i = 0; i < fillSlots; ++i) {
                ActiveMission mission = new ActiveMission("brassworksmissions:disabled", "No Mission", requirementStack.copy(), 1, "block", rewardStack.copy());
                this.missionData.setMission(i, mission);
            }
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putLong("lastWeeklyResetTime", this.lastWeeklyResetTime);
            nbt.putDouble("SelectedMission", this.SelectedMission);
            nbt.put("missionData", (Tag)this.missionData.serializeNBT(lookupProvider));
            nbt.putInt("reRollAmount", this.reRollAmount);
            nbt.putBoolean("hasmissiondata", this.hasmissiondata);
            nbt.putIntArray("trackedMissions", this.trackedMissions.stream().mapToInt(Integer::intValue).toArray());
            return nbt;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.lastWeeklyResetTime = nbt.getLong("lastWeeklyResetTime");
            this.SelectedMission = nbt.getDouble("SelectedMission");
            this.reRollAmount = nbt.getInt("reRollAmount");
            this.hasmissiondata = nbt.getBoolean("hasmissiondata");
            if (nbt.contains("missionData", 10)) {
                this.missionData.deserializeNBT(lookupProvider, nbt.getCompound("missionData"));
            }
            if (nbt.contains("trackedMissions", 11)) {
                this.trackedMissions = Arrays.stream(nbt.getIntArray("trackedMissions")).boxed().collect(Collectors.toList());
            }
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.lastWeeklyResetTime = original.lastWeeklyResetTime;
            clone.SelectedMission = original.SelectedMission;
            clone.reRollAmount = original.reRollAmount;
            clone.hasmissiondata = original.hasmissiondata;
            clone.missionData = original.missionData;
            clone.trackedMissions = new ArrayList<Integer>(original.trackedMissions);
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

