/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.network;

import com.simibubi.create.AllSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.missions.MissionController;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;
import net.swzo.brassworksmissions.util.UiUtils;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public record UiButtonMessage(int buttonID, int x, int y, int z, int slot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brassworksmissions", (String)"ui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.slot);
    }, buffer -> new UiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    @NotNull
    public CustomPacketPayload.Type<UiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(UiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> UiButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z, message.slot)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, int slot) {
        BrassworksmissionsModVariables.PlayerVariables playerVariables;
        ServerPlayer serverPlayer;
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            if (entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                MissionController.claimAllRewards(serverPlayer);
                AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(world, (Vec3i)serverPlayer.blockPosition());
            }
            UiUtils.closeUi((Entity)entity);
        }
        if (buttonID == 1) {
            UiUtils.closeUi((Entity)entity);
        }
        if (buttonID == 2 && entity instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity;
            playerVariables = (BrassworksmissionsModVariables.PlayerVariables)entity.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
            MissionController.rerollMission(serverPlayer, (int)playerVariables.SelectedMission);
        }
        if (buttonID == 3 && entity instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity;
            playerVariables = (BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES);
            Integer missionSlot = slot;
            if (playerVariables.trackedMissions.contains(missionSlot)) {
                playerVariables.trackedMissions.remove(missionSlot);
            } else {
                playerVariables.trackedMissions.add(missionSlot);
            }
            playerVariables.syncPlayerVariables((Entity)serverPlayer);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BrassworksmissionsMod.addNetworkMessage(TYPE, STREAM_CODEC, UiButtonMessage::handleData);
    }
}

