/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swzo.brassworksmissions.missions.ActiveMission;
import net.swzo.brassworksmissions.missions.IMissionType;
import net.swzo.brassworksmissions.missions.MissionController;
import net.swzo.brassworksmissions.missions.MissionRegistry;
import net.swzo.brassworksmissions.missions.PlayerMissionData;
import net.swzo.brassworksmissions.missions.types.create.CreateMissionType;
import net.swzo.brassworksmissions.network.BrassworksmissionsModVariables;

public class MixinUtils {
    public static <T extends CreateMissionType<?>> void handleMixinMissionItem(BlockEntity be, Class<T> missionClass, ItemStack output) {
        BlockPos worldPosition;
        if (be == null || be.getLevel() == null || be.getLevel().isClientSide() || output == null || output.isEmpty()) {
            return;
        }
        Level level = be.getLevel();
        Player player = MixinUtils.getClosestPlayer(level, worldPosition = be.getBlockPos());
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerMissionData missionData = MissionController.getMissionData((Player)serverPlayer);
        if (missionData == null) {
            return;
        }
        boolean needsSync = false;
        for (int i = 0; i < 6; ++i) {
            CreateMissionType missionType;
            IMissionType type;
            ActiveMission mission = missionData.getMission(i);
            if (mission == null || mission.isComplete() || (type = MissionRegistry.getMissionType(mission.getMissionType())) == null || !missionClass.isInstance(type) || !(missionType = (CreateMissionType)missionClass.cast(type)).check(output, mission)) continue;
            needsSync = true;
        }
        if (needsSync) {
            ((BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)serverPlayer);
        }
    }

    public static <T extends CreateMissionType<?>> void handlePlayerMissionIncrement(Player player, Class<T> missionClass, ItemStack itemStack) {
        if (player == null || player.level() == null || player.level().isClientSide() || itemStack == null || itemStack.isEmpty()) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerMissionData missionData = MissionController.getMissionData((Player)serverPlayer);
        if (missionData == null) {
            return;
        }
        boolean needsSync = false;
        for (int i = 0; i < 6; ++i) {
            CreateMissionType missionType;
            IMissionType type;
            ActiveMission mission = missionData.getMission(i);
            if (mission == null || mission.isComplete() || (type = MissionRegistry.getMissionType(mission.getMissionType())) == null || !missionClass.isInstance(type) || !(missionType = (CreateMissionType)missionClass.cast(type)).check(itemStack, mission)) continue;
            needsSync = true;
        }
        if (needsSync) {
            ((BrassworksmissionsModVariables.PlayerVariables)serverPlayer.getData(BrassworksmissionsModVariables.PLAYER_VARIABLES)).syncPlayerVariables((Entity)serverPlayer);
        }
    }

    @Nullable
    public static Player getClosestPlayer(Level level, BlockPos worldPosition) {
        if (level == null || worldPosition == null) {
            return null;
        }
        return level.getNearestPlayer((double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.5, (double)worldPosition.getZ() + 0.5, 128.0, false);
    }
}

