/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.missions;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.swzo.brassworksmissions.BrassworksmissionsMod;
import net.swzo.brassworksmissions.missions.ActiveMission;

public class Mission {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="weight")
    private double weight;
    @SerializedName(value="titles")
    private List<String> titles;
    @SerializedName(value="requirement")
    private Requirement requirement;
    @SerializedName(value="reward")
    private Reward reward;

    public String getId() {
        return this.id;
    }

    public double getWeight() {
        return this.weight;
    }

    public ActiveMission createInstance(RandomSource random) {
        ItemStack reqStack;
        List items;
        String title = this.titles.get(random.nextInt(this.titles.size()));
        int reqAmount = this.requirement.minAmount + random.nextInt(this.requirement.maxAmount - this.requirement.minAmount + 1);
        String selectedItemName = null;
        if (this.requirement.item instanceof String) {
            selectedItemName = (String)this.requirement.item;
        } else if (this.requirement.item instanceof List && !(items = (List)this.requirement.item).isEmpty()) {
            selectedItemName = (String)items.get(random.nextInt(items.size()));
        }
        if (!(reqStack = Optional.ofNullable(selectedItemName).map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).map(ItemStack::new).orElse(ItemStack.EMPTY)).isEmpty()) {
            reqStack.setCount(1);
        }
        int rewardAmount = this.reward.minAmount + random.nextInt(this.reward.maxAmount - this.reward.minAmount + 1);
        ItemStack rewardStack = BrassworksmissionsMod.getRewardManager().getRewardItem();
        rewardStack.setCount(rewardAmount);
        return new ActiveMission(this.id, title, reqStack, reqAmount, this.requirement.requirementType, rewardStack);
    }

    public static class Requirement {
        @SerializedName(value="requirementType")
        private String requirementType;
        @SerializedName(value="item")
        private Object item;
        @SerializedName(value="minAmount")
        private int minAmount;
        @SerializedName(value="maxAmount")
        private int maxAmount;
    }

    public static class Reward {
        @SerializedName(value="minAmount")
        private int minAmount;
        @SerializedName(value="maxAmount")
        private int maxAmount;
    }
}

