/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.entities;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.entities.EntitySettings;
import com.aleksey.combatradar.entities.RadarEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import org.joml.Math;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class PlayerRadarEntity
extends RadarEntity {
    private final PlayerType _playerType;

    public PlayerRadarEntity(Entity entity, EntitySettings settings, PlayerType playerType) {
        super(entity, settings);
        this._playerType = playerType;
    }

    @Override
    protected void renderInternal(GuiGraphics guiGraphics, float displayX, float displayY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        RemotePlayer player = (RemotePlayer)this.getEntity();
        float rotationYaw = minecraft.player.getViewYRot(partialTicks);
        float scale = this.getSettings().iconScale * 1.7f;
        poseStack.pushMatrix();
        poseStack.translate(displayX, displayY);
        poseStack.rotate(Math.toRadians((float)rotationYaw));
        poseStack.pushMatrix();
        poseStack.scale(scale, scale);
        this.renderPlayerIcon(guiGraphics, player);
        poseStack.popMatrix();
        if (this.getSettings().showPlayerNames) {
            this.renderPlayerName(guiGraphics, player);
        }
        poseStack.popMatrix();
    }

    private void renderPlayerIcon(GuiGraphics guiGraphics, RemotePlayer player) {
        ResourceLocation skin = player.getSkin().body().texturePath();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(skin).getTextureView());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin, -4, -4, 8.0f, 8.0f, 8, 8, 8, 8, 64, 64, ARGB.colorFromFloat((float)this.getSettings().iconOpacity, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    private void renderPlayerName(GuiGraphics guiGraphics, RemotePlayer player) {
        Minecraft minecraft = Minecraft.getInstance();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        Color color = this._playerType == PlayerType.Ally ? this.getSettings().allyPlayerColor : (this._playerType == PlayerType.Enemy ? this.getSettings().enemyPlayerColor : this.getSettings().neutralPlayerColor);
        poseStack.scale(this.getSettings().fontScale, this.getSettings().fontScale, (Matrix3x2f)poseStack.pushMatrix());
        Object playerName = player.getScoreboardName();
        if (this.getSettings().showExtraPlayerInfo && this.getSettings().showYLevel) {
            playerName = (String)playerName + " (" + (int)minecraft.player.distanceTo((Entity)player) + "m)(Y" + player.getBlockY() + ")";
        } else if (this.getSettings().showExtraPlayerInfo && !this.getSettings().showYLevel) {
            double dx = player.getX() - minecraft.player.getX();
            double dz = player.getZ() - minecraft.player.getZ();
            playerName = (String)playerName + " (" + (int)java.lang.Math.round(java.lang.Math.hypot(dx, dz)) + "m)";
        }
        Font font = minecraft.font;
        int yOffset = -4 + (int)(this.getSettings().iconScale * this.getSettings().radarScale + 8.0f);
        int xOffset = -font.width((String)playerName) / 2;
        guiGraphics.drawString(font, (String)playerName, xOffset, yOffset, color.getRGB());
        poseStack.popMatrix();
    }
}

