/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.GroupType;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.config.RadarEntityInfo;
import com.aleksey.combatradar.gui.components.SmallButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3x2fStack;

public class EntityScreen
extends Screen {
    private static final int MAX_ENTITIES_PER_COL = 8;
    private static final int ICON_WIDTH = 12;
    private static final int LINE_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 24;
    private static GroupType _activeGroupType = GroupType.NEUTRAL;
    private final RadarConfig _config;
    private final Screen _parent;
    private Button _enableButton;
    private Map<GroupType, EntityGroup> _groups;
    private int _titleTop;
    private int _buttonTop;
    private int _iconTop;
    private int _iconLeft;
    private EntityGroup _activeGroup;
    private String _groupName;
    private Button _neutralButton;
    private Button _aggressiveButton;
    private Button _otherButton;
    private final ArrayList<Button> _iconButtons;

    public EntityScreen(Screen parent, RadarConfig config) {
        super((Component)Component.literal((String)"Radar Entities"));
        this._parent = parent;
        this._config = config;
        this._iconButtons = new ArrayList();
    }

    protected void init() {
        this._titleTop = this.height / 4 - 40;
        this._buttonTop = this.height - this.height / 4 - 10;
        this._iconTop = this._titleTop + 16 + (this.height - (this.height - this._buttonTop) - this._titleTop - 16 - 128) / 2;
        this.createEntityGroups();
        this.addFunctionalButtons();
        this.setActiveGroup(_activeGroupType);
    }

    private void addFunctionalButtons() {
        int y = this._buttonTop;
        int x = this.width / 2 - 100;
        this._neutralButton = Button.builder((Component)Component.literal((String)"Neutral"), btn -> this.setActiveGroup(GroupType.NEUTRAL)).bounds(x, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._neutralButton);
        this._aggressiveButton = Button.builder((Component)Component.literal((String)"Aggressive"), btn -> this.setActiveGroup(GroupType.AGGRESSIVE)).bounds(x + 66 + 1, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._aggressiveButton);
        this._otherButton = Button.builder((Component)Component.literal((String)"Other"), btn -> this.setActiveGroup(GroupType.OTHER)).bounds(x + 66 + 1 + 66 + 1, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._otherButton);
        this._enableButton = Button.builder((Component)this.getEnableButtonText(), btn -> {
            this._config.setGroupEnabled(_activeGroupType, !this._config.isGroupEnabled(_activeGroupType));
            this._config.save();
            this._enableButton.setMessage(this.getEnableButtonText());
        }).bounds(x, y += 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this._enableButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this._parent)).bounds(x, y += 24, 200, 20).build());
    }

    private void addIconButtons() {
        int colIndex = 0;
        int rowIndex = 0;
        int colX = this._iconLeft;
        int buttonX = colX + this._activeGroup.getIconAndTextWidth(colIndex);
        int buttonY = this._iconTop - 4;
        int buttonHeight = 15;
        for (Button iconButton : this._iconButtons) {
            this.removeWidget((GuiEventListener)iconButton);
        }
        this._iconButtons.clear();
        for (RadarEntityInfo info : this._activeGroup.entities) {
            if (rowIndex == 8) {
                rowIndex = 0;
                buttonX = (colX += this._activeGroup.getColWidth(colIndex)) + this._activeGroup.getIconAndTextWidth(++colIndex);
                buttonY = this._iconTop - 4;
            }
            String buttonText = info.getEnabled() ? "on" : "off";
            String name = info.getName();
            SmallButton iconButton = new SmallButton(buttonX, buttonY, 24, buttonHeight, (Component)Component.literal((String)buttonText), btn -> this.iconButtonClicked(btn, name));
            this.addRenderableWidget((GuiEventListener)iconButton);
            this._iconButtons.add(iconButton);
            buttonY += 16;
            ++rowIndex;
        }
    }

    private void iconButtonClicked(Button btn, String name) {
        RadarEntityInfo info;
        info.setEnabled(!(info = this._config.getEntity(name)).getEnabled());
        this._config.save();
        String text = info.getEnabled() ? "on" : "off";
        btn.setMessage((Component)Component.literal((String)text));
    }

    private void createEntityGroups() {
        this._groups = new HashMap<GroupType, EntityGroup>();
        for (RadarEntityInfo info : this._config.getEntityList()) {
            EntityGroup group = this._groups.get((Object)info.getGroupType());
            if (group == null) {
                group = new EntityGroup(info.getGroupType());
                this._groups.put(info.getGroupType(), group);
            }
            int colIndex = group.entities.size() / 8;
            int textWidth = this.font.width(info.getName());
            if (group.listColTextWidth.size() <= colIndex) {
                group.listColTextWidth.add(textWidth);
            } else if (group.listColTextWidth.get(colIndex) < textWidth) {
                group.listColTextWidth.set(colIndex, textWidth);
            }
            group.entities.add(info);
        }
    }

    private void setActiveGroup(GroupType groupType) {
        _activeGroupType = groupType;
        this._activeGroup = this._groups.get((Object)groupType);
        this._iconLeft = (this.width - this._activeGroup.getTotalWidth() + 25) / 2;
        switch (groupType) {
            case NEUTRAL: {
                this._groupName = "Neutral";
                break;
            }
            case AGGRESSIVE: {
                this._groupName = "Aggressive";
                break;
            }
            case OTHER: {
                this._groupName = "Other";
            }
        }
        this.addIconButtons();
        this._neutralButton.active = groupType != GroupType.NEUTRAL;
        this._aggressiveButton.active = groupType != GroupType.AGGRESSIVE;
        this._otherButton.active = groupType != GroupType.OTHER;
        this._enableButton.setMessage(this.getEnableButtonText());
    }

    private Component getEnableButtonText() {
        String text = this._groupName + " Entities: " + (this._config.isGroupEnabled(_activeGroupType) ? "On" : "Off");
        return Component.literal((String)text);
    }

    public void removed() {
        this._config.save();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this._titleTop, Color.WHITE.getRGB());
        this.renderIcons(guiGraphics);
    }

    private void renderIcons(GuiGraphics guiGraphics) {
        int colIndex = 0;
        int rowIndex = 0;
        int x = this._iconLeft;
        int y = this._iconTop;
        for (RadarEntityInfo info : this._activeGroup.entities) {
            if (rowIndex == 8) {
                x += this._activeGroup.getColWidth(colIndex);
                y = this._iconTop;
                ++colIndex;
                rowIndex = 0;
            }
            this.renderIcon(guiGraphics, x, y + 4, info);
            boolean isEnabled = info.getEnabled() && this._config.isGroupEnabled(_activeGroupType);
            Color color = isEnabled ? Color.WHITE : Color.DARK_GRAY;
            guiGraphics.drawString(this.font, info.getName(), x + 12, y, color.getRGB(), true);
            y += 16;
            ++rowIndex;
        }
    }

    private void renderIcon(GuiGraphics guiGraphics, float x, float y, RadarEntityInfo info) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        poseStack.scale(0.6f, 0.6f);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(info.getIcon((Entity)null)).getTextureView());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, info.getIcon(info.getEntityClassName()), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.popMatrix();
    }

    private static class EntityGroup {
        public GroupType groupType;
        public List<RadarEntityInfo> entities;
        public List<Integer> listColTextWidth;

        public EntityGroup(GroupType groupType) {
            this.groupType = groupType;
            this.entities = new ArrayList<RadarEntityInfo>();
            this.listColTextWidth = new ArrayList<Integer>();
        }

        public int getColWidth(int colIndex) {
            return 12 + this.listColTextWidth.get(colIndex) + 24 + 25;
        }

        public int getIconAndTextWidth(int colIndex) {
            return 12 + this.listColTextWidth.get(colIndex) + 1;
        }

        public int getTotalWidth() {
            int totalWidth = 0;
            for (int i = 0; i < this.listColTextWidth.size(); ++i) {
                totalWidth += this.getColWidth(i);
            }
            return totalWidth;
        }
    }
}

