/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.gui.screens.AddPlayerScreen;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ManagePlayersScreen
extends Screen {
    private static final int SLOT_HEIGHT = 16;
    private static PlayerType _activePlayerType = PlayerType.Ally;
    private final RadarConfig _config;
    private final Screen _parent;
    private Button _allyButton;
    private Button _enemyButton;
    private Button _deleteButton;
    private PlayerListContainer _playerListContainer;

    public ManagePlayersScreen(Screen parent, RadarConfig config) {
        super((Component)Component.literal((String)"Manage Players"));
        this._parent = parent;
        this._config = config;
    }

    public void init() {
        int x = this.width / 2 - 100;
        int y = this.height - 72;
        this._playerListContainer = (PlayerListContainer)this.addRenderableWidget((GuiEventListener)new PlayerListContainer(this));
        this._allyButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Allies"), btn -> this.loadPlayers(PlayerType.Ally)).bounds(x, y, 100, 20).build());
        this._enemyButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Enemies"), btn -> this.loadPlayers(PlayerType.Enemy)).bounds(x + 101, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Add Player"), btn -> this.minecraft.setScreen((Screen)new AddPlayerScreen(this, this._config, _activePlayerType))).bounds(x, y += 24, 100, 20).build());
        this._deleteButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Delete Player"), btn -> this.deletePlayer()).bounds(x + 101, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this._parent)).bounds(x, y += 24, 200, 20).build());
        this.loadPlayers(_activePlayerType);
    }

    private void loadPlayers(PlayerType playerType) {
        _activePlayerType = playerType;
        this._playerListContainer.replaceEntries(this._config.getPlayers(playerType).stream().map(x$0 -> new PlayerListItem((String)x$0)).toList());
        this._allyButton.active = playerType != PlayerType.Ally;
        this._enemyButton.active = playerType != PlayerType.Enemy;
        this._deleteButton.active = false;
    }

    private void deletePlayer() {
        String playerName = ((PlayerListItem)this._playerListContainer.getSelected()).getPlayerName();
        this._config.setPlayerType(playerName, PlayerType.Neutral);
        this._config.save();
        this.loadPlayers(_activePlayerType);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, Color.WHITE.getRGB());
    }

    private class PlayerListContainer
    extends AbstractSelectionList<PlayerListItem> {
        public PlayerListContainer(ManagePlayersScreen managePlayersScreen) {
            super(managePlayersScreen.minecraft, managePlayersScreen.width, managePlayersScreen.height - 108, 32, 16);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    private class PlayerListItem
    extends ObjectSelectionList.Entry<PlayerListItem> {
        private final String _playerName;

        public PlayerListItem(String playerName) {
            this._playerName = playerName;
        }

        public String getPlayerName() {
            return this._playerName;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.drawString(ManagePlayersScreen.this.font, this._playerName, this.getContentX() + 1, this.getContentY() + 1, Color.WHITE.getRGB(), true);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            ManagePlayersScreen.this._playerListContainer.setSelected((AbstractSelectionList.Entry)this);
            ManagePlayersScreen.this._deleteButton.active = true;
            return true;
        }

        public Component getNarration() {
            return null;
        }
    }
}

