/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar;

import com.aleksey.combatradar.ModHelper;
import com.aleksey.combatradar.SoundHelper;
import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.PlayerTypeInfo;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.entities.CustomRadarEntity;
import com.aleksey.combatradar.entities.EntitySettings;
import com.aleksey.combatradar.entities.ItemRadarEntity;
import com.aleksey.combatradar.entities.LiveRadarEntity;
import com.aleksey.combatradar.entities.PlayerRadarEntity;
import com.aleksey.combatradar.entities.RadarEntity;
import com.aleksey.combatradar.gui.CircleBorderElementRenderState;
import com.aleksey.combatradar.gui.CircleElementRenderState;
import com.aleksey.combatradar.gui.LineElementRenderState;
import com.aleksey.combatradar.gui.TriangleElementRenderState;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Radar {
    private static final Pattern MinecraftSpecialCodes = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Logger log = LoggerFactory.getLogger(Radar.class);
    private static RadarConfig _config;
    private final List<RadarEntity> _entities = new ArrayList<RadarEntity>();
    private final HashMap<UUID, MessageInfo> _messages = new HashMap();
    private final List<PlayerSoundInfo> _sounds = new ArrayList<PlayerSoundInfo>();
    private int _radarRadius;
    private float _radarScale;
    private int _radarDisplayX;
    private int _radarDisplayY;
    private Map<UUID, PlayerInfo> _radarPlayers;
    private Map<UUID, String> _onlinePlayers;
    private static Radar instance;

    public Radar(RadarConfig config) {
        if (instance != null) {
            throw new IllegalStateException("Radar instance has already been initialized");
        }
        instance = this;
        _config = config;
    }

    @NotNull
    public static Radar getInstance() {
        return Objects.requireNonNull(instance);
    }

    @NotNull
    public static RadarConfig getConfig() {
        return Objects.requireNonNull(_config);
    }

    private static Component getJourneyMapCoord(PlayerInfo playerInfo) {
        MutableComponent hover = Component.literal((String)"Click to add/edit waypoint.").withStyle(ChatFormatting.WHITE);
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hover);
        ClickEvent.RunCommand clickEvent = new ClickEvent.RunCommand("/jm waypoint create " + playerInfo.playerName + " " + String.valueOf(Minecraft.getInstance().player.level().dimension().location()) + " " + (int)playerInfo.posX + " " + String.valueOf(_config.getShowYLevel() ? Integer.valueOf((int)playerInfo.posY) : "~") + " " + (int)playerInfo.posZ + " aqua " + Minecraft.getInstance().player.getName().getString() + " false");
        Style coordStyle = Style.EMPTY.withClickEvent((ClickEvent)clickEvent).withHoverEvent((HoverEvent)hoverEvent).withColor(ChatFormatting.AQUA);
        return Component.literal((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).setStyle(coordStyle);
    }

    private static Component getVoxelMapCoord(PlayerInfo playerInfo) {
        MutableComponent hover = Component.literal((String)"Click to add/edit waypoint.").withStyle(ChatFormatting.WHITE);
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hover);
        ClickEvent.RunCommand clickEvent = new ClickEvent.RunCommand("/newWaypoint name:" + playerInfo.playerName + ", x:" + (int)playerInfo.posX + ", y:" + (int)(_config.getShowYLevel() ? playerInfo.posY : Minecraft.getInstance().player.getY()) + ", z:" + (int)playerInfo.posZ + ", dim:" + String.valueOf(Minecraft.getInstance().player.level().dimension().location()));
        Style coordStyle = Style.EMPTY.withClickEvent((ClickEvent)clickEvent).withHoverEvent((HoverEvent)hoverEvent).withColor(ChatFormatting.AQUA);
        return Component.literal((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).setStyle(coordStyle);
    }

    private static Component getXaerosCoord(PlayerInfo playerInfo) {
        MutableComponent hover = Component.literal((String)"Click to add/edit waypoint.").withStyle(ChatFormatting.WHITE);
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hover);
        ClickEvent.RunCommand clickEvent = new ClickEvent.RunCommand("/xaero_waypoint_add:" + playerInfo.playerName + ":" + playerInfo.playerName.substring(0, 2) + ":" + (int)playerInfo.posX + ":" + String.valueOf(_config.getShowYLevel() ? Integer.valueOf((int)playerInfo.posY) : "~") + ":" + (int)playerInfo.posZ + ":0:false:0");
        Style coordStyle = Style.EMPTY.withClickEvent((ClickEvent)clickEvent).withHoverEvent((HoverEvent)hoverEvent).withColor(ChatFormatting.AQUA);
        return Component.literal((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).setStyle(coordStyle);
    }

    private static String getChatCoordText(PlayerInfo playerInfo, boolean includeName, boolean includeBrackets, boolean includeY) {
        StringBuilder coordText = new StringBuilder();
        if (includeBrackets) {
            coordText.append("[");
        }
        if (_config.getIsJourneyMapEnabled() || _config.getIsVoxelMapEnabled()) {
            coordText.append("\u00a7'x:");
        } else {
            coordText.append("x:");
        }
        coordText.append((int)playerInfo.posX);
        if (includeY) {
            coordText.append(", y:");
            coordText.append((int)playerInfo.posY);
        }
        coordText.append(", z:");
        coordText.append((int)playerInfo.posZ);
        if (includeName) {
            coordText.append(", name:");
            coordText.append(playerInfo.playerName);
        }
        if (includeBrackets) {
            coordText.append("]");
        }
        return coordText.toString();
    }

    public int getRadarRadius() {
        return this._radarRadius;
    }

    public int getRadarDisplayX() {
        return this._radarDisplayX;
    }

    public int getRadarDisplayY() {
        return this._radarDisplayY;
    }

    private static float getPartialX(Entity entity, float partialTicks) {
        return Radar.getPartial((float)entity.xOld, (float)entity.getX(), partialTicks);
    }

    private static float getPartialZ(Entity entity, float partialTicks) {
        return Radar.getPartial((float)entity.zOld, (float)entity.getZ(), partialTicks);
    }

    private static float getPartial(float oldValue, float newValue, float partialTicks) {
        return oldValue + (newValue - oldValue) * partialTicks;
    }

    public void calcSettings() {
        Window window = Minecraft.getInstance().getWindow();
        int radarDiameter = (int)((float)(window.getGuiScaledHeight() - 2) * _config.getRadarSize());
        this._radarRadius = radarDiameter / 2;
        int windowInnerWidth = window.getGuiScaledWidth() - radarDiameter;
        int windowInnerHeight = window.getGuiScaledHeight() - radarDiameter;
        this._radarDisplayX = this._radarRadius + 1 + (int)(_config.getRadarX() * (float)(windowInnerWidth - 2));
        this._radarDisplayY = this._radarRadius + 1 + (int)(_config.getRadarY() * (float)(windowInnerHeight - 2));
        this._radarScale = (float)this._radarRadius / (float)_config.getRadarDistance();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        if (this._radarRadius == 0) {
            return;
        }
        float rotationYaw = Minecraft.getInstance().player.getViewYRot(partialTicks.getRealtimeDeltaTicks());
        poseStack.pushMatrix();
        poseStack.translate((float)this._radarDisplayX, (float)this._radarDisplayY);
        poseStack.rotate(org.joml.Math.toRadians((float)(-rotationYaw)));
        this.renderCircleBg(guiGraphics, this._radarRadius);
        this.renderCircleBorder(guiGraphics, this._radarRadius);
        this.renderLines(guiGraphics, this._radarRadius);
        this.renderNonPlayerEntities(guiGraphics, partialTicks.getRealtimeDeltaTicks());
        poseStack.rotate(org.joml.Math.toRadians((float)rotationYaw));
        this.renderTriangle(guiGraphics);
        poseStack.rotate(org.joml.Math.toRadians((float)(-rotationYaw)));
        this.renderPlayerEntities(guiGraphics, partialTicks.getRealtimeDeltaTicks());
        poseStack.popMatrix();
    }

    private void renderNonPlayerEntities(GuiGraphics guiGraphics, float partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        LocalPlayer player = Minecraft.getInstance().player;
        poseStack.pushMatrix();
        poseStack.scale(this._radarScale, this._radarScale);
        int i = 0;
        for (RadarEntity radarEntity : this._entities) {
            if (radarEntity instanceof PlayerRadarEntity) continue;
            this.renderEntity(guiGraphics, partialTicks, (Player)player, radarEntity);
            if (!(radarEntity instanceof ItemRadarEntity) || ++i <= 10000) continue;
            return;
        }
        poseStack.popMatrix();
    }

    private void renderPlayerEntities(GuiGraphics guiGraphics, float partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        LocalPlayer player = Minecraft.getInstance().player;
        poseStack.pushMatrix();
        poseStack.scale(this._radarScale, this._radarScale);
        for (RadarEntity radarEntity : this._entities) {
            if (!(radarEntity instanceof PlayerRadarEntity)) continue;
            this.renderEntity(guiGraphics, partialTicks, (Player)player, radarEntity);
        }
        poseStack.popMatrix();
    }

    private void renderEntity(GuiGraphics guiGraphics, float partialTicks, Player player, RadarEntity radarEntity) {
        float displayX = Radar.getPartialX((Entity)player, partialTicks) - Radar.getPartialX(radarEntity.getEntity(), partialTicks);
        float displayZ = Radar.getPartialZ((Entity)player, partialTicks) - Radar.getPartialZ(radarEntity.getEntity(), partialTicks);
        double distance = Mth.length((float)displayX, (float)displayZ);
        double scale = 1.0;
        if (distance > 0.1 && _config.getLogScaleEnabled()) {
            scale = 1.0 / distance * (Math.log1p(distance) / Math.log1p(_config.getRadarDistance())) * (double)_config.getRadarDistance();
        }
        radarEntity.render(guiGraphics, partialTicks, (float)((double)displayX * scale), (float)((double)displayZ * scale), Math.pow(distance, 2.0));
    }

    private void renderTriangle(GuiGraphics graphics) {
        graphics.pose().rotate(org.joml.Math.toRadians((float)180.0f));
        GL11.glEnable((int)2881);
        this.renderTriangle(graphics, -16777216, 0.0f);
        this.renderTriangle(graphics, -1, 0.5f);
        GL11.glDisable((int)2881);
        graphics.pose().rotate(org.joml.Math.toRadians((float)-180.0f));
    }

    private void renderTriangle(GuiGraphics graphics, int color, float offset) {
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new TriangleElementRenderState(ModHelper.TRIANGLES, new Matrix3x2f((Matrix3x2fc)graphics.pose()), graphics.scissorStack.peek(), offset, color));
    }

    private void renderLines(GuiGraphics graphics, float radius) {
        GL11.glEnable((int)2881);
        int color = ARGB.colorFromFloat((float)Math.clamp(_config.getRadarOpacity() + 0.5f, 0.0f, 1.0f), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new LineElementRenderState(ModHelper.LINES, new Matrix3x2f((Matrix3x2fc)graphics.pose()), graphics.scissorStack.peek(), radius, color));
        GL11.glDisable((int)2881);
    }

    private void renderCircleBg(GuiGraphics graphics, float radius) {
        int color = ARGB.colorFromFloat((float)_config.getRadarOpacity(), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new CircleElementRenderState(ModHelper.CIRCLE, new Matrix3x2f((Matrix3x2fc)graphics.pose()), graphics.scissorStack.peek(), radius, color));
    }

    private void renderCircleBorder(GuiGraphics graphics, float radius) {
        GL11.glEnable((int)2881);
        int color = ARGB.colorFromFloat((float)Math.clamp(_config.getRadarOpacity() + 0.5f, 0.0f, 1.0f), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new CircleBorderElementRenderState(ModHelper.BORDER, new Matrix3x2f((Matrix3x2fc)graphics.pose()), graphics.scissorStack.peek(), radius, color));
        GL11.glDisable((int)2881);
    }

    public void scanEntities() {
        this._entities.clear();
        this._sounds.clear();
        this._messages.clear();
        this.scanRadarEntities();
        if (_config.getLogPlayerStatus()) {
            this.scanOnlinePlayers();
        }
    }

    private void scanRadarEntities() {
        Minecraft minecraft = Minecraft.getInstance();
        Map<UUID, PlayerInfo> oldPlayers = this._radarPlayers;
        this._radarPlayers = new HashMap<UUID, PlayerInfo>();
        EntitySettings settings = this.createEntitySettings();
        Iterable entities = minecraft.level.entitiesForRendering();
        for (Entity entity : entities) {
            ResourceLocation icon;
            if (entity == minecraft.player || (icon = _config.getEnabledIcon(entity)) == null) continue;
            this.addEntity(entity, settings, oldPlayers, icon);
        }
        if (oldPlayers != null) {
            for (UUID playerKey : oldPlayers.keySet()) {
                PlayerInfo playerInfo = oldPlayers.get(playerKey);
                PlayerType playerType = _config.getPlayerType(playerInfo.playerName);
                PlayerTypeInfo playerTypeInfo = _config.getPlayerTypeInfo(playerType);
                if (!playerTypeInfo.ping && !_config.getLogPlayerStatus()) continue;
                this._messages.put(playerKey, new MessageInfo(playerInfo, MessageReason.Disappeared, playerTypeInfo.ping));
            }
        }
    }

    private void addEntity(Entity entity, EntitySettings settings, Map<UUID, PlayerInfo> oldPlayers, ResourceLocation icon) {
        RadarEntity radarEntity;
        if (entity instanceof ExperienceOrb) {
            radarEntity = new CustomRadarEntity(entity, settings, icon);
        } else if (entity instanceof ItemEntity) {
            radarEntity = new ItemRadarEntity(entity, settings);
        } else if (entity instanceof RemotePlayer) {
            PlayerType playerType = _config.getPlayerType(entity.getScoreboardName());
            radarEntity = new PlayerRadarEntity(entity, settings, playerType);
            UUID playerKey = entity.getUUID();
            PlayerInfo playerInfo = new PlayerInfo((AbstractClientPlayer)((RemotePlayer)entity));
            this._radarPlayers.put(playerKey, playerInfo);
            if (oldPlayers == null || !oldPlayers.containsKey(playerKey)) {
                PlayerTypeInfo playerTypeInfo = _config.getPlayerTypeInfo(playerType);
                if (playerTypeInfo.ping) {
                    this._sounds.add(new PlayerSoundInfo(playerTypeInfo.soundEventName, playerKey));
                }
                if (playerTypeInfo.ping || _config.getLogPlayerStatus()) {
                    this._messages.put(playerKey, new MessageInfo(playerInfo, MessageReason.Appeared, playerTypeInfo.ping));
                }
            } else {
                oldPlayers.remove(playerKey);
            }
        } else {
            radarEntity = entity instanceof ChestBoat ? new ItemRadarEntity(entity, settings, new ItemStack((ItemLike)Items.OAK_CHEST_BOAT)) : (entity instanceof Boat ? new ItemRadarEntity(entity, settings, new ItemStack((ItemLike)Items.OAK_BOAT)) : (entity instanceof AbstractMinecart ? new ItemRadarEntity(entity, settings, new ItemStack((ItemLike)Items.MINECART)) : new LiveRadarEntity(entity, settings, icon)));
        }
        this._entities.add(radarEntity);
    }

    private EntitySettings createEntitySettings() {
        EntitySettings settings = new EntitySettings();
        settings.radarDistanceSq = _config.getRadarDistance() * _config.getRadarDistance();
        settings.iconScale = _config.getIconScale();
        settings.iconOpacity = 1.0f;
        settings.radarScale = this._radarScale;
        settings.fontScale = _config.getFontScale();
        settings.neutralPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Neutral).color;
        settings.allyPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Ally).color;
        settings.enemyPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Enemy).color;
        settings.showPlayerNames = _config.getShowPlayerNames();
        settings.showExtraPlayerInfo = _config.getShowExtraPlayerInfo();
        settings.showYLevel = _config.getShowYLevel();
        return settings;
    }

    private void scanOnlinePlayers() {
        Minecraft minecraft = Minecraft.getInstance();
        Collection players = minecraft.getConnection().getOnlinePlayers();
        Map<UUID, String> oldOnlinePlayers = this._onlinePlayers;
        UUID currentPlayerId = minecraft.player.getUUID();
        this._onlinePlayers = new HashMap<UUID, String>();
        for (net.minecraft.client.multiplayer.PlayerInfo p : players) {
            String playerName;
            String playerNameTrimmed;
            GameProfile profile = p.getProfile();
            UUID playerKey = profile.getId();
            if (playerKey.equals(currentPlayerId) || _config.isPlayerExcluded(playerNameTrimmed = MinecraftSpecialCodes.matcher(playerName = profile.getName()).replaceAll(""))) continue;
            this._onlinePlayers.put(playerKey, playerName);
            if (oldOnlinePlayers == null || !oldOnlinePlayers.containsKey(playerKey)) {
                MessageInfo message = this._messages.get(playerKey);
                if (message != null) {
                    message.reason = MessageReason.Login;
                    message.log = true;
                    continue;
                }
                this._messages.put(playerKey, new MessageInfo(playerName, MessageReason.Login));
                continue;
            }
            oldOnlinePlayers.remove(playerKey);
        }
        if (oldOnlinePlayers != null) {
            for (UUID playerKey : oldOnlinePlayers.keySet()) {
                MessageInfo message = this._messages.get(playerKey);
                if (message != null) {
                    message.reason = MessageReason.Logout;
                    message.log = true;
                    continue;
                }
                this._messages.put(playerKey, new MessageInfo(oldOnlinePlayers.get(playerKey), MessageReason.Logout));
            }
        }
    }

    public void playSounds() {
        for (PlayerSoundInfo sound : this._sounds) {
            SoundHelper.playSound(sound.soundEventName, sound.playerKey);
        }
    }

    public void sendMessages() {
        Minecraft minecraft = Minecraft.getInstance();
        for (MessageInfo message : this._messages.values()) {
            if (!message.log) continue;
            this.sendMessage(minecraft, message);
        }
    }

    private void sendMessage(Minecraft minecraft, MessageInfo messageInfo) {
        ChatFormatting actionColor;
        String actionText;
        MutableComponent text = Component.literal((String)"[CR] ").withStyle(ChatFormatting.DARK_AQUA);
        PlayerType playerType = _config.getPlayerType(messageInfo.playerName);
        ChatFormatting playerColor = switch (playerType) {
            case PlayerType.Ally -> ChatFormatting.GREEN;
            case PlayerType.Enemy -> ChatFormatting.DARK_RED;
            default -> ChatFormatting.WHITE;
        };
        text = text.append((Component)Component.literal((String)messageInfo.playerName).withStyle(playerColor));
        switch (messageInfo.reason.ordinal()) {
            case 0: {
                actionText = " joined the game";
                actionColor = messageInfo.playerInfo != null ? ChatFormatting.YELLOW : ChatFormatting.DARK_GREEN;
                break;
            }
            case 1: {
                actionText = " left the game";
                actionColor = ChatFormatting.DARK_GREEN;
                break;
            }
            case 2: {
                actionText = " appeared on radar";
                actionColor = ChatFormatting.YELLOW;
                break;
            }
            case 3: {
                actionText = " disappeared from radar";
                actionColor = ChatFormatting.YELLOW;
                break;
            }
            default: {
                return;
            }
        }
        text = text.append((Component)Component.literal((String)actionText).withStyle(actionColor));
        if (messageInfo.playerInfo != null) {
            if (_config.getIsJourneyMapEnabled()) {
                Component coordText = Radar.getJourneyMapCoord(messageInfo.playerInfo);
                text = text.append((Component)Component.literal((String)" at ").withStyle(actionColor)).append(coordText);
            } else if (_config.getIsVoxelMapEnabled()) {
                Component coordText = Radar.getVoxelMapCoord(messageInfo.playerInfo);
                text = text.append((Component)Component.literal((String)" at ").withStyle(actionColor)).append(coordText);
            } else if (_config.getIsXaerosEnabled()) {
                Component coordText = Radar.getXaerosCoord(messageInfo.playerInfo);
                text = text.append((Component)Component.literal((String)" at ").withStyle(actionColor)).append(coordText);
            } else {
                MutableComponent coordText = Component.literal((String)Radar.getChatCoordText(messageInfo.playerInfo, false, true, _config.getShowYLevel())).withStyle(actionColor);
                text = text.append((Component)Component.literal((String)" at ").withStyle(actionColor)).append((Component)coordText);
            }
        }
        minecraft.player.displayClientMessage((Component)text, false);
    }

    private static class PlayerInfo {
        public String playerName;
        public double posX;
        public double posY;
        public double posZ;

        public PlayerInfo(AbstractClientPlayer player) {
            this.playerName = player.getScoreboardName();
            this.posX = player.getX();
            this.posY = player.getY();
            this.posZ = player.getZ();
        }
    }

    private static class MessageInfo {
        public String playerName;
        public PlayerInfo playerInfo;
        public MessageReason reason;
        public boolean log;

        public MessageInfo(String playerName, MessageReason reason) {
            this.playerName = playerName;
            this.playerInfo = null;
            this.reason = reason;
            this.log = true;
        }

        public MessageInfo(PlayerInfo playerInfo, MessageReason reason, boolean log) {
            this.playerName = playerInfo.playerName;
            this.playerInfo = playerInfo;
            this.reason = reason;
            this.log = log;
        }
    }

    private static enum MessageReason {
        Login,
        Logout,
        Appeared,
        Disappeared;

    }

    private static class PlayerSoundInfo {
        public String soundEventName;
        public UUID playerKey;

        public PlayerSoundInfo(String soundEventName, UUID playerKey) {
            this.soundEventName = soundEventName;
            this.playerKey = playerKey;
        }
    }
}

