/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import org.joml.Matrix3x2fStack;

public class Speedometer {
    private static final int _maxCount = 5;
    private static final double _maxSpeed = 100.0;
    private final ArrayList<Double> _speedList = new ArrayList(5);
    private long _prevTime;
    private double _prevX;
    private double _prevZ;
    private String _speedText;

    public void calc() {
        if (this._speedList.size() == 5) {
            this._speedList.remove(0);
        }
        double currentSpeed = this.calcCurrentSpeed();
        this._speedList.add(currentSpeed);
        double sum = 0.0;
        for (double speed : this._speedList) {
            sum += speed;
        }
        double avgSpeed = (double)Math.round(10.0 * sum / (double)this._speedList.size()) / 10.0;
        this._speedText = String.format("%.1f m/s", avgSpeed);
    }

    public void clearSpeed() {
        this._speedList.clear();
        this._speedText = "0.0 m/s";
        this._prevTime = 0L;
    }

    private double calcCurrentSpeed() {
        double speed;
        LocalPlayer player = Minecraft.getInstance().player;
        long time = System.nanoTime();
        double x = player.getX();
        double z = player.getZ();
        if (this._prevTime != 0L) {
            double timeDelta = time - this._prevTime;
            double xDelta = x - this._prevX;
            double zDelta = z - this._prevZ;
            double distance = Math.sqrt(Math.pow(xDelta, 2.0) + Math.pow(zDelta, 2.0));
            speed = 1.0E9 * distance / timeDelta;
            if (speed > 100.0) {
                speed = 0.0;
            }
        } else {
            speed = 0.0;
        }
        this._prevTime = time;
        this._prevX = x;
        this._prevZ = z;
        return speed;
    }

    public void render(GuiGraphics guiGraphics, int radarDisplayX, int radarDisplayY, int radarRadius) {
        float f;
        int yMargin = 2;
        Minecraft minecraft = Minecraft.getInstance();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        Font font = minecraft.font;
        int windowHeight = minecraft.getWindow().getGuiScaledHeight();
        float xOffset = (float)(-font.width(this._speedText)) / 2.0f;
        Objects.requireNonNull(font);
        if (radarDisplayY + radarRadius + 9 + 2 > windowHeight) {
            int n = -radarRadius;
            Objects.requireNonNull(font);
            f = n - 9 - 2;
        } else {
            f = radarRadius + 2;
        }
        float yOffset = f;
        poseStack.pushMatrix();
        poseStack.translate((float)radarDisplayX, (float)radarDisplayY);
        guiGraphics.drawString(font, this._speedText, (int)xOffset, (int)yOffset, Color.WHITE.getRGB());
        poseStack.popMatrix();
    }
}

