/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.gui.components.SliderButton;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class LocationAndColorScreen
extends Screen {
    private final RadarConfig _config;
    private final Screen _parent;
    private SliderButton _redSlider;
    private SliderButton _greenSlider;
    private SliderButton _blueSlider;
    private SliderButton _opacitySlider;
    private SliderButton _sizeSlider;
    private SliderButton _rangeSlider;
    private SliderButton _iconScaleSlider;
    private SliderButton _fontScaleSlider;

    public LocationAndColorScreen(Screen parent, RadarConfig config) {
        super(CommonComponents.EMPTY);
        this._parent = parent;
        this._config = config;
    }

    public void init() {
        int y = this.height / 4 - 16;
        int x = this.width / 2 - 100;
        this._redSlider = new SliderButton(x, y, 66, 1.0f, 0.0f, "Red", (float)this._config.getRadarColor().getRed() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._redSlider);
        this._greenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)this._config.getRadarColor().getGreen() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._greenSlider);
        this._blueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)this._config.getRadarColor().getBlue() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._blueSlider);
        this._opacitySlider = new SliderButton(x, y += 24, 200, 1.0f, 0.0f, "Radar Opacity", this._config.getRadarOpacity(), false);
        this.addRenderableWidget((GuiEventListener)this._opacitySlider);
        this._sizeSlider = new SliderButton(x, y += 24, 100, 1.0f, 0.1f, "Radar Size", this._config.getRadarSize(), false);
        this.addRenderableWidget((GuiEventListener)this._sizeSlider);
        this._rangeSlider = new SliderButton(x + 101, y, 100, 8.0f, 3.0f, "Radar Range", (float)this._config.getRadarDistance() / 16.0f, true);
        this.addRenderableWidget((GuiEventListener)this._rangeSlider);
        this._iconScaleSlider = new SliderButton(x, y += 24, 100, 1.0f, 0.1f, "Icon Size", this._config.getIconScale() / 3.0f, false);
        this.addRenderableWidget((GuiEventListener)this._iconScaleSlider);
        this._fontScaleSlider = new SliderButton(x + 101, y, 100, 1.0f, 0.2f, "Font Size", this._config.getFontScale() / 3.0f, false);
        this.addRenderableWidget((GuiEventListener)this._fontScaleSlider);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Snap top left"), btn -> this.setRadar(0.0f, 0.0f)).bounds(x, y += 48, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Snap top right"), btn -> this.setRadar(1.0f, 0.0f)).bounds(x + 101, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Snap bottom left"), btn -> this.setRadar(0.0f, 1.0f)).bounds(x, y += 24, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Snap bottom right"), btn -> this.setRadar(1.0f, 1.0f)).bounds(x + 101, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> this.minecraft.setScreen(this._parent)).bounds(x, y += 24, 200, 20).build());
    }

    private void setRadar(float x, float y) {
        this._config.setRadarX(x);
        this._config.setRadarY(y);
        this._config.save();
    }

    public void tick() {
        Color radarColor;
        boolean isChanged = false;
        Window window = this.minecraft.getWindow();
        long windowId = window.getWindow();
        float xSpeed = 1.0f / (float)window.getGuiScaledWidth();
        float ySpeed = 1.0f / (float)window.getGuiScaledHeight();
        if (InputConstants.isKeyDown((long)windowId, (int)263)) {
            this._config.setRadarX(this._config.getRadarX() - xSpeed);
            isChanged = true;
        }
        if (InputConstants.isKeyDown((long)windowId, (int)262)) {
            this._config.setRadarX(this._config.getRadarX() + xSpeed);
            isChanged = true;
        }
        if (InputConstants.isKeyDown((long)windowId, (int)265)) {
            this._config.setRadarY(this._config.getRadarY() - ySpeed);
            isChanged = true;
        }
        if (InputConstants.isKeyDown((long)windowId, (int)264)) {
            this._config.setRadarY(this._config.getRadarY() + ySpeed);
            isChanged = true;
        }
        isChanged = this._config.setRadarColor(radarColor = new Color(this._redSlider.getValue(), this._greenSlider.getValue(), this._blueSlider.getValue())) || isChanged;
        isChanged = this._config.setRadarOpacity(this._opacitySlider.getValue()) || isChanged;
        isChanged = this._config.setRadarSize(this._sizeSlider.getValue()) || isChanged;
        isChanged = this._config.setRadarDistance((int)(this._rangeSlider.getValue() * 16.0f)) || isChanged;
        isChanged = this._config.setIconScale(this._iconScaleSlider.getValue() * 3.0f) || isChanged;
        boolean bl = isChanged = this._config.setFontScale(this._fontScaleSlider.getValue() * 3.0f) || isChanged;
        if (isChanged) {
            this._config.save();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.drawCenteredString(this.font, "Location and Color", this.width / 2, this.height / 4 - 40, Color.WHITE.getRGB());
        guiGraphics.drawCenteredString(this.font, "Use arrow keys to reposition radar", this.width / 2, this._iconScaleSlider.getY() + 24 + 12, Color.WHITE.getRGB());
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, 0, 0);
    }
}

