/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.PlayerTypeInfo;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.config.SoundInfo;
import com.aleksey.combatradar.gui.components.SliderButton;
import com.aleksey.combatradar.gui.screens.ChooseSoundScreen;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class PlayerSettingsScreen
extends Screen {
    private final RadarConfig _config;
    private final Screen _parent;
    private SliderButton _neutralRedSlider;
    private SliderButton _neutralGreenSlider;
    private SliderButton _neutralBlueSlider;
    private SliderButton _allyRedSlider;
    private SliderButton _allyGreenSlider;
    private SliderButton _allyBlueSlider;
    private SliderButton _enemyRedSlider;
    private SliderButton _enemyGreenSlider;
    private SliderButton _enemyBlueSlider;
    private Button _neutralPingButton;
    private Button _neutralSoundButton;
    private Button _allyPingButton;
    private Button _allySoundButton;
    private Button _enemyPingButton;
    private Button _enemySoundButton;
    private Button _showYLevelButton;

    public PlayerSettingsScreen(Screen parent, RadarConfig config) {
        super((Component)Component.literal((String)"Player Settings"));
        this._parent = parent;
        this._config = config;
    }

    public void init() {
        int y = this.height / 4 - 16 + 12;
        int x = this.width / 2 - 100;
        PlayerTypeInfo neutralInfo = this._config.getPlayerTypeInfo(PlayerType.Neutral);
        PlayerTypeInfo allyInfo = this._config.getPlayerTypeInfo(PlayerType.Ally);
        PlayerTypeInfo enemyInfo = this._config.getPlayerTypeInfo(PlayerType.Enemy);
        this._neutralRedSlider = new SliderButton(x, y, 66, 1.0f, 0.0f, "Red", (float)neutralInfo.color.getRed() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._neutralRedSlider);
        this._neutralGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)neutralInfo.color.getGreen() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._neutralGreenSlider);
        this._neutralBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)neutralInfo.color.getBlue() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._neutralBlueSlider);
        this._allyRedSlider = new SliderButton(x, y += 36, 66, 1.0f, 0.0f, "Red", (float)allyInfo.color.getRed() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._allyRedSlider);
        this._allyGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)allyInfo.color.getGreen() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._allyGreenSlider);
        this._allyBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)allyInfo.color.getBlue() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._allyBlueSlider);
        this._enemyRedSlider = new SliderButton(x, y += 36, 66, 1.0f, 0.0f, "Red", (float)enemyInfo.color.getRed() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._enemyRedSlider);
        this._enemyGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)enemyInfo.color.getGreen() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._enemyGreenSlider);
        this._enemyBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)enemyInfo.color.getBlue() / 255.0f, false);
        this.addRenderableWidget((GuiEventListener)this._enemyBlueSlider);
        this._neutralPingButton = Button.builder((Component)Component.literal((String)"Neutral Player Ping"), btn -> this.changePing(PlayerType.Neutral)).bounds(x, y += 24, 133, 20).build();
        this.addRenderableWidget((GuiEventListener)this._neutralPingButton);
        this._neutralSoundButton = Button.builder((Component)Component.literal((String)"Sound"), btn -> this.changePingSound(PlayerType.Neutral)).bounds(x + 133 + 1, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._neutralSoundButton);
        this._allyPingButton = Button.builder((Component)Component.literal((String)"Ally Player Ping"), btn -> this.changePing(PlayerType.Ally)).bounds(x, y += 24, 133, 20).build();
        this.addRenderableWidget((GuiEventListener)this._allyPingButton);
        this._allySoundButton = Button.builder((Component)Component.literal((String)"Sound"), btn -> this.changePingSound(PlayerType.Ally)).bounds(x + 133 + 1, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._allySoundButton);
        this._enemyPingButton = Button.builder((Component)Component.literal((String)"Enemy Player Ping"), btn -> this.changePing(PlayerType.Enemy)).bounds(x, y += 24, 133, 20).build();
        this.addRenderableWidget((GuiEventListener)this._enemyPingButton);
        this._enemySoundButton = Button.builder((Component)Component.literal((String)"Sound"), btn -> this.changePingSound(PlayerType.Enemy)).bounds(x + 133 + 1, y, 66, 20).build();
        this.addRenderableWidget((GuiEventListener)this._enemySoundButton);
        this._showYLevelButton = Button.builder((Component)Component.literal((String)"Use Y Levels:"), btn -> {
            this._config.setShowYLevel(!this._config.getShowYLevel());
            this._config.save();
        }).bounds(x, y += 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this._showYLevelButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this._parent)).bounds(x, y += 24, 200, 20).build());
    }

    private void changePing(PlayerType playerType) {
        PlayerTypeInfo playerTypeInfo = this._config.getPlayerTypeInfo(playerType);
        playerTypeInfo.ping = !playerTypeInfo.ping;
        this._config.save();
    }

    private void changePingSound(PlayerType playerType) {
        this.minecraft.setScreen((Screen)new ChooseSoundScreen(this, this._config, playerType));
    }

    public void tick() {
        Color neutralColor = new Color(this._neutralRedSlider.getValue(), this._neutralGreenSlider.getValue(), this._neutralBlueSlider.getValue());
        Color allyColor = new Color(this._allyRedSlider.getValue(), this._allyGreenSlider.getValue(), this._allyBlueSlider.getValue());
        Color enemyColor = new Color(this._enemyRedSlider.getValue(), this._enemyGreenSlider.getValue(), this._enemyBlueSlider.getValue());
        boolean isChanged = this.changeColor(PlayerType.Neutral, neutralColor);
        isChanged = this.changeColor(PlayerType.Ally, allyColor) || isChanged;
        boolean bl = isChanged = this.changeColor(PlayerType.Enemy, enemyColor) || isChanged;
        if (isChanged) {
            this._config.save();
        }
        PlayerTypeInfo neutralPlayer = this._config.getPlayerTypeInfo(PlayerType.Neutral);
        PlayerTypeInfo allyPlayer = this._config.getPlayerTypeInfo(PlayerType.Ally);
        PlayerTypeInfo enemyPlayer = this._config.getPlayerTypeInfo(PlayerType.Enemy);
        this._neutralPingButton.setMessage((Component)Component.literal((String)("Neutral Player Ping: " + (neutralPlayer.ping ? "On" : "Off"))));
        this._neutralSoundButton.setMessage((Component)Component.literal((String)SoundInfo.getByValue((String)neutralPlayer.soundEventName).name));
        this._allyPingButton.setMessage((Component)Component.literal((String)("Ally Player Ping: " + (allyPlayer.ping ? "On" : "Off"))));
        this._allySoundButton.setMessage((Component)Component.literal((String)SoundInfo.getByValue((String)allyPlayer.soundEventName).name));
        this._enemyPingButton.setMessage((Component)Component.literal((String)("Enemy Player Ping: " + (enemyPlayer.ping ? "On" : "Off"))));
        this._enemySoundButton.setMessage((Component)Component.literal((String)SoundInfo.getByValue((String)enemyPlayer.soundEventName).name));
        this._showYLevelButton.setMessage((Component)Component.literal((String)("Use Y Levels: " + (this._config.getShowYLevel() ? "On" : "Off"))));
    }

    private boolean changeColor(PlayerType playerType, Color color) {
        PlayerTypeInfo info = this._config.getPlayerTypeInfo(playerType);
        if (info.color == color) {
            return false;
        }
        info.color = color;
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 4 - 40, Color.WHITE.getRGB());
        guiGraphics.drawCenteredString(this.font, "Neutral", this.width / 2, this._neutralRedSlider.getY() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Neutral).color.getRGB());
        guiGraphics.drawCenteredString(this.font, "Ally", this.width / 2, this._allyRedSlider.getY() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Ally).color.getRGB());
        guiGraphics.drawCenteredString(this.font, "Enemy", this.width / 2, this._enemyRedSlider.getY() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Enemy).color.getRGB());
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, 0, 0);
    }
}

