/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.neoforge;

import com.aleksey.combatradar.ModHelper;
import com.aleksey.combatradar.gui.screens.MainScreen;
import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="combatradar")
public class NeoForgeModCombatRadar {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ModHelper _modHelper = new ModHelper();

    public NeoForgeModCombatRadar(IEventBus bus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::registerBindings);
        bus.addListener(RegisterRenderPipelinesEvent.class, renderPipelinesEvent -> {
            renderPipelinesEvent.registerPipeline(ModHelper.CIRCLE);
            renderPipelinesEvent.registerPipeline(ModHelper.TRIANGLES);
            renderPipelinesEvent.registerPipeline(ModHelper.BORDER);
            renderPipelinesEvent.registerPipeline(ModHelper.LINES);
        });
        bus.addListener(FMLClientSetupEvent.class, clientSetupEvent -> {
            this._modHelper.init(LOGGER);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, parent) -> new MainScreen(parent, this._modHelper.getConfig(), this._modHelper.getSpeedometer())));
            LOGGER.info("[CombatRadar]: mod enabled");
        });
    }

    public void registerBindings(RegisterKeyMappingsEvent event) {
        event.register(this._modHelper.getSettingsKey());
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        this._modHelper.tick();
    }

    @SubscribeEvent
    public void onRender(RenderGuiLayerEvent.Post event) {
        if (event.getName() == VanillaGuiLayers.SUBTITLE_OVERLAY) {
            this._modHelper.render(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatReceivedEvent event) {
        if (this._modHelper.processChat(event.getMessage())) {
            event.setCanceled(true);
        }
    }
}

