/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.entities;

import com.aleksey.combatradar.entities.EntitySettings;
import com.aleksey.combatradar.entities.RadarEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import org.joml.Math;
import org.joml.Matrix3x2fStack;

public class CustomRadarEntity
extends RadarEntity {
    private final ResourceLocation _resourceLocation;

    public CustomRadarEntity(Entity entity, EntitySettings settings, ResourceLocation icon) {
        super(entity, settings);
        this._resourceLocation = icon;
    }

    @Override
    protected void renderInternal(GuiGraphics guiGraphics, float displayX, float displayY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        float iconScale = this.getSettings().iconScale;
        float rotationYaw = minecraft.player.getViewYRot(partialTicks);
        poseStack.pushMatrix();
        poseStack.translate(displayX, displayY);
        poseStack.rotate(Math.toRadians((float)rotationYaw));
        poseStack.scale(iconScale, iconScale);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this._resourceLocation, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16, ARGB.colorFromFloat((float)this.getSettings().iconOpacity, (float)1.0f, (float)1.0f, (float)1.0f));
        poseStack.popMatrix();
    }
}

