/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.SoundHelper;
import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.config.SoundInfo;
import com.aleksey.combatradar.gui.components.CheckButton;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ChooseSoundScreen
extends Screen {
    private static final int MAX_BUTTON_PER_COL = 6;
    private final RadarConfig _config;
    private final Screen _parent;
    private final PlayerType _playerType;
    private final ArrayList<CheckButton> _checkButtons;
    private int _titleTop;

    public ChooseSoundScreen(Screen parent, RadarConfig config, PlayerType playerType) {
        super((Component)Component.literal((String)(switch (playerType) {
            case PlayerType.Ally -> "Ally";
            case PlayerType.Enemy -> "Enemy";
            default -> "Neutral";
        })));
        this._parent = parent;
        this._config = config;
        this._playerType = playerType;
        this._checkButtons = new ArrayList();
    }

    protected void init() {
        this._titleTop = this.height / 4 - 40;
        int topY = this.height / 4 - 16;
        int leftX = this.width / 2 - 60;
        int y = topY;
        int x = leftX;
        String sound = this._config.getPlayerTypeInfo((PlayerType)this._playerType).soundEventName;
        for (int i = 0; i < SoundInfo.SOUND_LIST.length; ++i) {
            SoundInfo info = SoundInfo.SOUND_LIST[i];
            int soundIndex = i;
            CheckButton chk = new CheckButton(x, y, 80, info.name, btn -> this.chooseSound(soundIndex));
            this._checkButtons.add(chk);
            chk.setChecked(sound.equalsIgnoreCase(info.value));
            this.addRenderableWidget((GuiEventListener)chk);
            if (i == 5) {
                y = topY;
                x = leftX + 80;
                continue;
            }
            y += 20;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this._parent)).bounds(this.width / 2 - 100, y, 200, 20).build());
    }

    public void removed() {
        this._config.save();
    }

    private void chooseSound(int index) {
        for (int i = 0; i < SoundInfo.SOUND_LIST.length; ++i) {
            boolean isChecked = i == index;
            this._checkButtons.get(i).setChecked(isChecked);
        }
        SoundInfo soundInfo = SoundInfo.SOUND_LIST[index];
        this._config.getPlayerTypeInfo((PlayerType)this._playerType).soundEventName = soundInfo.value;
        this._config.save();
        SoundHelper.playSound(soundInfo.value, this.minecraft.player.getUUID());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this._titleTop, Color.WHITE.getRGB());
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

