/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.Speedometer;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.gui.screens.EntityScreen;
import com.aleksey.combatradar.gui.screens.LocationAndColorScreen;
import com.aleksey.combatradar.gui.screens.ManagePlayersScreen;
import com.aleksey.combatradar.gui.screens.PlayerSettingsScreen;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class MainScreen
extends Screen {
    private final RadarConfig _config;
    private final Speedometer _speedometer;
    private final Screen _parent;
    private Button _playerStatusButton;
    private Button _speedometerButton;
    private Button _scaleButton;
    private Button _enableButton;
    private Button _pingsEnableButton;
    private int _keyHintY;

    public MainScreen(Screen parent, RadarConfig config, Speedometer speedometer) {
        super((Component)Component.literal((String)"Combat Radar Settings"));
        this._parent = parent;
        this._config = config;
        this._speedometer = speedometer;
    }

    public void init() {
        int y = this.height / 4 - 16;
        int x = this.width / 2 - 100;
        MainScreen screen = this;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Location and Color"), btn -> this.minecraft.setScreen((Screen)new LocationAndColorScreen(screen, this._config))).bounds(x, y, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Player Settings"), btn -> this.minecraft.setScreen((Screen)new PlayerSettingsScreen(screen, this._config))).bounds(x, y += 24, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Radar Entities"), btn -> this.minecraft.setScreen((Screen)new EntityScreen(screen, this._config))).bounds(x, y += 24, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Manage Players"), btn -> this.minecraft.setScreen((Screen)new ManagePlayersScreen(screen, this._config))).bounds(x + 101, y, 100, 20).build());
        this._playerStatusButton = Button.builder((Component)Component.literal((String)"Log Players Statuses:"), btn -> {
            this._config.setLogPlayerStatus(!this._config.getLogPlayerStatus());
            this._config.save();
        }).bounds(x, y += 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this._playerStatusButton);
        this._scaleButton = Button.builder((Component)Component.literal((String)"Scale:"), btn -> {
            this._config.setLogScaleEnabled(!this._config.getLogScaleEnabled());
            this._config.save();
        }).bounds(x, y += 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this._scaleButton);
        this._speedometerButton = Button.builder((Component)Component.literal((String)"Speed:"), btn -> {
            this._config.setSpeedometerEnabled(!this._config.getSpeedometerEnabled());
            this._config.save();
            if (!this._config.getSpeedometerEnabled()) {
                this._speedometer.clearSpeed();
            }
        }).bounds(x + 101, y, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this._speedometerButton);
        this._enableButton = Button.builder((Component)Component.literal((String)"Radar:"), btn -> {
            this._config.setEnabled(!this._config.getEnabled());
            this._config.save();
        }).bounds(x, y += 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this._enableButton);
        this._pingsEnableButton = Button.builder((Component)Component.literal((String)"Pings:"), btn -> {
            this._config.setPingsEnabled(!this._config.getPingsEnabled());
            this._config.save();
        }).bounds(x + 101, y, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this._pingsEnableButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this._parent)).bounds(x, y += 24, 200, 20).build());
        this._keyHintY = y + 24;
    }

    public void tick() {
        this._playerStatusButton.setMessage((Component)Component.literal((String)("Log Players Statuses: " + (this._config.getLogPlayerStatus() ? "On" : "Off"))));
        this._enableButton.setMessage((Component)Component.literal((String)("Radar: " + (this._config.getEnabled() ? "On" : "Off"))));
        this._pingsEnableButton.setMessage((Component)Component.literal((String)("Pings: " + (this._config.getPingsEnabled() ? "On" : "Off"))));
        this._speedometerButton.setMessage((Component)Component.literal((String)("Speed: " + (this._config.getSpeedometerEnabled() ? "On" : "Off"))));
        this._scaleButton.setMessage((Component)Component.literal((String)("Scale: " + (this._config.getLogScaleEnabled() ? "LOGARITHMIC" : "LINEAR"))));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        String keyName = this._config.getSettingsKey().getTranslatedKeyMessage().getString().toUpperCase();
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 4 - 40, Color.WHITE.getRGB());
        guiGraphics.drawCenteredString(this.font, "Ctrl+Alt+" + keyName + " - enable/disable radar", this.width / 2, this._keyHintY, Color.LIGHT_GRAY.getRGB());
        guiGraphics.drawCenteredString(this.font, "Ctrl+" + keyName + " - enable/disable mobs", this.width / 2, this._keyHintY + 12, Color.LIGHT_GRAY.getRGB());
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, 0, 0);
    }
}

