/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar;

import com.aleksey.combatradar.Radar;
import com.aleksey.combatradar.Speedometer;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.gui.screens.MainScreen;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_10789;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_9779;
import org.slf4j.Logger;

public class ModHelper {
    private Logger _logger;
    private RadarConfig _config;
    private Radar _radar;
    private Speedometer _speedometer;
    private class_304.class_11900 _category = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"combatradar", (String)"keybind"));
    private static final BlendFunction blendFunc = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
    private static final RenderPipeline.Snippet UNIFORM_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withVertexShader("core/position_color").withFragmentShader("core/position_color").withUniform("DynamicTransforms", class_10789.field_60031).withUniform("Projection", class_10789.field_60031).withBlend(BlendFunction.TRANSLUCENT).buildSnippet();
    public static final RenderPipeline TRIANGLES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{UNIFORM_SNIPPET}).withLocation(class_2960.method_60655((String)"combatradar", (String)"pipelines/triangles")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27379).build();
    public static final RenderPipeline LINES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{UNIFORM_SNIPPET}).withLocation(class_2960.method_60655((String)"combatradar", (String)"pipelines/lines")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).build();
    public static final RenderPipeline CIRCLE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{UNIFORM_SNIPPET}).withLocation(class_2960.method_60655((String)"combatradar", (String)"pipelines/circle")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27381).build();
    public static final RenderPipeline BORDER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{UNIFORM_SNIPPET}).withLocation(class_2960.method_60655((String)"combatradar", (String)"pipelines/border")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).build();
    private final class_304 _settingsKey = new class_304("Combat Radar Settings", 82, this._category);

    public class_304 getSettingsKey() {
        return this._settingsKey;
    }

    public class_304.class_11900 getKeyBindCategory() {
        return this._category;
    }

    public void init(Logger logger) {
        this._logger = logger;
        File gameDirectory = class_310.method_1551().field_1697;
        File configDir = new File(gameDirectory, "/combatradar/");
        if (!configDir.isDirectory()) {
            configDir.mkdir();
        }
        File configFile = new File(configDir, "config.json");
        this._config = new RadarConfig(configFile, this._settingsKey);
        if (!configFile.isFile()) {
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._config.save();
        } else if (!this._config.load()) {
            this._config.save();
        }
        this._config.setIsJourneyMapEnabled(this.isJourneyMapEnabled());
        this._config.setIsVoxelMapEnabled(this.isVoxelMapEnabled());
        this._config.setIsXaerosEnabled(this.isXaerosEnabled());
        this._radar = new Radar(this._config);
        this._speedometer = new Speedometer();
    }

    public void tick() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        if (this._config.getPingsEnabled() || this._config.getEnabled()) {
            this._radar.scanEntities();
        }
        if (this._config.getEnabled()) {
            this._radar.calcSettings();
            if (this._config.getSpeedometerEnabled()) {
                this._speedometer.calc();
            }
        }
        if (this._config.getPingsEnabled()) {
            this._radar.sendMessages();
            this._radar.playSounds();
        }
        if (!minecraft.field_1690.field_1842 && minecraft.field_1755 == null && this._config.getSettingsKey().method_1436()) {
            class_1041 windowId = minecraft.method_22683();
            if (class_3675.method_15987((class_1041)windowId, (int)341) || class_3675.method_15987((class_1041)windowId, (int)345)) {
                if (class_3675.method_15987((class_1041)windowId, (int)342) || class_3675.method_15987((class_1041)windowId, (int)346)) {
                    this._config.setEnabled(!this._config.getEnabled());
                    this._config.save();
                } else {
                    this._config.revertNeutralAggressive();
                    this._config.save();
                }
            } else {
                minecraft.method_1507((class_437)new MainScreen(minecraft.field_1755, this._config, this._speedometer));
            }
        }
    }

    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        class_310 minecraft = class_310.method_1551();
        if (!this._config.getEnabled() || minecraft.field_1687 == null || minecraft.field_1690.field_1842 || minecraft.method_53526().method_53536()) {
            return;
        }
        this._radar.render(guiGraphics, deltaTracker);
        if (this._config.getSpeedometerEnabled()) {
            this._speedometer.render(guiGraphics, this._radar.getRadarDisplayX(), this._radar.getRadarDisplayY(), this._radar.getRadarRadius());
        }
    }

    public boolean processChat(class_2561 message) {
        String messageText;
        if (!this._config.getLogPlayerStatus() || message == null) {
            return false;
        }
        class_5251 color1 = message.method_10866().method_10973();
        List siblings = message.method_10855();
        class_5251 color2 = !siblings.isEmpty() ? ((class_2561)siblings.getFirst()).method_10866().method_10973() : null;
        class_5251 yellow = class_5251.method_27718((class_124)class_124.field_1054);
        if ((yellow.equals((Object)color1) || yellow.equals((Object)color2)) && !(messageText = message.getString()).contains("[CR]")) {
            return messageText.contains(" joined the game") || messageText.contains(" left the game");
        }
        return false;
    }

    private boolean isJourneyMapEnabled() {
        try {
            Class.forName("journeymap.common.Journeymap");
        }
        catch (ClassNotFoundException ex) {
            this._logger.info("[CombatRadar]: JourneyMap not found");
            return false;
        }
        this._logger.info("[CombatRadar]: JourneyMap found");
        return true;
    }

    private boolean isVoxelMapEnabled() {
        try {
            Class.forName("com.mamiyaotaru.voxelmap.VoxelMap");
        }
        catch (ClassNotFoundException ex) {
            this._logger.info("[CombatRadar]: VoxelMap not found");
            return false;
        }
        this._logger.info("[CombatRadar]: VoxelMap found");
        return true;
    }

    private boolean isXaerosEnabled() {
        try {
            Class.forName("xaero.minimap.XaeroMinimap");
        }
        catch (ClassNotFoundException ex) {
            this._logger.info("[CombatRadar]: Xaero's Minimap not found");
            return false;
        }
        this._logger.info("[CombatRadar]: Xaero's Minimap found");
        return true;
    }

    public RadarConfig getConfig() {
        return this._config;
    }

    public Speedometer getSpeedometer() {
        return this._speedometer;
    }
}

