/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar;

import com.aleksey.combatradar.ModHelper;
import com.aleksey.combatradar.SoundHelper;
import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.PlayerTypeInfo;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.entities.CustomRadarEntity;
import com.aleksey.combatradar.entities.EntitySettings;
import com.aleksey.combatradar.entities.ItemRadarEntity;
import com.aleksey.combatradar.entities.LiveRadarEntity;
import com.aleksey.combatradar.entities.PlayerRadarEntity;
import com.aleksey.combatradar.entities.RadarEntity;
import com.aleksey.combatradar.gui.CircleBorderElementRenderState;
import com.aleksey.combatradar.gui.CircleElementRenderState;
import com.aleksey.combatradar.gui.LineElementRenderState;
import com.aleksey.combatradar.gui.TriangleElementRenderState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1041;
import net.minecraft.class_11244;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7264;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Radar {
    private static final Pattern MinecraftSpecialCodes = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Logger log = LoggerFactory.getLogger(Radar.class);
    private static RadarConfig _config;
    private final List<RadarEntity> _entities = new ArrayList<RadarEntity>();
    private final HashMap<UUID, MessageInfo> _messages = new HashMap();
    private final List<PlayerSoundInfo> _sounds = new ArrayList<PlayerSoundInfo>();
    private int _radarRadius;
    private float _radarScale;
    private int _radarDisplayX;
    private int _radarDisplayY;
    private Map<UUID, PlayerInfo> _radarPlayers;
    private Map<UUID, String> _onlinePlayers;
    private static Radar instance;

    public Radar(RadarConfig config) {
        if (instance != null) {
            throw new IllegalStateException("Radar instance has already been initialized");
        }
        instance = this;
        _config = config;
    }

    @NotNull
    public static Radar getInstance() {
        return Objects.requireNonNull(instance);
    }

    @NotNull
    public static RadarConfig getConfig() {
        return Objects.requireNonNull(_config);
    }

    private static class_2561 getJourneyMapCoord(PlayerInfo playerInfo) {
        class_5250 hover = class_2561.method_43470((String)"Click to add/edit waypoint.").method_27692(class_124.field_1068);
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)hover);
        class_2558.class_10609 clickEvent = new class_2558.class_10609("/jm waypoint create " + playerInfo.playerName + " " + String.valueOf(class_310.method_1551().field_1724.method_73183().method_27983().method_29177()) + " " + (int)playerInfo.posX + " " + String.valueOf(_config.getShowYLevel() ? Integer.valueOf((int)playerInfo.posY) : "~") + " " + (int)playerInfo.posZ + " aqua " + class_310.method_1551().field_1724.method_5477().getString() + " false");
        class_2583 coordStyle = class_2583.field_24360.method_10958((class_2558)clickEvent).method_10949((class_2568)hoverEvent).method_10977(class_124.field_1075);
        return class_2561.method_43470((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).method_10862(coordStyle);
    }

    private static class_2561 getVoxelMapCoord(PlayerInfo playerInfo) {
        class_5250 hover = class_2561.method_43470((String)"Click to add/edit waypoint.").method_27692(class_124.field_1068);
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)hover);
        class_2558.class_10609 clickEvent = new class_2558.class_10609("/newWaypoint name:" + playerInfo.playerName + ", x:" + (int)playerInfo.posX + ", y:" + (int)(_config.getShowYLevel() ? playerInfo.posY : class_310.method_1551().field_1724.method_23318()) + ", z:" + (int)playerInfo.posZ + ", dim:" + String.valueOf(class_310.method_1551().field_1724.method_73183().method_27983().method_29177()));
        class_2583 coordStyle = class_2583.field_24360.method_10958((class_2558)clickEvent).method_10949((class_2568)hoverEvent).method_10977(class_124.field_1075);
        return class_2561.method_43470((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).method_10862(coordStyle);
    }

    private static class_2561 getXaerosCoord(PlayerInfo playerInfo) {
        class_5250 hover = class_2561.method_43470((String)"Click to add/edit waypoint.").method_27692(class_124.field_1068);
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)hover);
        class_2558.class_10609 clickEvent = new class_2558.class_10609("/xaero_waypoint_add:" + playerInfo.playerName + ":" + playerInfo.playerName.substring(0, 2) + ":" + (int)playerInfo.posX + ":" + String.valueOf(_config.getShowYLevel() ? Integer.valueOf((int)playerInfo.posY) : "~") + ":" + (int)playerInfo.posZ + ":0:false:0");
        class_2583 coordStyle = class_2583.field_24360.method_10958((class_2558)clickEvent).method_10949((class_2568)hoverEvent).method_10977(class_124.field_1075);
        return class_2561.method_43470((String)Radar.getChatCoordText(playerInfo, false, true, _config.getShowYLevel())).method_10862(coordStyle);
    }

    private static String getChatCoordText(PlayerInfo playerInfo, boolean includeName, boolean includeBrackets, boolean includeY) {
        StringBuilder coordText = new StringBuilder();
        if (includeBrackets) {
            coordText.append("[");
        }
        if (_config.getIsJourneyMapEnabled() || _config.getIsVoxelMapEnabled()) {
            coordText.append("\u00a7'x:");
        } else {
            coordText.append("x:");
        }
        coordText.append((int)playerInfo.posX);
        if (includeY) {
            coordText.append(", y:");
            coordText.append((int)playerInfo.posY);
        }
        coordText.append(", z:");
        coordText.append((int)playerInfo.posZ);
        if (includeName) {
            coordText.append(", name:");
            coordText.append(playerInfo.playerName);
        }
        if (includeBrackets) {
            coordText.append("]");
        }
        return coordText.toString();
    }

    public int getRadarRadius() {
        return this._radarRadius;
    }

    public int getRadarDisplayX() {
        return this._radarDisplayX;
    }

    public int getRadarDisplayY() {
        return this._radarDisplayY;
    }

    private static float getPartialX(class_1297 entity, float partialTicks) {
        return Radar.getPartial((float)entity.field_6038, (float)entity.method_23317(), partialTicks);
    }

    private static float getPartialZ(class_1297 entity, float partialTicks) {
        return Radar.getPartial((float)entity.field_5989, (float)entity.method_23321(), partialTicks);
    }

    private static float getPartial(float oldValue, float newValue, float partialTicks) {
        return oldValue + (newValue - oldValue) * partialTicks;
    }

    public void calcSettings() {
        class_1041 window = class_310.method_1551().method_22683();
        int radarDiameter = (int)((float)(window.method_4502() - 2) * _config.getRadarSize());
        this._radarRadius = radarDiameter / 2;
        int windowInnerWidth = window.method_4486() - radarDiameter;
        int windowInnerHeight = window.method_4502() - radarDiameter;
        this._radarDisplayX = this._radarRadius + 1 + (int)(_config.getRadarX() * (float)(windowInnerWidth - 2));
        this._radarDisplayY = this._radarRadius + 1 + (int)(_config.getRadarY() * (float)(windowInnerHeight - 2));
        this._radarScale = (float)this._radarRadius / (float)_config.getRadarDistance();
    }

    public void render(class_332 guiGraphics, class_9779 partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        if (this._radarRadius == 0) {
            return;
        }
        float rotationYaw = class_310.method_1551().field_1724.method_5705(partialTicks.method_60638());
        poseStack.pushMatrix();
        poseStack.translate((float)this._radarDisplayX, (float)this._radarDisplayY);
        poseStack.rotate(org.joml.Math.toRadians((float)(-rotationYaw)));
        this.renderCircleBg(guiGraphics, this._radarRadius);
        this.renderCircleBorder(guiGraphics, this._radarRadius);
        this.renderLines(guiGraphics, this._radarRadius);
        this.renderNonPlayerEntities(guiGraphics, partialTicks.method_60638());
        poseStack.rotate(org.joml.Math.toRadians((float)rotationYaw));
        this.renderTriangle(guiGraphics);
        poseStack.rotate(org.joml.Math.toRadians((float)(-rotationYaw)));
        this.renderPlayerEntities(guiGraphics, partialTicks.method_60638());
        poseStack.popMatrix();
    }

    private void renderNonPlayerEntities(class_332 guiGraphics, float partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        class_746 player = class_310.method_1551().field_1724;
        poseStack.pushMatrix();
        poseStack.scale(this._radarScale, this._radarScale);
        int i = 0;
        for (RadarEntity radarEntity : this._entities) {
            if (radarEntity instanceof PlayerRadarEntity) continue;
            this.renderEntity(guiGraphics, partialTicks, (class_1657)player, radarEntity);
            if (!(radarEntity instanceof ItemRadarEntity) || ++i <= 10000) continue;
            return;
        }
        poseStack.popMatrix();
    }

    private void renderPlayerEntities(class_332 guiGraphics, float partialTicks) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        class_746 player = class_310.method_1551().field_1724;
        poseStack.pushMatrix();
        poseStack.scale(this._radarScale, this._radarScale);
        for (RadarEntity radarEntity : this._entities) {
            if (!(radarEntity instanceof PlayerRadarEntity)) continue;
            this.renderEntity(guiGraphics, partialTicks, (class_1657)player, radarEntity);
        }
        poseStack.popMatrix();
    }

    private void renderEntity(class_332 guiGraphics, float partialTicks, class_1657 player, RadarEntity radarEntity) {
        float displayX = Radar.getPartialX((class_1297)player, partialTicks) - Radar.getPartialX(radarEntity.getEntity(), partialTicks);
        float displayZ = Radar.getPartialZ((class_1297)player, partialTicks) - Radar.getPartialZ(radarEntity.getEntity(), partialTicks);
        double distance = class_3532.method_61344((float)displayX, (float)displayZ);
        double scale = 1.0;
        if (distance > 0.1 && _config.getLogScaleEnabled()) {
            scale = 1.0 / distance * (Math.log1p(distance) / Math.log1p(_config.getRadarDistance())) * (double)_config.getRadarDistance();
        }
        radarEntity.render(guiGraphics, partialTicks, (float)((double)displayX * scale), (float)((double)displayZ * scale), Math.pow(distance, 2.0));
    }

    private void renderTriangle(class_332 graphics) {
        graphics.method_51448().rotate(org.joml.Math.toRadians((float)180.0f));
        GL11.glEnable((int)2881);
        this.renderTriangle(graphics, -16777216, 0.0f);
        this.renderTriangle(graphics, -1, 0.5f);
        GL11.glDisable((int)2881);
        graphics.method_51448().rotate(org.joml.Math.toRadians((float)-180.0f));
    }

    private void renderTriangle(class_332 graphics, int color, float offset) {
        graphics.field_59826.method_70919((class_11244)new TriangleElementRenderState(ModHelper.TRIANGLES, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), offset, color));
    }

    private void renderLines(class_332 graphics, float radius) {
        GL11.glEnable((int)2881);
        int color = class_9848.method_61318((float)Math.clamp(_config.getRadarOpacity() + 0.5f, 0.0f, 1.0f), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.field_59826.method_70919((class_11244)new LineElementRenderState(ModHelper.LINES, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), radius, color));
        GL11.glDisable((int)2881);
    }

    private void renderCircleBg(class_332 graphics, float radius) {
        int color = class_9848.method_61318((float)_config.getRadarOpacity(), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.field_59826.method_70919((class_11244)new CircleElementRenderState(ModHelper.CIRCLE, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), radius, color));
    }

    private void renderCircleBorder(class_332 graphics, float radius) {
        GL11.glEnable((int)2881);
        int color = class_9848.method_61318((float)Math.clamp(_config.getRadarOpacity() + 0.5f, 0.0f, 1.0f), (float)((float)_config.getRadarColor().getRed() / 255.0f), (float)((float)_config.getRadarColor().getGreen() / 255.0f), (float)((float)_config.getRadarColor().getBlue() / 255.0f));
        graphics.field_59826.method_70919((class_11244)new CircleBorderElementRenderState(ModHelper.BORDER, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), radius, color));
        GL11.glDisable((int)2881);
    }

    public void scanEntities() {
        this._entities.clear();
        this._sounds.clear();
        this._messages.clear();
        this.scanRadarEntities();
        if (_config.getLogPlayerStatus()) {
            this.scanOnlinePlayers();
        }
    }

    private void scanRadarEntities() {
        class_310 minecraft = class_310.method_1551();
        Map<UUID, PlayerInfo> oldPlayers = this._radarPlayers;
        this._radarPlayers = new HashMap<UUID, PlayerInfo>();
        EntitySettings settings = this.createEntitySettings();
        Iterable entities = minecraft.field_1687.method_18112();
        for (class_1297 entity : entities) {
            class_2960 icon;
            if (entity == minecraft.field_1724 || (icon = _config.getEnabledIcon(entity)) == null) continue;
            this.addEntity(entity, settings, oldPlayers, icon);
        }
        if (oldPlayers != null) {
            for (UUID playerKey : oldPlayers.keySet()) {
                PlayerInfo playerInfo = oldPlayers.get(playerKey);
                PlayerType playerType = _config.getPlayerType(playerInfo.playerName);
                PlayerTypeInfo playerTypeInfo = _config.getPlayerTypeInfo(playerType);
                if (!playerTypeInfo.ping && !_config.getLogPlayerStatus()) continue;
                this._messages.put(playerKey, new MessageInfo(playerInfo, MessageReason.Disappeared, playerTypeInfo.ping));
            }
        }
    }

    private void addEntity(class_1297 entity, EntitySettings settings, Map<UUID, PlayerInfo> oldPlayers, class_2960 icon) {
        RadarEntity radarEntity;
        if (entity instanceof class_1303) {
            radarEntity = new CustomRadarEntity(entity, settings, icon);
        } else if (entity instanceof class_1542) {
            radarEntity = new ItemRadarEntity(entity, settings);
        } else if (entity instanceof class_745) {
            PlayerType playerType = _config.getPlayerType(entity.method_5820());
            radarEntity = new PlayerRadarEntity(entity, settings, playerType);
            UUID playerKey = entity.method_5667();
            PlayerInfo playerInfo = new PlayerInfo((class_742)((class_745)entity));
            this._radarPlayers.put(playerKey, playerInfo);
            if (oldPlayers == null || !oldPlayers.containsKey(playerKey)) {
                PlayerTypeInfo playerTypeInfo = _config.getPlayerTypeInfo(playerType);
                if (playerTypeInfo.ping) {
                    this._sounds.add(new PlayerSoundInfo(playerTypeInfo.soundEventName, playerKey));
                }
                if (playerTypeInfo.ping || _config.getLogPlayerStatus()) {
                    this._messages.put(playerKey, new MessageInfo(playerInfo, MessageReason.Appeared, playerTypeInfo.ping));
                }
            } else {
                oldPlayers.remove(playerKey);
            }
        } else {
            radarEntity = entity instanceof class_7264 ? new ItemRadarEntity(entity, settings, new class_1799((class_1935)class_1802.field_38216)) : (entity instanceof class_1690 ? new ItemRadarEntity(entity, settings, new class_1799((class_1935)class_1802.field_8533)) : (entity instanceof class_1688 ? new ItemRadarEntity(entity, settings, new class_1799((class_1935)class_1802.field_8045)) : new LiveRadarEntity(entity, settings, icon)));
        }
        this._entities.add(radarEntity);
    }

    private EntitySettings createEntitySettings() {
        EntitySettings settings = new EntitySettings();
        settings.radarDistanceSq = _config.getRadarDistance() * _config.getRadarDistance();
        settings.iconScale = _config.getIconScale();
        settings.iconOpacity = 1.0f;
        settings.radarScale = this._radarScale;
        settings.fontScale = _config.getFontScale();
        settings.neutralPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Neutral).color;
        settings.allyPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Ally).color;
        settings.enemyPlayerColor = Radar._config.getPlayerTypeInfo((PlayerType)PlayerType.Enemy).color;
        settings.showPlayerNames = _config.getShowPlayerNames();
        settings.showExtraPlayerInfo = _config.getShowExtraPlayerInfo();
        settings.showYLevel = _config.getShowYLevel();
        return settings;
    }

    private void scanOnlinePlayers() {
        class_310 minecraft = class_310.method_1551();
        Collection players = minecraft.method_1562().method_2880();
        Map<UUID, String> oldOnlinePlayers = this._onlinePlayers;
        UUID currentPlayerId = minecraft.field_1724.method_5667();
        this._onlinePlayers = new HashMap<UUID, String>();
        for (class_640 p : players) {
            String playerName;
            String playerNameTrimmed;
            GameProfile profile = p.method_2966();
            UUID playerKey = profile.id();
            if (playerKey.equals(currentPlayerId) || _config.isPlayerExcluded(playerNameTrimmed = MinecraftSpecialCodes.matcher(playerName = profile.name()).replaceAll(""))) continue;
            this._onlinePlayers.put(playerKey, playerName);
            if (oldOnlinePlayers == null || !oldOnlinePlayers.containsKey(playerKey)) {
                MessageInfo message = this._messages.get(playerKey);
                if (message != null) {
                    message.reason = MessageReason.Login;
                    message.log = true;
                    continue;
                }
                this._messages.put(playerKey, new MessageInfo(playerName, MessageReason.Login));
                continue;
            }
            oldOnlinePlayers.remove(playerKey);
        }
        if (oldOnlinePlayers != null) {
            for (UUID playerKey : oldOnlinePlayers.keySet()) {
                MessageInfo message = this._messages.get(playerKey);
                if (message != null) {
                    message.reason = MessageReason.Logout;
                    message.log = true;
                    continue;
                }
                this._messages.put(playerKey, new MessageInfo(oldOnlinePlayers.get(playerKey), MessageReason.Logout));
            }
        }
    }

    public void playSounds() {
        for (PlayerSoundInfo sound : this._sounds) {
            SoundHelper.playSound(sound.soundEventName, sound.playerKey);
        }
    }

    public void sendMessages() {
        class_310 minecraft = class_310.method_1551();
        for (MessageInfo message : this._messages.values()) {
            if (!message.log) continue;
            this.sendMessage(minecraft, message);
        }
    }

    private void sendMessage(class_310 minecraft, MessageInfo messageInfo) {
        class_124 actionColor;
        String actionText;
        class_5250 text = class_2561.method_43470((String)"[CR] ").method_27692(class_124.field_1062);
        PlayerType playerType = _config.getPlayerType(messageInfo.playerName);
        class_124 playerColor = switch (playerType) {
            case PlayerType.Ally -> class_124.field_1060;
            case PlayerType.Enemy -> class_124.field_1079;
            default -> class_124.field_1068;
        };
        text = text.method_10852((class_2561)class_2561.method_43470((String)messageInfo.playerName).method_27692(playerColor));
        switch (messageInfo.reason.ordinal()) {
            case 0: {
                actionText = " joined the game";
                actionColor = messageInfo.playerInfo != null ? class_124.field_1054 : class_124.field_1077;
                break;
            }
            case 1: {
                actionText = " left the game";
                actionColor = class_124.field_1077;
                break;
            }
            case 2: {
                actionText = " appeared on radar";
                actionColor = class_124.field_1054;
                break;
            }
            case 3: {
                actionText = " disappeared from radar";
                actionColor = class_124.field_1054;
                break;
            }
            default: {
                return;
            }
        }
        text = text.method_10852((class_2561)class_2561.method_43470((String)actionText).method_27692(actionColor));
        if (messageInfo.playerInfo != null) {
            if (_config.getIsJourneyMapEnabled()) {
                class_2561 coordText = Radar.getJourneyMapCoord(messageInfo.playerInfo);
                text = text.method_10852((class_2561)class_2561.method_43470((String)" at ").method_27692(actionColor)).method_10852(coordText);
            } else if (_config.getIsVoxelMapEnabled()) {
                class_2561 coordText = Radar.getVoxelMapCoord(messageInfo.playerInfo);
                text = text.method_10852((class_2561)class_2561.method_43470((String)" at ").method_27692(actionColor)).method_10852(coordText);
            } else if (_config.getIsXaerosEnabled()) {
                class_2561 coordText = Radar.getXaerosCoord(messageInfo.playerInfo);
                text = text.method_10852((class_2561)class_2561.method_43470((String)" at ").method_27692(actionColor)).method_10852(coordText);
            } else {
                class_5250 coordText = class_2561.method_43470((String)Radar.getChatCoordText(messageInfo.playerInfo, false, true, _config.getShowYLevel())).method_27692(actionColor);
                text = text.method_10852((class_2561)class_2561.method_43470((String)" at ").method_27692(actionColor)).method_10852((class_2561)coordText);
            }
        }
        minecraft.field_1724.method_7353((class_2561)text, false);
    }

    private static class PlayerInfo {
        public String playerName;
        public double posX;
        public double posY;
        public double posZ;

        public PlayerInfo(class_742 player) {
            this.playerName = player.method_5820();
            this.posX = player.method_23317();
            this.posY = player.method_23318();
            this.posZ = player.method_23321();
        }
    }

    private static class MessageInfo {
        public String playerName;
        public PlayerInfo playerInfo;
        public MessageReason reason;
        public boolean log;

        public MessageInfo(String playerName, MessageReason reason) {
            this.playerName = playerName;
            this.playerInfo = null;
            this.reason = reason;
            this.log = true;
        }

        public MessageInfo(PlayerInfo playerInfo, MessageReason reason, boolean log) {
            this.playerName = playerInfo.playerName;
            this.playerInfo = playerInfo;
            this.reason = reason;
            this.log = log;
        }
    }

    private static enum MessageReason {
        Login,
        Logout,
        Appeared,
        Disappeared;

    }

    private static class PlayerSoundInfo {
        public String soundEventName;
        public UUID playerKey;

        public PlayerSoundInfo(String soundEventName, UUID playerKey) {
            this.soundEventName = soundEventName;
            this.playerKey = playerKey;
        }
    }
}

