/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.joml.Matrix3x2fStack;

public class Speedometer {
    private static final int _maxCount = 5;
    private static final double _maxSpeed = 100.0;
    private final ArrayList<Double> _speedList = new ArrayList(5);
    private long _prevTime;
    private double _prevX;
    private double _prevZ;
    private String _speedText;

    public void calc() {
        if (this._speedList.size() == 5) {
            this._speedList.remove(0);
        }
        double currentSpeed = this.calcCurrentSpeed();
        this._speedList.add(currentSpeed);
        double sum = 0.0;
        for (double speed : this._speedList) {
            sum += speed;
        }
        double avgSpeed = (double)Math.round(10.0 * sum / (double)this._speedList.size()) / 10.0;
        this._speedText = String.format("%.1f m/s", avgSpeed);
    }

    public void clearSpeed() {
        this._speedList.clear();
        this._speedText = "0.0 m/s";
        this._prevTime = 0L;
    }

    private double calcCurrentSpeed() {
        double speed;
        class_746 player = class_310.method_1551().field_1724;
        long time = System.nanoTime();
        double x = player.method_23317();
        double z = player.method_23321();
        if (this._prevTime != 0L) {
            double timeDelta = time - this._prevTime;
            double xDelta = x - this._prevX;
            double zDelta = z - this._prevZ;
            double distance = Math.sqrt(Math.pow(xDelta, 2.0) + Math.pow(zDelta, 2.0));
            speed = 1.0E9 * distance / timeDelta;
            if (speed > 100.0) {
                speed = 0.0;
            }
        } else {
            speed = 0.0;
        }
        this._prevTime = time;
        this._prevX = x;
        this._prevZ = z;
        return speed;
    }

    public void render(class_332 guiGraphics, int radarDisplayX, int radarDisplayY, int radarRadius) {
        float f;
        int yMargin = 2;
        class_310 minecraft = class_310.method_1551();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        class_327 font = minecraft.field_1772;
        int windowHeight = minecraft.method_22683().method_4502();
        float xOffset = (float)(-font.method_1727(this._speedText)) / 2.0f;
        Objects.requireNonNull(font);
        if (radarDisplayY + radarRadius + 9 + 2 > windowHeight) {
            int n = -radarRadius;
            Objects.requireNonNull(font);
            f = n - 9 - 2;
        } else {
            f = radarRadius + 2;
        }
        float yOffset = f;
        poseStack.pushMatrix();
        poseStack.translate((float)radarDisplayX, (float)radarDisplayY);
        guiGraphics.method_25303(font, this._speedText, (int)xOffset, (int)yOffset, Color.WHITE.getRGB());
        poseStack.popMatrix();
    }
}

