/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.config;

import com.aleksey.combatradar.config.GroupType;
import com.aleksey.combatradar.config.PlayerRadarEntityInfo;
import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.PlayerTypeInfo;
import com.aleksey.combatradar.config.RadarConfigLoader;
import com.aleksey.combatradar.config.RadarEntityInfo;
import com.aleksey.combatradar.config.RadarHorseInfo;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10275;
import net.minecraft.class_10730;
import net.minecraft.class_11187;
import net.minecraft.class_11573;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1431;
import net.minecraft.class_1433;
import net.minecraft.class_1438;
import net.minecraft.class_1439;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1454;
import net.minecraft.class_1456;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1474;
import net.minecraft.class_1477;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1495;
import net.minecraft.class_1500;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1550;
import net.minecraft.class_1551;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1576;
import net.minecraft.class_1577;
import net.minecraft.class_1581;
import net.minecraft.class_1584;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1604;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1614;
import net.minecraft.class_1621;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1639;
import net.minecraft.class_1640;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3701;
import net.minecraft.class_3986;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4836;
import net.minecraft.class_4985;
import net.minecraft.class_5136;
import net.minecraft.class_5419;
import net.minecraft.class_5762;
import net.minecraft.class_5776;
import net.minecraft.class_6053;
import net.minecraft.class_7102;
import net.minecraft.class_7110;
import net.minecraft.class_7260;
import net.minecraft.class_7264;
import net.minecraft.class_7298;
import net.minecraft.class_7689;
import net.minecraft.class_8153;
import net.minecraft.class_8949;
import net.minecraft.class_9069;
import net.minecraft.class_9254;

public class RadarConfig {
    private final File _configFile;
    private final class_304 _settingsKey;
    private final List<RadarEntityInfo> _entityList;
    private final Map<String, RadarEntityInfo> _entityMap;
    private final Map<GroupType, Boolean> _groups;
    private final Map<String, PlayerInfo> _players;
    private final Map<PlayerType, PlayerTypeInfo> _playerTypes;
    private boolean _enabled = true;
    private boolean _pingsEnabled = true;
    private boolean _speedometerEnabled = false;
    private float _radarOpacity = 0.5f;
    private Color _radarColor = new Color(128, 128, 128);
    private float _radarSize = 0.4f;
    private int _radarDistance = 128;
    private float _radarX = 0.0f;
    private float _radarY = 0.0f;
    private float _iconScale = 0.8869566f;
    private float _fontScale = 1.4f;
    private boolean _showPlayerNames = true;
    private boolean _showExtraPlayerInfo = true;
    private boolean _logPlayerStatus = true;
    private boolean _showYLevel = false;
    private boolean _useLogScale = false;
    private List<String> _playersExcludedFromLog;
    private boolean _isJourneyMapEnabled;
    private boolean _isVoxelMapEnabled;
    private boolean _isXaerosEnabled;

    public RadarConfig(File file, class_304 settingsKey) {
        this._configFile = file;
        this._settingsKey = settingsKey;
        this._entityList = new ArrayList<RadarEntityInfo>();
        this._entityList.add(new RadarEntityInfo(class_1420.class, "Bat", "icons/bat.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1428.class, "Chicken", "icons/chicken.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_10730.class, "Cow", "icons/cow/cow.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarHorseInfo("Horse", "icons/horse/horse_chestnut.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1500.class, "Mule", "icons/horse/mule.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1495.class, "Donkey", "icons/horse/donkey.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1501.class, "Llama", "icons/llama/llama.png", GroupType.NEUTRAL).addEntity(class_3986.class, "icons/llama/llama_trader.png"));
        this._entityList.add(new RadarEntityInfo(class_1438.class, "Mooshroom", "icons/cow/mooshroom.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_3701.class, "Ocelot", "icons/cat/ocelot.png", GroupType.NEUTRAL).addEntity(class_1451.class, "icons/cat/black.png"));
        this._entityList.add(new RadarEntityInfo(class_1452.class, "Pig", "icons/pig/pig.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1463.class, "Rabbit", "icons/rabbit/white.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1472.class, "Sheep", "icons/sheep/sheep.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1477.class, "Squid", "icons/squid.png", GroupType.NEUTRAL).addEntity(class_5776.class, "icons/squid_glow.png"));
        this._entityList.add(new RadarEntityInfo(class_1646.class, "Villager", "icons/villager/villager.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1493.class, "Wolf", "icons/wolf/wolf.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1545.class, "Blaze", "icons/blaze.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1549.class, "Cave Spider", "icons/spider/cave_spider.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1548.class, "Creeper", "icons/creeper.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1560.class, "Enderman", "icons/enderman/enderman.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1571.class, "Ghast", "icons/ghast/ghast.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1577.class, "Guardian", "icons/guardian.png", GroupType.AGGRESSIVE).addEntity(class_1550.class, "icons/elder_guardian.png"));
        this._entityList.add(new RadarEntityInfo(class_1439.class, "Iron Golem", "icons/iron_golem.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1589.class, "Magma Cube", "icons/slime/magmacube.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1614.class, "Silverfish", "icons/silverfish.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1613.class, "Skeleton", "icons/skeleton/skeleton.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1621.class, "Slime", "icons/slime/slime.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1473.class, "Snow Golem", "icons/snowman.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1628.class, "Spider", "icons/spider/spider.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1640.class, "Witch", "icons/witch.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1642.class, "Zombie", "icons/zombie/zombie.png", GroupType.AGGRESSIVE).addEntity(class_1551.class, "icons/zombie/drowned.png").addEntity(class_1576.class, "icons/zombie/husk.png"));
        this._entityList.add(new RadarEntityInfo(class_1542.class, "Item", "icons/item.png", GroupType.OTHER));
        this._entityList.add(new RadarEntityInfo(class_1690.class, "Boat", "icons/boat.png", GroupType.OTHER));
        this._entityList.add(new RadarEntityInfo(class_1688.class, "Minecart", "icons/minecart.png", GroupType.OTHER));
        this._entityList.add(new PlayerRadarEntityInfo(PlayerType.Neutral, "Player (Neutral)", "icons/player.png", GroupType.OTHER));
        this._entityList.add(new PlayerRadarEntityInfo(PlayerType.Ally, "Player (Ally)", "icons/player.png", GroupType.OTHER));
        this._entityList.add(new PlayerRadarEntityInfo(PlayerType.Enemy, "Player (Enemy)", "icons/player.png", GroupType.OTHER));
        this._entityList.add(new RadarEntityInfo(class_1456.class, "Polar Bear", "icons/bear/polarbear.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1606.class, "Shulker", "icons/shulker/shulker.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1627.class, "Stray", "icons/skeleton/stray.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1303.class, "XP Orb", "icons/xp_orb.png", GroupType.OTHER));
        this._entityList.add(new RadarEntityInfo(class_1528.class, "Wither", "icons/wither/wither.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1639.class, "Wither Skeleton", "icons/skeleton/wither_skeleton.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1453.class, "Parrot", "icons/parrot/parrot.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1564.class, "Illager", "icons/illager/evoker.png", GroupType.AGGRESSIVE).addEntity(class_1581.class, "icons/illager/illusioner.png").addEntity(class_1634.class, "icons/illager/vex.png").addEntity(class_1632.class, "icons/illager/vindicator.png").addEntity(class_1604.class, "icons/illager/pillager.png").addEntity(class_1584.class, "icons/illager/ravager.png"));
        this._entityList.add(new RadarEntityInfo(class_5762.class, "Axolotl", "icons/axolotl.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1462.class, "Fish", "icons/salmon.png", GroupType.NEUTRAL).addEntity(class_1431.class, "icons/cod.png").addEntity(class_1454.class, "icons/pufferfish.png").addEntity(class_1474.class, "icons/tropical_fish.png"));
        this._entityList.add(new RadarEntityInfo(class_4019.class, "Fox", "icons/fox.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_4985.class, "Strider", "icons/strider.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1481.class, "Turtle", "icons/turtle.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1481.class, "Trader", "icons/wandering_trader.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_4466.class, "Bee", "icons/bee.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1433.class, "Dolphin", "icons/dolphin.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_6053.class, "Goat", "icons/goat.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_1440.class, "Panda", "icons/panda.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_4836.class, "Piglin", "icons/piglin.png", GroupType.NEUTRAL).addEntity(class_1590.class, "icons/zombie_pigman.png"));
        this._entityList.add(new RadarEntityInfo(class_1559.class, "Endermite", "icons/endermite.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1559.class, "Hoglin", "icons/hoglin.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1593.class, "Phantom", "icons/phantom.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_5419.class, "Piglin Brute", "icons/piglin_brute.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_5136.class, "Zoglin", "icons/zoglin.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1641.class, "Zombie Villager", "icons/zombie_villager.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_1510.class, "Ender Dragon", "icons/dragon.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_7298.class, "Allay", "icons/allay.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_7102.class, "Frog", "icons/frog.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_7110.class, "Tadpole", "icons/tadpole.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_7260.class, "Warden", "icons/warden.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_7264.class, "Boat With Chest", "icons/boat_chest.png", GroupType.OTHER));
        this._entityList.add(new RadarEntityInfo(class_7689.class, "Camel", "icons/camel.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_8153.class, "Sniffer", "icons/sniffer.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_9069.class, "Armadillo", "icons/armadillo.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_9254.class, "Bogged", "icons/bogged.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_8949.class, "Breeze", "icons/breeze.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_10275.class, "Creaking", "icons/creaking.png", GroupType.AGGRESSIVE));
        this._entityList.add(new RadarEntityInfo(class_11187.class, "Happy Ghast", "icons/ghast/happy_ghast.png", GroupType.NEUTRAL));
        this._entityList.add(new RadarEntityInfo(class_11573.class, "Copper Golem", "icons/copper_golem.png", GroupType.NEUTRAL));
        this._entityList.sort(new RadarEntityInfo.EntityComparator());
        this._entityMap = new HashMap<String, RadarEntityInfo>();
        for (RadarEntityInfo radarEntityInfo : this._entityList) {
            radarEntityInfo.addToMap(this._entityMap);
        }
        this._groups = new HashMap<GroupType, Boolean>();
        this._groups.put(GroupType.NEUTRAL, true);
        this._groups.put(GroupType.AGGRESSIVE, true);
        this._groups.put(GroupType.OTHER, true);
        this._players = new HashMap<String, PlayerInfo>();
        this._playerTypes = new HashMap<PlayerType, PlayerTypeInfo>();
        this._playerTypes.put(PlayerType.Neutral, new PlayerTypeInfo(Color.WHITE));
        this._playerTypes.put(PlayerType.Ally, new PlayerTypeInfo(Color.GREEN));
        this._playerTypes.put(PlayerType.Enemy, new PlayerTypeInfo(Color.YELLOW));
        this._playersExcludedFromLog = new ArrayList<String>();
        this._playersExcludedFromLog.add("~BTLP SLOT");
    }

    public class_304 getSettingsKey() {
        return this._settingsKey;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    public boolean getPingsEnabled() {
        return this._pingsEnabled;
    }

    public void setPingsEnabled(boolean value) {
        this._pingsEnabled = value;
    }

    public boolean getSpeedometerEnabled() {
        return this._speedometerEnabled;
    }

    public void setSpeedometerEnabled(boolean value) {
        this._speedometerEnabled = value;
    }

    public float getRadarOpacity() {
        return this._radarOpacity;
    }

    public boolean setRadarOpacity(float value) {
        if (this._radarOpacity == value) {
            return false;
        }
        this._radarOpacity = value;
        return true;
    }

    public Color getRadarColor() {
        return this._radarColor;
    }

    public boolean setRadarColor(Color value) {
        if (Objects.equals(this._radarColor, value)) {
            return false;
        }
        this._radarColor = value;
        return true;
    }

    public float getRadarSize() {
        return this._radarSize;
    }

    public boolean setRadarSize(float value) {
        if (this._radarSize == value) {
            return false;
        }
        this._radarSize = value;
        return true;
    }

    public int getRadarDistance() {
        return this._radarDistance;
    }

    public boolean setRadarDistance(int value) {
        if (this._radarDistance == value) {
            return false;
        }
        this._radarDistance = value;
        return true;
    }

    public float getRadarX() {
        return this._radarX;
    }

    public void setRadarX(float value) {
        this._radarX = value;
    }

    public float getRadarY() {
        return this._radarY;
    }

    public void setRadarY(float value) {
        this._radarY = value;
    }

    public float getIconScale() {
        return this._iconScale;
    }

    public boolean setIconScale(float value) {
        if (this._iconScale == value) {
            return false;
        }
        this._iconScale = value;
        return true;
    }

    public float getFontScale() {
        return this._fontScale;
    }

    public boolean setFontScale(float value) {
        if (this._fontScale == value) {
            return false;
        }
        this._fontScale = value;
        return true;
    }

    public PlayerTypeInfo getPlayerTypeInfo(PlayerType playerType) {
        return this._playerTypes.get((Object)playerType);
    }

    public boolean getShowPlayerNames() {
        return this._showPlayerNames;
    }

    public void setShowPlayerNames(boolean value) {
        this._showPlayerNames = value;
    }

    public boolean getShowExtraPlayerInfo() {
        return this._showExtraPlayerInfo;
    }

    public void setShowExtraPlayerInfo(boolean value) {
        this._showExtraPlayerInfo = value;
    }

    public boolean getLogPlayerStatus() {
        return this._logPlayerStatus;
    }

    public void setLogPlayerStatus(boolean value) {
        this._logPlayerStatus = value;
    }

    public boolean getShowYLevel() {
        return this._showYLevel;
    }

    public void setShowYLevel(boolean value) {
        this._showYLevel = value;
    }

    public List<RadarEntityInfo> getEntityList() {
        return this._entityList;
    }

    public RadarEntityInfo getEntity(String name) {
        for (RadarEntityInfo info : this._entityList) {
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public void setEntityEnabled(String name, boolean enabled) {
        this.getEntity(name).setEnabled(enabled);
    }

    public class_2960 getEnabledIcon(class_1297 entity) {
        Object entityClass;
        if (entity instanceof class_1542) {
            entityClass = class_1542.class.getCanonicalName();
        } else if (entity instanceof class_1690) {
            entityClass = class_1690.class.getCanonicalName();
        } else if (entity instanceof class_1688) {
            entityClass = class_1688.class.getCanonicalName();
        } else if (entity instanceof class_1657) {
            PlayerType playerType = this.getPlayerType(entity.method_5477().getString());
            entityClass = class_1657.class.getCanonicalName() + "." + String.valueOf((Object)playerType);
        } else {
            entityClass = entity.getClass().getCanonicalName();
        }
        RadarEntityInfo info = this._entityMap.getOrDefault(entityClass, null);
        return info != null && info.getEnabled() && this._groups.get((Object)info.getGroupType()) != false ? info.getIcon(entity) : null;
    }

    public boolean isGroupEnabled(GroupType groupType) {
        return this._groups.get((Object)groupType);
    }

    public void setGroupEnabled(GroupType groupType, boolean value) {
        this._groups.put(groupType, value);
    }

    public PlayerType getPlayerType(String playerName) {
        String key = playerName.toLowerCase();
        PlayerInfo info = this._players.get(key);
        return info != null ? info.type : PlayerType.Neutral;
    }

    public void revertNeutralAggressive() {
        boolean enabled = this._groups.get((Object)GroupType.NEUTRAL) != false || this._groups.get((Object)GroupType.AGGRESSIVE) != false;
        this._groups.put(GroupType.NEUTRAL, !enabled);
        this._groups.put(GroupType.AGGRESSIVE, !enabled);
    }

    public void setPlayerType(String playerName, PlayerType playerType) {
        String key = playerName.toLowerCase();
        if (playerType == PlayerType.Neutral) {
            this._players.remove(key);
            return;
        }
        PlayerInfo info = this._players.get(key);
        if (info == null) {
            this._players.put(key, new PlayerInfo(playerName, playerType));
        } else {
            info.type = playerType;
        }
    }

    public List<String> getPlayers(PlayerType playerType) {
        ArrayList<String> result = new ArrayList<String>();
        for (PlayerInfo info : this._players.values()) {
            if (info.type != playerType) continue;
            result.add(info.name);
        }
        Collections.sort(result);
        return result;
    }

    public boolean getIsJourneyMapEnabled() {
        return this._isJourneyMapEnabled;
    }

    public void setIsJourneyMapEnabled(boolean value) {
        this._isJourneyMapEnabled = value;
    }

    public boolean getIsVoxelMapEnabled() {
        return this._isVoxelMapEnabled;
    }

    public void setIsVoxelMapEnabled(boolean value) {
        this._isVoxelMapEnabled = value;
    }

    public boolean getIsXaerosEnabled() {
        return this._isXaerosEnabled;
    }

    public void setIsXaerosEnabled(boolean value) {
        this._isXaerosEnabled = value;
    }

    public List<String> getPlayersExcludedFromLog() {
        return this._playersExcludedFromLog;
    }

    public void setPlayersExcludedFromLog(List<String> value) {
        this._playersExcludedFromLog = value;
        this._playersExcludedFromLog.replaceAll(String::toUpperCase);
    }

    public boolean isPlayerExcluded(String playerName) {
        String upperPlayerName = playerName.toUpperCase();
        for (String p : this._playersExcludedFromLog) {
            if (!upperPlayerName.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public void save() {
        RadarConfigLoader.save(this, this._configFile);
    }

    public boolean load() {
        return RadarConfigLoader.load(this, this._configFile);
    }

    public void setLogScaleEnabled(boolean b) {
        this._useLogScale = b;
    }

    public boolean getLogScaleEnabled() {
        return this._useLogScale;
    }

    private static class PlayerInfo {
        public String name;
        public PlayerType type;

        public PlayerInfo(String name, PlayerType type) {
            this.name = name;
            this.type = type;
        }
    }
}

