/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.config;

import com.aleksey.combatradar.config.GroupType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2960;

public class RadarEntityInfo {
    private final Map<String, class_2960> _entities;
    private final class_2960 _defaultIcon;
    private final String _name;
    private final GroupType _groupType;
    private final String _entityClassName;
    private boolean _enabled;

    public RadarEntityInfo(Class<? extends class_1297> entityClass, String name, String iconPath, GroupType groupType) {
        this(entityClass.getCanonicalName(), name, iconPath, groupType);
    }

    protected RadarEntityInfo(String entityClass, String name, String iconPath, GroupType groupType) {
        this._name = name;
        this._groupType = groupType;
        this._enabled = true;
        this._entityClassName = entityClass;
        this._entities = new HashMap<String, class_2960>();
        this._defaultIcon = class_2960.method_60655((String)"combatradar", (String)iconPath);
        this._entities.put(entityClass, this._defaultIcon);
    }

    public String getName() {
        return this._name;
    }

    public GroupType getGroupType() {
        return this._groupType;
    }

    public String getEntityClassName() {
        return this._entityClassName;
    }

    public class_2960 getIcon(class_1297 entity) {
        if (entity == null || this._entities.size() == 1) {
            return this._defaultIcon;
        }
        String entityClassName = entity.getClass().getCanonicalName();
        return this._entities.get(entityClassName);
    }

    public class_2960 getIcon(String entity) {
        if (entity == null || this._entities.size() == 1) {
            return this._defaultIcon;
        }
        return this._entities.get(entity);
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    public RadarEntityInfo addEntity(Class<? extends class_1297> entityClass, String iconPath) {
        class_2960 icon = iconPath != null ? class_2960.method_60655((String)"combatradar", (String)iconPath) : null;
        this._entities.put(entityClass.getCanonicalName(), icon);
        return this;
    }

    public void addToMap(Map<String, RadarEntityInfo> map) {
        for (String entityClass : this._entities.keySet()) {
            map.put(entityClass, this);
        }
    }

    public static class EntityComparator
    implements Comparator<RadarEntityInfo> {
        @Override
        public int compare(RadarEntityInfo i1, RadarEntityInfo i2) {
            return i1._name.compareTo(i2._name);
        }
    }
}

