/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.entities;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.entities.EntitySettings;
import com.aleksey.combatradar.entities.RadarEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.Color;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_745;
import net.minecraft.class_9848;
import org.joml.Math;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class PlayerRadarEntity
extends RadarEntity {
    private final PlayerType _playerType;

    public PlayerRadarEntity(class_1297 entity, EntitySettings settings, PlayerType playerType) {
        super(entity, settings);
        this._playerType = playerType;
    }

    @Override
    protected void renderInternal(class_332 guiGraphics, float displayX, float displayY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        class_745 player = (class_745)this.getEntity();
        float rotationYaw = minecraft.field_1724.method_5705(partialTicks);
        float scale = this.getSettings().iconScale * 1.7f;
        poseStack.pushMatrix();
        poseStack.translate(displayX, displayY);
        poseStack.rotate(Math.toRadians((float)rotationYaw));
        poseStack.pushMatrix();
        poseStack.scale(scale, scale);
        this.renderPlayerIcon(guiGraphics, player);
        poseStack.popMatrix();
        if (this.getSettings().showPlayerNames) {
            this.renderPlayerName(guiGraphics, player);
        }
        poseStack.popMatrix();
    }

    private void renderPlayerIcon(class_332 guiGraphics, class_745 player) {
        class_2960 skin = player.method_52814().comp_1626().comp_3627();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)class_310.method_1551().method_1531().method_4619(skin).method_71659());
        guiGraphics.method_25293(class_10799.field_56883, skin, -4, -4, 8.0f, 8.0f, 8, 8, 8, 8, 64, 64, class_9848.method_61318((float)this.getSettings().iconOpacity, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    private void renderPlayerName(class_332 guiGraphics, class_745 player) {
        class_310 minecraft = class_310.method_1551();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        Color color = this._playerType == PlayerType.Ally ? this.getSettings().allyPlayerColor : (this._playerType == PlayerType.Enemy ? this.getSettings().enemyPlayerColor : this.getSettings().neutralPlayerColor);
        poseStack.scale(this.getSettings().fontScale, this.getSettings().fontScale, (Matrix3x2f)poseStack.pushMatrix());
        Object playerName = player.method_5820();
        if (this.getSettings().showExtraPlayerInfo && this.getSettings().showYLevel) {
            playerName = (String)playerName + " (" + (int)minecraft.field_1724.method_5739((class_1297)player) + "m)(Y" + player.method_31478() + ")";
        } else if (this.getSettings().showExtraPlayerInfo && !this.getSettings().showYLevel) {
            double dx = player.method_23317() - minecraft.field_1724.method_23317();
            double dz = player.method_23321() - minecraft.field_1724.method_23321();
            playerName = (String)playerName + " (" + (int)java.lang.Math.round(java.lang.Math.hypot(dx, dz)) + "m)";
        }
        class_327 font = minecraft.field_1772;
        int yOffset = -4 + (int)(this.getSettings().iconScale * this.getSettings().radarScale + 8.0f);
        int xOffset = -font.method_1727((String)playerName) / 2;
        guiGraphics.method_25303(font, (String)playerName, xOffset, yOffset, color.getRGB());
        poseStack.popMatrix();
    }
}

