/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.GroupType;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.config.RadarEntityInfo;
import com.aleksey.combatradar.gui.components.SmallButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.joml.Matrix3x2fStack;

public class EntityScreen
extends class_437 {
    private static final int MAX_ENTITIES_PER_COL = 8;
    private static final int ICON_WIDTH = 12;
    private static final int LINE_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 24;
    private static GroupType _activeGroupType = GroupType.NEUTRAL;
    private final RadarConfig _config;
    private final class_437 _parent;
    private class_4185 _enableButton;
    private Map<GroupType, EntityGroup> _groups;
    private int _titleTop;
    private int _buttonTop;
    private int _iconTop;
    private int _iconLeft;
    private EntityGroup _activeGroup;
    private String _groupName;
    private class_4185 _neutralButton;
    private class_4185 _aggressiveButton;
    private class_4185 _otherButton;
    private final ArrayList<class_4185> _iconButtons;

    public EntityScreen(class_437 parent, RadarConfig config) {
        super((class_2561)class_2561.method_43470((String)"Radar Entities"));
        this._parent = parent;
        this._config = config;
        this._iconButtons = new ArrayList();
    }

    protected void method_25426() {
        this._titleTop = this.field_22790 / 4 - 40;
        this._buttonTop = this.field_22790 - this.field_22790 / 4 - 10;
        this._iconTop = this._titleTop + 16 + (this.field_22790 - (this.field_22790 - this._buttonTop) - this._titleTop - 16 - 128) / 2;
        this.createEntityGroups();
        this.addFunctionalButtons();
        this.setActiveGroup(_activeGroupType);
    }

    private void addFunctionalButtons() {
        int y = this._buttonTop;
        int x = this.field_22789 / 2 - 100;
        this._neutralButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Neutral"), btn -> this.setActiveGroup(GroupType.NEUTRAL)).method_46434(x, y, 66, 20).method_46431();
        this.method_37063((class_364)this._neutralButton);
        this._aggressiveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Aggressive"), btn -> this.setActiveGroup(GroupType.AGGRESSIVE)).method_46434(x + 66 + 1, y, 66, 20).method_46431();
        this.method_37063((class_364)this._aggressiveButton);
        this._otherButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Other"), btn -> this.setActiveGroup(GroupType.OTHER)).method_46434(x + 66 + 1 + 66 + 1, y, 66, 20).method_46431();
        this.method_37063((class_364)this._otherButton);
        this._enableButton = class_4185.method_46430((class_2561)this.getEnableButtonText(), btn -> {
            this._config.setGroupEnabled(_activeGroupType, !this._config.isGroupEnabled(_activeGroupType));
            this._config.save();
            this._enableButton.method_25355(this.getEnableButtonText());
        }).method_46434(x, y += 24, 200, 20).method_46431();
        this.method_37063((class_364)this._enableButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.field_22787.method_1507(this._parent)).method_46434(x, y += 24, 200, 20).method_46431());
    }

    private void addIconButtons() {
        int colIndex = 0;
        int rowIndex = 0;
        int colX = this._iconLeft;
        int buttonX = colX + this._activeGroup.getIconAndTextWidth(colIndex);
        int buttonY = this._iconTop - 4;
        int buttonHeight = 15;
        for (class_4185 iconButton : this._iconButtons) {
            this.method_37066((class_364)iconButton);
        }
        this._iconButtons.clear();
        for (RadarEntityInfo info : this._activeGroup.entities) {
            if (rowIndex == 8) {
                rowIndex = 0;
                buttonX = (colX += this._activeGroup.getColWidth(colIndex)) + this._activeGroup.getIconAndTextWidth(++colIndex);
                buttonY = this._iconTop - 4;
            }
            String buttonText = info.getEnabled() ? "on" : "off";
            String name = info.getName();
            SmallButton iconButton = new SmallButton(buttonX, buttonY, 24, buttonHeight, (class_2561)class_2561.method_43470((String)buttonText), btn -> this.iconButtonClicked(btn, name));
            this.method_37063((class_364)iconButton);
            this._iconButtons.add(iconButton);
            buttonY += 16;
            ++rowIndex;
        }
    }

    private void iconButtonClicked(class_4185 btn, String name) {
        RadarEntityInfo info;
        info.setEnabled(!(info = this._config.getEntity(name)).getEnabled());
        this._config.save();
        String text = info.getEnabled() ? "on" : "off";
        btn.method_25355((class_2561)class_2561.method_43470((String)text));
    }

    private void createEntityGroups() {
        this._groups = new HashMap<GroupType, EntityGroup>();
        for (RadarEntityInfo info : this._config.getEntityList()) {
            EntityGroup group = this._groups.get((Object)info.getGroupType());
            if (group == null) {
                group = new EntityGroup(info.getGroupType());
                this._groups.put(info.getGroupType(), group);
            }
            int colIndex = group.entities.size() / 8;
            int textWidth = this.field_22793.method_1727(info.getName());
            if (group.listColTextWidth.size() <= colIndex) {
                group.listColTextWidth.add(textWidth);
            } else if (group.listColTextWidth.get(colIndex) < textWidth) {
                group.listColTextWidth.set(colIndex, textWidth);
            }
            group.entities.add(info);
        }
    }

    private void setActiveGroup(GroupType groupType) {
        _activeGroupType = groupType;
        this._activeGroup = this._groups.get((Object)groupType);
        this._iconLeft = (this.field_22789 - this._activeGroup.getTotalWidth() + 25) / 2;
        switch (groupType) {
            case NEUTRAL: {
                this._groupName = "Neutral";
                break;
            }
            case AGGRESSIVE: {
                this._groupName = "Aggressive";
                break;
            }
            case OTHER: {
                this._groupName = "Other";
            }
        }
        this.addIconButtons();
        this._neutralButton.field_22763 = groupType != GroupType.NEUTRAL;
        this._aggressiveButton.field_22763 = groupType != GroupType.AGGRESSIVE;
        this._otherButton.field_22763 = groupType != GroupType.OTHER;
        this._enableButton.method_25355(this.getEnableButtonText());
    }

    private class_2561 getEnableButtonText() {
        String text = this._groupName + " Entities: " + (this._config.isGroupEnabled(_activeGroupType) ? "On" : "Off");
        return class_2561.method_43470((String)text);
    }

    public void method_25432() {
        this._config.save();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this._titleTop, Color.WHITE.getRGB());
        this.renderIcons(guiGraphics);
    }

    private void renderIcons(class_332 guiGraphics) {
        int colIndex = 0;
        int rowIndex = 0;
        int x = this._iconLeft;
        int y = this._iconTop;
        for (RadarEntityInfo info : this._activeGroup.entities) {
            if (rowIndex == 8) {
                x += this._activeGroup.getColWidth(colIndex);
                y = this._iconTop;
                ++colIndex;
                rowIndex = 0;
            }
            this.renderIcon(guiGraphics, x, y + 4, info);
            boolean isEnabled = info.getEnabled() && this._config.isGroupEnabled(_activeGroupType);
            Color color = isEnabled ? Color.WHITE : Color.DARK_GRAY;
            guiGraphics.method_51433(this.field_22793, info.getName(), x + 12, y, color.getRGB(), true);
            y += 16;
            ++rowIndex;
        }
    }

    private void renderIcon(class_332 guiGraphics, float x, float y, RadarEntityInfo info) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        poseStack.scale(0.6f, 0.6f);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)class_310.method_1551().method_1531().method_4619(info.getIcon((class_1297)null)).method_71659());
        guiGraphics.method_25290(class_10799.field_56883, info.getIcon(info.getEntityClassName()), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.popMatrix();
    }

    private static class EntityGroup {
        public GroupType groupType;
        public List<RadarEntityInfo> entities;
        public List<Integer> listColTextWidth;

        public EntityGroup(GroupType groupType) {
            this.groupType = groupType;
            this.entities = new ArrayList<RadarEntityInfo>();
            this.listColTextWidth = new ArrayList<Integer>();
        }

        public int getColWidth(int colIndex) {
            return 12 + this.listColTextWidth.get(colIndex) + 24 + 25;
        }

        public int getIconAndTextWidth(int colIndex) {
            return 12 + this.listColTextWidth.get(colIndex) + 1;
        }

        public int getTotalWidth() {
            int totalWidth = 0;
            for (int i = 0; i < this.listColTextWidth.size(); ++i) {
                totalWidth += this.getColWidth(i);
            }
            return totalWidth;
        }
    }
}

