/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.PlayerTypeInfo;
import com.aleksey.combatradar.config.RadarConfig;
import com.aleksey.combatradar.config.SoundInfo;
import com.aleksey.combatradar.gui.components.SliderButton;
import com.aleksey.combatradar.gui.screens.ChooseSoundScreen;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class PlayerSettingsScreen
extends class_437 {
    private final RadarConfig _config;
    private final class_437 _parent;
    private SliderButton _neutralRedSlider;
    private SliderButton _neutralGreenSlider;
    private SliderButton _neutralBlueSlider;
    private SliderButton _allyRedSlider;
    private SliderButton _allyGreenSlider;
    private SliderButton _allyBlueSlider;
    private SliderButton _enemyRedSlider;
    private SliderButton _enemyGreenSlider;
    private SliderButton _enemyBlueSlider;
    private class_4185 _neutralPingButton;
    private class_4185 _neutralSoundButton;
    private class_4185 _allyPingButton;
    private class_4185 _allySoundButton;
    private class_4185 _enemyPingButton;
    private class_4185 _enemySoundButton;
    private class_4185 _showYLevelButton;

    public PlayerSettingsScreen(class_437 parent, RadarConfig config) {
        super((class_2561)class_2561.method_43470((String)"Player Settings"));
        this._parent = parent;
        this._config = config;
    }

    public void method_25426() {
        int y = this.field_22790 / 4 - 16 + 12;
        int x = this.field_22789 / 2 - 100;
        PlayerTypeInfo neutralInfo = this._config.getPlayerTypeInfo(PlayerType.Neutral);
        PlayerTypeInfo allyInfo = this._config.getPlayerTypeInfo(PlayerType.Ally);
        PlayerTypeInfo enemyInfo = this._config.getPlayerTypeInfo(PlayerType.Enemy);
        this._neutralRedSlider = new SliderButton(x, y, 66, 1.0f, 0.0f, "Red", (float)neutralInfo.color.getRed() / 255.0f, false);
        this.method_37063((class_364)this._neutralRedSlider);
        this._neutralGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)neutralInfo.color.getGreen() / 255.0f, false);
        this.method_37063((class_364)this._neutralGreenSlider);
        this._neutralBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)neutralInfo.color.getBlue() / 255.0f, false);
        this.method_37063((class_364)this._neutralBlueSlider);
        this._allyRedSlider = new SliderButton(x, y += 36, 66, 1.0f, 0.0f, "Red", (float)allyInfo.color.getRed() / 255.0f, false);
        this.method_37063((class_364)this._allyRedSlider);
        this._allyGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)allyInfo.color.getGreen() / 255.0f, false);
        this.method_37063((class_364)this._allyGreenSlider);
        this._allyBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)allyInfo.color.getBlue() / 255.0f, false);
        this.method_37063((class_364)this._allyBlueSlider);
        this._enemyRedSlider = new SliderButton(x, y += 36, 66, 1.0f, 0.0f, "Red", (float)enemyInfo.color.getRed() / 255.0f, false);
        this.method_37063((class_364)this._enemyRedSlider);
        this._enemyGreenSlider = new SliderButton(x + 66 + 1, y, 66, 1.0f, 0.0f, "Green", (float)enemyInfo.color.getGreen() / 255.0f, false);
        this.method_37063((class_364)this._enemyGreenSlider);
        this._enemyBlueSlider = new SliderButton(x + 66 + 1 + 66 + 1, y, 66, 1.0f, 0.0f, "Blue", (float)enemyInfo.color.getBlue() / 255.0f, false);
        this.method_37063((class_364)this._enemyBlueSlider);
        this._neutralPingButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Neutral Player Ping"), btn -> this.changePing(PlayerType.Neutral)).method_46434(x, y += 24, 133, 20).method_46431();
        this.method_37063((class_364)this._neutralPingButton);
        this._neutralSoundButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sound"), btn -> this.changePingSound(PlayerType.Neutral)).method_46434(x + 133 + 1, y, 66, 20).method_46431();
        this.method_37063((class_364)this._neutralSoundButton);
        this._allyPingButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Ally Player Ping"), btn -> this.changePing(PlayerType.Ally)).method_46434(x, y += 24, 133, 20).method_46431();
        this.method_37063((class_364)this._allyPingButton);
        this._allySoundButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sound"), btn -> this.changePingSound(PlayerType.Ally)).method_46434(x + 133 + 1, y, 66, 20).method_46431();
        this.method_37063((class_364)this._allySoundButton);
        this._enemyPingButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Enemy Player Ping"), btn -> this.changePing(PlayerType.Enemy)).method_46434(x, y += 24, 133, 20).method_46431();
        this.method_37063((class_364)this._enemyPingButton);
        this._enemySoundButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sound"), btn -> this.changePingSound(PlayerType.Enemy)).method_46434(x + 133 + 1, y, 66, 20).method_46431();
        this.method_37063((class_364)this._enemySoundButton);
        this._showYLevelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Use Y Levels:"), btn -> {
            this._config.setShowYLevel(!this._config.getShowYLevel());
            this._config.save();
        }).method_46434(x, y += 24, 200, 20).method_46431();
        this.method_37063((class_364)this._showYLevelButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.field_22787.method_1507(this._parent)).method_46434(x, y += 24, 200, 20).method_46431());
    }

    private void changePing(PlayerType playerType) {
        PlayerTypeInfo playerTypeInfo = this._config.getPlayerTypeInfo(playerType);
        playerTypeInfo.ping = !playerTypeInfo.ping;
        this._config.save();
    }

    private void changePingSound(PlayerType playerType) {
        this.field_22787.method_1507((class_437)new ChooseSoundScreen(this, this._config, playerType));
    }

    public void method_25393() {
        Color neutralColor = new Color(this._neutralRedSlider.getValue(), this._neutralGreenSlider.getValue(), this._neutralBlueSlider.getValue());
        Color allyColor = new Color(this._allyRedSlider.getValue(), this._allyGreenSlider.getValue(), this._allyBlueSlider.getValue());
        Color enemyColor = new Color(this._enemyRedSlider.getValue(), this._enemyGreenSlider.getValue(), this._enemyBlueSlider.getValue());
        boolean isChanged = this.changeColor(PlayerType.Neutral, neutralColor);
        isChanged = this.changeColor(PlayerType.Ally, allyColor) || isChanged;
        boolean bl = isChanged = this.changeColor(PlayerType.Enemy, enemyColor) || isChanged;
        if (isChanged) {
            this._config.save();
        }
        PlayerTypeInfo neutralPlayer = this._config.getPlayerTypeInfo(PlayerType.Neutral);
        PlayerTypeInfo allyPlayer = this._config.getPlayerTypeInfo(PlayerType.Ally);
        PlayerTypeInfo enemyPlayer = this._config.getPlayerTypeInfo(PlayerType.Enemy);
        this._neutralPingButton.method_25355((class_2561)class_2561.method_43470((String)("Neutral Player Ping: " + (neutralPlayer.ping ? "On" : "Off"))));
        this._neutralSoundButton.method_25355((class_2561)class_2561.method_43470((String)SoundInfo.getByValue((String)neutralPlayer.soundEventName).name));
        this._allyPingButton.method_25355((class_2561)class_2561.method_43470((String)("Ally Player Ping: " + (allyPlayer.ping ? "On" : "Off"))));
        this._allySoundButton.method_25355((class_2561)class_2561.method_43470((String)SoundInfo.getByValue((String)allyPlayer.soundEventName).name));
        this._enemyPingButton.method_25355((class_2561)class_2561.method_43470((String)("Enemy Player Ping: " + (enemyPlayer.ping ? "On" : "Off"))));
        this._enemySoundButton.method_25355((class_2561)class_2561.method_43470((String)SoundInfo.getByValue((String)enemyPlayer.soundEventName).name));
        this._showYLevelButton.method_25355((class_2561)class_2561.method_43470((String)("Use Y Levels: " + (this._config.getShowYLevel() ? "On" : "Off"))));
    }

    private boolean changeColor(PlayerType playerType, Color color) {
        PlayerTypeInfo info = this._config.getPlayerTypeInfo(playerType);
        if (info.color == color) {
            return false;
        }
        info.color = color;
        return true;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 4 - 40, Color.WHITE.getRGB());
        guiGraphics.method_25300(this.field_22793, "Neutral", this.field_22789 / 2, this._neutralRedSlider.method_46427() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Neutral).color.getRGB());
        guiGraphics.method_25300(this.field_22793, "Ally", this.field_22789 / 2, this._allyRedSlider.method_46427() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Ally).color.getRGB());
        guiGraphics.method_25300(this.field_22793, "Enemy", this.field_22789 / 2, this._enemyRedSlider.method_46427() - 12, this._config.getPlayerTypeInfo((PlayerType)PlayerType.Enemy).color.getRGB());
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_52752(guiGraphics);
    }

    public void method_52752(class_332 guiGraphics) {
        guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, 0, 0);
    }
}

