/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.config;

import com.aleksey.combatradar.config.GroupType;
import com.aleksey.combatradar.config.RadarEntityInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;

public class RadarHorseInfo
extends RadarEntityInfo {
    private static final String[] HORSE_VARIANTS = new String[]{"white", "creamy", "chestnut", "brown", "black", "gray", "darkbrown"};
    private final ResourceLocation[] _icons;
    private final ResourceLocation _skeletonHorse;

    public RadarHorseInfo(String name, String iconPath, GroupType groupType) {
        super(Horse.class, name, iconPath, groupType);
        this.addEntity(SkeletonHorse.class, null);
        this._icons = new ResourceLocation[HORSE_VARIANTS.length];
        for (int i = 0; i < HORSE_VARIANTS.length; ++i) {
            this._icons[i] = ResourceLocation.fromNamespaceAndPath((String)"combatradar", (String)("icons/horse/horse_" + HORSE_VARIANTS[i] + ".png"));
        }
        this._skeletonHorse = ResourceLocation.fromNamespaceAndPath((String)"combatradar", (String)"icons/horse/horse_skeleton.png");
    }

    @Override
    public ResourceLocation getIcon(Entity entity) {
        if (entity == null) {
            return super.getIcon(entity);
        }
        if (entity instanceof SkeletonHorse) {
            return this._skeletonHorse;
        }
        Horse horseEntity = (Horse)entity;
        int horseVariant = horseEntity.getVariant().ordinal() % 7;
        return this._icons[horseVariant];
    }
}

