/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

public record CircleElementRenderState(RenderPipeline pipeline, Matrix3x2f pose, ScreenRectangle scissorArea, float radius, int color) implements GuiElementRenderState
{
    public void buildVertices(VertexConsumer vertices) {
        vertices.addVertexWith2DPose(this.pose, 0.0f, 0.0f).setColor(this.color);
        for (int i = 360; i >= 0; --i) {
            double theta = Math.toRadians(i);
            vertices.addVertexWith2DPose(this.pose, (float)(Math.cos(theta) * (double)this.radius), (float)(Math.sin(theta) * (double)this.radius)).setColor(this.color);
        }
    }

    @NotNull
    public TextureSetup textureSetup() {
        return TextureSetup.noTexture();
    }

    public ScreenRectangle bounds() {
        ScreenRectangle screenRect = new ScreenRectangle(new ScreenPosition((int)this.radius, (int)this.radius), (int)Math.ceil(this.radius * 2.0f), (int)Math.ceil(this.radius * 2.0f)).transformMaxBounds(this.pose);
        return this.scissorArea != null ? this.scissorArea.intersection(screenRect) : screenRect;
    }
}

