/*
 * Decompiled with CFR 0.152.
 */
package com.aleksey.combatradar.gui.screens;

import com.aleksey.combatradar.config.PlayerType;
import com.aleksey.combatradar.config.RadarConfig;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AddPlayerScreen
extends Screen {
    private final RadarConfig _config;
    private final Screen _parent;
    private final PlayerType _playerType;
    private EditBox _playerNameEditBox;

    public AddPlayerScreen(Screen parent, RadarConfig config, PlayerType playerType) {
        super((Component)Component.literal((String)(playerType == PlayerType.Ally ? "Ally" : "Enemy")));
        this._parent = parent;
        this._config = config;
        this._playerType = playerType;
    }

    protected void init() {
        int y = this.height / 3;
        int x = this.width / 2 - 100;
        this._playerNameEditBox = new EditBox(this.font, x, y, 200, 20, CommonComponents.EMPTY);
        this.addRenderableWidget((GuiEventListener)this._playerNameEditBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Add"), button -> this.actionAdd()).bounds(x, y += 24, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.actionCancel()).bounds(x, y += 24, 200, 20).build());
        this.setInitialFocus((GuiEventListener)this._playerNameEditBox);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.key()) {
            case 257: {
                this.actionAdd();
                return true;
            }
            case 256: {
                this.actionCancel();
                return true;
            }
        }
        return super.keyPressed(keyEvent);
    }

    private void actionAdd() {
        String playerName = this._playerNameEditBox.getValue().trim();
        if (playerName.isEmpty()) {
            return;
        }
        this._config.setPlayerType(playerName, this._playerType);
        this._config.save();
        this.minecraft.setScreen(this._parent);
    }

    private void actionCancel() {
        this.minecraft.setScreen(this._parent);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 4 - 40, Color.WHITE.getRGB());
        guiGraphics.drawString(this.font, "Player username", (int)((float)this.width / 2.0f - 100.0f), this._playerNameEditBox.getY() - 12, Color.LIGHT_GRAY.getRGB(), true);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

