package com.boyonk.bandanas.client.data;

import com.boyonk.bandanas.Bandanas;
import com.boyonk.bandanas.item.equipment.BandanasEquipmentAssetKeys;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10186;
import net.minecraft.class_10394;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class BandanasDataGenerator implements DataGeneratorEntrypoint {

	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		FabricDataGenerator.Pack pack = generator.createPack();
		pack.addProvider(BandanasModelsProvider::new);
		pack.addProvider(BandanasEquipmentAssetProvider::new);
		pack.addProvider(BandanasRecipesProvider::new);
		pack.addProvider(BandanasItemTags::new);

	}


	private static class BandanasModelsProvider extends FabricModelProvider {

		public BandanasModelsProvider(FabricDataOutput output) {
			super(output);
		}

		@Override
		public void generateBlockStateModels(class_4910 generator) {

		}

		@Override
		public void generateItemModels(class_4915 generator) {
			generator.method_65442(Bandanas.WHITE_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.ORANGE_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.MAGENTA_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.LIGHT_BLUE_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.YELLOW_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.LIME_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.PINK_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.GRAY_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.LIGHT_GRAY_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.CYAN_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.PURPLE_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.BLUE_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.BROWN_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.GREEN_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.RED_BANDANA, class_4943.field_22938);
			generator.method_65442(Bandanas.BLACK_BANDANA, class_4943.field_22938);
		}
	}

	private static class BandanasEquipmentAssetProvider implements class_2405 {
		private final class_7784.class_7489 pathResolver;

		public BandanasEquipmentAssetProvider(FabricDataOutput output) {
			this.pathResolver = output.method_45973(class_7784.class_7490.field_39368, "equipment");
		}

		static void bootstrap(BiConsumer<class_5321<class_10394>, class_10186.class_10187> consumer) {
			consumer.accept(BandanasEquipmentAssetKeys.WHITE_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.WHITE_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.ORANGE_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.ORANGE_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.MAGENTA_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.MAGENTA_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.LIGHT_BLUE_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.LIGHT_BLUE_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.YELLOW_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.YELLOW_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.LIME_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.LIME_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.PINK_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.PINK_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.GRAY_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.GRAY_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.LIGHT_GRAY_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.LIGHT_GRAY_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.CYAN_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.CYAN_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.PURPLE_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.PURPLE_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.BLUE_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.BLUE_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.BROWN_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.BROWN_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.GREEN_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.GREEN_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.RED_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.RED_BANDANA.method_29177(), false)));
			consumer.accept(BandanasEquipmentAssetKeys.BLACK_BANDANA, class_10186.method_63994().method_64001(class_10186.class_10190.field_54126, class_10186.class_10189.method_64009(BandanasEquipmentAssetKeys.BLACK_BANDANA.method_29177(), false)));
		}

		@Override
		public CompletableFuture<?> method_10319(class_7403 writer) {
			Map<class_5321<class_10394>, class_10186> map = new HashMap<>();
			BandanasEquipmentAssetProvider.bootstrap((key, model) -> {
				if (map.putIfAbsent(key, model.method_63997()) != null) {
					throw new IllegalStateException("Tried to register equipment model twice for id: " + key);
				}
			});
			return class_2405.method_65771(writer, class_10186.field_54120, this.pathResolver::method_65773, map);
		}

		@Override
		public String method_10321() {
			return "Equipment Model Definitions";
		}
	}

	private static class BandanasRecipesProvider extends FabricRecipeProvider {

		public BandanasRecipesProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected class_2446 method_62766(class_7225.class_7874 registries, class_8790 exporter) {
			return new class_2446(registries, exporter) {
				@Override
				public void method_10419() {
					this.offerBandanaRecipe(Bandanas.WHITE_BANDANA, class_1802.field_19044);
					this.offerBandanaRecipe(Bandanas.ORANGE_BANDANA, class_1802.field_19045);
					this.offerBandanaRecipe(Bandanas.MAGENTA_BANDANA, class_1802.field_19046);
					this.offerBandanaRecipe(Bandanas.LIGHT_BLUE_BANDANA, class_1802.field_19047);
					this.offerBandanaRecipe(Bandanas.YELLOW_BANDANA, class_1802.field_19048);
					this.offerBandanaRecipe(Bandanas.LIME_BANDANA, class_1802.field_19049);
					this.offerBandanaRecipe(Bandanas.PINK_BANDANA, class_1802.field_19050);
					this.offerBandanaRecipe(Bandanas.GRAY_BANDANA, class_1802.field_19051);
					this.offerBandanaRecipe(Bandanas.LIGHT_GRAY_BANDANA, class_1802.field_19052);
					this.offerBandanaRecipe(Bandanas.CYAN_BANDANA, class_1802.field_19053);
					this.offerBandanaRecipe(Bandanas.PURPLE_BANDANA, class_1802.field_19054);
					this.offerBandanaRecipe(Bandanas.BLUE_BANDANA, class_1802.field_19055);
					this.offerBandanaRecipe(Bandanas.BROWN_BANDANA, class_1802.field_19056);
					this.offerBandanaRecipe(Bandanas.GREEN_BANDANA, class_1802.field_19057);
					this.offerBandanaRecipe(Bandanas.RED_BANDANA, class_1802.field_19058);
					this.offerBandanaRecipe(Bandanas.BLACK_BANDANA, class_1802.field_19059);
				}

				private void offerBandanaRecipe(class_1935 output, class_1935 input) {
					this.method_62746(class_7800.field_40639, output)
							.method_10434('#', input)
							.method_10433('s', ConventionalItemTags.STRINGS)
							.method_10439("###")
							.method_10439("s s")
							.method_10435("bandana")
							.method_10429(method_32807(input), method_10426(input))
							.method_10431(this.field_53721);
				}
			};


		}


		@Override
		public String method_10321() {
			return "Recipes";
		}
	}

	private static class BandanasItemTags extends FabricTagProvider.ItemTagProvider {

		public BandanasItemTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
			super(output, completableFuture);
		}

		@Override
		protected void method_10514(class_7225.class_7874 wrapperLookup) {
			this.valueLookupBuilder(Bandanas.TAG).method_71558(
					Bandanas.WHITE_BANDANA,
					Bandanas.ORANGE_BANDANA,
					Bandanas.MAGENTA_BANDANA,
					Bandanas.LIGHT_BLUE_BANDANA,
					Bandanas.YELLOW_BANDANA,
					Bandanas.LIME_BANDANA,
					Bandanas.PINK_BANDANA,
					Bandanas.GRAY_BANDANA,
					Bandanas.LIGHT_GRAY_BANDANA,
					Bandanas.CYAN_BANDANA,
					Bandanas.PURPLE_BANDANA,
					Bandanas.BLUE_BANDANA,
					Bandanas.BROWN_BANDANA,
					Bandanas.GREEN_BANDANA,
					Bandanas.RED_BANDANA,
					Bandanas.BLACK_BANDANA
			);
		}
	}
}
