/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock;

import com.iridium.iridiumskyblock.configs.BankItems;
import com.iridium.iridiumskyblock.configs.Biomes;
import com.iridium.iridiumskyblock.configs.BlockValues;
import com.iridium.iridiumskyblock.configs.Commands;
import com.iridium.iridiumskyblock.configs.Configuration;
import com.iridium.iridiumskyblock.configs.Enhancements;
import com.iridium.iridiumskyblock.configs.Generators;
import com.iridium.iridiumskyblock.configs.Inventories;
import com.iridium.iridiumskyblock.configs.Messages;
import com.iridium.iridiumskyblock.configs.Missions;
import com.iridium.iridiumskyblock.configs.Permissions;
import com.iridium.iridiumskyblock.configs.SQL;
import com.iridium.iridiumskyblock.configs.Schematics;
import com.iridium.iridiumskyblock.configs.Settings;
import com.iridium.iridiumskyblock.configs.Shop;
import com.iridium.iridiumskyblock.configs.Top;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.MissionManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.ShopManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.SupportManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportManager;
import com.iridium.iridiumskyblock.dependencies.xseries.reflection.XReflection;
import com.iridium.iridiumskyblock.generators.FlatGenerator;
import com.iridium.iridiumskyblock.generators.OceanGenerator;
import com.iridium.iridiumskyblock.generators.VoidGenerator;
import com.iridium.iridiumskyblock.listeners.BlockFormListener;
import com.iridium.iridiumskyblock.listeners.EnhancementUpdateListener;
import com.iridium.iridiumskyblock.listeners.EntityDamageListener;
import com.iridium.iridiumskyblock.listeners.PlayerInteractListener;
import com.iridium.iridiumskyblock.listeners.PlayerJoinListener;
import com.iridium.iridiumskyblock.listeners.PlayerMoveListener;
import com.iridium.iridiumskyblock.listeners.PlayerPortalListener;
import com.iridium.iridiumskyblock.listeners.PlayerRespawnEventListener;
import com.iridium.iridiumskyblock.listeners.PlayerTeleportListener;
import com.iridium.iridiumskyblock.listeners.PortalCreateListener;
import com.iridium.iridiumskyblock.managers.BiomeManager;
import com.iridium.iridiumskyblock.managers.CommandManager;
import com.iridium.iridiumskyblock.managers.DatabaseManager;
import com.iridium.iridiumskyblock.managers.GeneratorType;
import com.iridium.iridiumskyblock.managers.IslandManager;
import com.iridium.iridiumskyblock.managers.SchematicManager;
import com.iridium.iridiumskyblock.managers.UserManager;
import com.iridium.iridiumskyblock.placeholders.IslandPlaceholderBuilder;
import com.iridium.iridiumskyblock.placeholders.TeamChatPlaceholderBuilder;
import com.iridium.iridiumskyblock.placeholders.UserPlaceholderBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPluginLoader;

public class IridiumSkyblock
extends IridiumTeams<Island, User> {
    private static IridiumSkyblock instance;
    private Configuration configuration;
    private Messages messages;
    private Permissions permissions;
    private Inventories inventories;
    private Commands commands;
    private BankItems bankItems;
    private Enhancements enhancements;
    private BlockValues blockValues;
    private Top top;
    private SQL sql;
    private Missions missions;
    private Schematics schematics;
    private Shop shop;
    private Biomes biomes;
    private Settings settings;
    private Generators generators;
    private IslandPlaceholderBuilder teamsPlaceholderBuilder;
    private UserPlaceholderBuilder userPlaceholderBuilder;
    private TeamChatPlaceholderBuilder teamChatPlaceholderBuilder;
    private IslandManager teamManager;
    private UserManager userManager;
    private CommandManager commandManager;
    private DatabaseManager databaseManager;
    private MissionManager<Island, User> missionManager;
    private SchematicManager schematicManager;
    private ShopManager<Island, User> shopManager;
    private BiomeManager biomeManager;
    private SupportManager<Island, User> supportManager;
    private TeleportManager<Island, User> teleportManager;
    private Economy economy;
    private ChunkGenerator chunkGenerator;

    public IridiumSkyblock(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        instance = this;
    }

    public IridiumSkyblock() {
        instance = this;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.getLogger().info("Loading world generator...");
        this.getLogger().info("Generator Type = " + (Object)((Object)IridiumSkyblock.getInstance().getConfiguration().generatorType));
        switch (IridiumSkyblock.getInstance().getConfiguration().generatorType) {
            case OCEAN: {
                this.chunkGenerator = new OceanGenerator();
                break;
            }
            case FLAT: {
                this.chunkGenerator = new FlatGenerator();
                break;
            }
            case VANILLA: {
                this.chunkGenerator = null;
                break;
            }
            case VOID: {
                this.chunkGenerator = new VoidGenerator();
                break;
            }
            default: {
                this.getLogger().warning("Invalid generator type [" + (Object)((Object)IridiumSkyblock.getInstance().getConfiguration().generatorType) + "], valid types are " + Arrays.toString((Object[])GeneratorType.values()));
                this.getLogger().info("Generator Type = " + (Object)((Object)GeneratorType.VOID));
                this.chunkGenerator = new VoidGenerator();
            }
        }
    }

    @Override
    public void onEnable() {
        instance = this;
        this.teamManager = new IslandManager();
        this.teamManager.createWorld(World.Environment.NORMAL, this.configuration.worldName);
        this.teamManager.createWorld(World.Environment.NETHER, this.configuration.worldName + "_nether");
        this.teamManager.createWorld(World.Environment.THE_END, this.configuration.worldName + "_the_end");
        this.schematicManager = new SchematicManager();
        this.userManager = new UserManager();
        this.commandManager = new CommandManager("iridiumskyblock");
        this.databaseManager = new DatabaseManager();
        this.missionManager = new MissionManager<Island, User>(this);
        this.shopManager = new ShopManager<Island, User>(this);
        this.biomeManager = new BiomeManager();
        this.supportManager = new SupportManager<Island, User>(this);
        this.teleportManager = new TeleportManager<Island, User>(this);
        this.supportManager.registerSupport();
        try {
            this.databaseManager.init();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            this.economy = this.setupEconomy();
        });
        Bukkit.getServer().getOnlinePlayers().forEach(player -> this.getIslandManager().sendIslandBorder((Player)player));
        this.addBstats(5825);
        this.startUpdateChecker(62480);
        super.onEnable();
        this.teamsPlaceholderBuilder = new IslandPlaceholderBuilder();
        this.userPlaceholderBuilder = new UserPlaceholderBuilder();
        this.teamChatPlaceholderBuilder = new TeamChatPlaceholderBuilder();
    }

    private Economy setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            this.getLogger().warning("You do not have an economy plugin installed (like Essentials)");
            return null;
        }
        return (Economy)economyProvider.getProvider();
    }

    @Override
    public void registerListeners() {
        super.registerListeners();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerMoveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockFormListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EnhancementUpdateListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerTeleportListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerPortalListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerRespawnEventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EntityDamageListener(), (Plugin)this);
        if (!XReflection.supports(15)) {
            Bukkit.getPluginManager().registerEvents((Listener)new PortalCreateListener(), (Plugin)this);
        }
    }

    @Override
    public void loadConfigs() {
        this.configuration = this.getPersist().load(Configuration.class);
        this.messages = this.getPersist().load(Messages.class);
        this.commands = this.getPersist().load(Commands.class);
        this.sql = this.getPersist().load(SQL.class);
        this.inventories = this.getPersist().load(Inventories.class);
        this.permissions = this.getPersist().load(Permissions.class);
        this.bankItems = this.getPersist().load(BankItems.class);
        this.enhancements = this.getPersist().load(Enhancements.class);
        this.blockValues = this.getPersist().load(BlockValues.class);
        this.top = this.getPersist().load(Top.class);
        this.missions = this.getPersist().load(Missions.class);
        this.schematics = this.getPersist().load(Schematics.class);
        this.shop = this.getPersist().load(Shop.class);
        this.biomes = this.getPersist().load(Biomes.class);
        this.settings = this.getPersist().load(Settings.class);
        this.generators = this.getPersist().load(Generators.class);
        this.getLogger().info("GENERATOR TYPE: " + (Object)((Object)IridiumSkyblock.getInstance().getConfiguration().generatorType));
        super.loadConfigs();
        int maxSize = this.enhancements.sizeEnhancement.levels.values().stream().max(Comparator.comparing(sizeUpgrade -> sizeUpgrade.size)).map(sizeEnhancementData -> sizeEnhancementData.size).orElse(150);
        if (this.configuration.distance <= maxSize) {
            this.getLogger().warning("Distance: " + this.configuration.distance + " Is too low, must be higher than the maximum island size " + maxSize);
            this.configuration.distance = maxSize + 1;
            this.getLogger().warning("New Distance set to: " + this.configuration.distance);
        }
        if (this.schematicManager != null) {
            this.schematicManager.reload();
        }
        this.migrateData();
    }

    @Override
    public void saveConfigs() {
        super.saveConfigs();
        this.getPersist().save(this.configuration);
        this.getPersist().save(this.messages);
        this.getPersist().save(this.commands);
        this.getPersist().save(this.sql);
        this.getPersist().save(this.inventories);
        this.getPersist().save(this.permissions);
        this.getPersist().save(this.bankItems);
        this.getPersist().save(this.enhancements);
        this.getPersist().save(this.blockValues);
        this.getPersist().save(this.top);
        this.getPersist().save(this.missions);
        this.getPersist().save(this.schematics);
        this.getPersist().save(this.shop);
        this.getPersist().save(this.biomes);
        this.getPersist().save(this.settings);
        this.getPersist().save(this.generators);
        this.saveSchematics();
    }

    @Override
    public void saveData() {
        this.getDatabaseManager().getUserTableManager().save();
        this.getDatabaseManager().getIslandTableManager().save();
        this.getDatabaseManager().getInvitesTableManager().save();
        this.getDatabaseManager().getTrustTableManager().save();
        this.getDatabaseManager().getPermissionsTableManager().save();
        this.getDatabaseManager().getBankTableManager().save();
        this.getDatabaseManager().getEnhancementTableManager().save();
        this.getDatabaseManager().getTeamBlockTableManager().save();
        this.getDatabaseManager().getTeamSpawnerTableManager().save();
        this.getDatabaseManager().getTeamWarpTableManager().save();
        this.getDatabaseManager().getTeamMissionTableManager().save();
        this.getDatabaseManager().getTeamMissionDataTableManager().save();
        this.getDatabaseManager().getTeamRewardsTableManager().save();
        this.getDatabaseManager().getTeamSettingsTableManager().save();
        this.getDatabaseManager().getLostItemsTableManager().save();
    }

    @Override
    public void initializeBankItem() {
        super.initializeBankItem();
        this.addBankItem(this.getBankItems().crystalsBankItem);
    }

    @Override
    public void initializeEnhancements() {
        super.initializeEnhancements();
        this.addEnhancement("size", this.getEnhancements().sizeEnhancement);
        this.addEnhancement("void", this.getEnhancements().voidEnhancement);
        this.addEnhancement("generator", this.getEnhancements().generatorEnhancement);
    }

    @Override
    public void initializePermissions() {
        super.initializePermissions();
        this.addPermission("border", this.getPermissions().border);
        this.addPermission("regen", this.getPermissions().regen);
    }

    private void saveSchematics() {
        File schematicFolder = new File(this.getDataFolder(), "schematics");
        if (!schematicFolder.exists()) {
            schematicFolder.mkdir();
        }
        if (Objects.requireNonNull(schematicFolder.list()).length != 0) {
            return;
        }
        this.saveFile(schematicFolder, "desert.schem");
        this.saveFile(schematicFolder, "mushroom.schem");
        this.saveFile(schematicFolder, "jungle.schem");
        this.saveFile(schematicFolder, "desert_nether.schem");
        this.saveFile(schematicFolder, "mushroom_nether.schem");
        this.saveFile(schematicFolder, "jungle_nether.schem");
        this.saveFile(schematicFolder, "desert_end.schem");
        this.saveFile(schematicFolder, "mushroom_end.schem");
        this.saveFile(schematicFolder, "jungle_end.schem");
    }

    private void saveFile(File parent, String name) {
        File file = new File(parent, name);
        if (!file.exists()) {
            try {
                InputStream source = this.getResource(name);
                Path target = file.toPath();
                if (source == null) {
                    return;
                }
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exception) {
                this.getLogger().warning("Could not copy " + name + " to " + file.getAbsolutePath());
            }
        }
    }

    public void migrateData() {
        this.processFields(BankItems.class, this.getBankItems(), 0);
        this.processFields(BlockValues.class, this.getBlockValues(), 0);
        this.processFields(Commands.class, this.getCommands(), 0);
        this.processFields(Configuration.class, this.getConfiguration(), 0);
        this.processFields(Enhancements.class, this.getEnhancements(), 0);
        this.processFields(Inventories.class, this.getInventories(), 0);
        this.processFields(Messages.class, this.getMessages(), 0);
        this.processFields(Missions.class, this.getMissions(), 0);
        this.processFields(Permissions.class, this.getPermissions(), 0);
        this.processFields(Settings.class, this.getSettings(), 0);
        this.processFields(Shop.class, this.getShop(), 0);
        this.processFields(Top.class, this.getTop(), 0);
        this.getInventories().islandMenu.items.values().forEach(Item::migrateData);
        this.getSchematics().schematics.values().forEach(schematicConfig -> schematicConfig.item.migrateData());
    }

    private void processFields(Class<?> clazz, Object instance, int depth) {
        Field[] fields;
        if (depth > 3) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getType().getName().startsWith("com.iridium")) continue;
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(instance);
                if (fieldValue == null) continue;
                Class<?> fieldType = fieldValue.getClass();
                if (this.isItemClass(fieldType)) {
                    this.invokeMigrateMethod(fieldValue);
                    continue;
                }
                this.processFields(fieldType, fieldValue, depth + 1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isItemClass(Class<?> clazz) {
        if (clazz.getName().equals("com.iridium.iridiumskyblock.dependencies.iridiumcore.Item")) {
            return true;
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        return enclosingClass != null && this.isItemClass(enclosingClass);
    }

    private void invokeMigrateMethod(Object itemInstance) {
        try {
            Method migrateMethod = itemInstance.getClass().getMethod("migrateData", new Class[0]);
            migrateMethod.invoke(itemInstance, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.chunkGenerator;
    }

    public IslandManager getIslandManager() {
        return this.teamManager;
    }

    public static IridiumSkyblock getInstance() {
        return instance;
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    @Generated
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    @Generated
    public Inventories getInventories() {
        return this.inventories;
    }

    @Generated
    public Commands getCommands() {
        return this.commands;
    }

    @Override
    @Generated
    public BankItems getBankItems() {
        return this.bankItems;
    }

    @Override
    @Generated
    public Enhancements getEnhancements() {
        return this.enhancements;
    }

    @Override
    @Generated
    public BlockValues getBlockValues() {
        return this.blockValues;
    }

    @Generated
    public Top getTop() {
        return this.top;
    }

    @Generated
    public SQL getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public Missions getMissions() {
        return this.missions;
    }

    @Generated
    public Schematics getSchematics() {
        return this.schematics;
    }

    @Override
    @Generated
    public Shop getShop() {
        return this.shop;
    }

    @Generated
    public Biomes getBiomes() {
        return this.biomes;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public Generators getGenerators() {
        return this.generators;
    }

    @Generated
    public IslandPlaceholderBuilder getTeamsPlaceholderBuilder() {
        return this.teamsPlaceholderBuilder;
    }

    @Generated
    public UserPlaceholderBuilder getUserPlaceholderBuilder() {
        return this.userPlaceholderBuilder;
    }

    @Override
    @Generated
    public TeamChatPlaceholderBuilder getTeamChatPlaceholderBuilder() {
        return this.teamChatPlaceholderBuilder;
    }

    @Generated
    public IslandManager getTeamManager() {
        return this.teamManager;
    }

    @Generated
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    @Override
    @Generated
    public MissionManager<Island, User> getMissionManager() {
        return this.missionManager;
    }

    @Generated
    public SchematicManager getSchematicManager() {
        return this.schematicManager;
    }

    @Override
    @Generated
    public ShopManager<Island, User> getShopManager() {
        return this.shopManager;
    }

    @Generated
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    @Override
    @Generated
    public SupportManager<Island, User> getSupportManager() {
        return this.supportManager;
    }

    @Override
    @Generated
    public TeleportManager<Island, User> getTeleportManager() {
        return this.teleportManager;
    }

    @Override
    @Generated
    public Economy getEconomy() {
        return this.economy;
    }

    @Generated
    public ChunkGenerator getChunkGenerator() {
        return this.chunkGenerator;
    }
}

